/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.logging.LoggingManagerInternal;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ProGuardTask
extends DefaultTask {
    private final List inJarFiles = new ArrayList();
    private final List inJarFilters = new ArrayList();
    private final List outJarFiles = new ArrayList();
    private final List outJarFilters = new ArrayList();
    private final List inJarCounts = new ArrayList();
    private final List libraryJarFiles = new ArrayList();
    private final List libraryJarFilters = new ArrayList();
    private final List configurationFiles = new ArrayList();
    private final Configuration configuration = new Configuration();
    private ClassSpecification classSpecification;

    @InputFiles
    protected FileCollection getInJarFileCollection() {
        return this.getProject().files(new Object[]{this.inJarFiles});
    }

    @Optional
    @OutputFiles
    protected FileCollection getOutJarFileCollection() {
        return this.getProject().files(new Object[]{this.outJarFiles});
    }

    @InputFiles
    protected FileCollection getLibraryJarFileCollection() {
        return this.getProject().files(new Object[]{this.libraryJarFiles});
    }

    @InputFiles
    protected FileCollection getConfigurationFileCollection() {
        return this.getProject().files(new Object[]{this.configurationFiles});
    }

    public List getInJarFiles() {
        return this.inJarFiles;
    }

    public List getInJarFilters() {
        return this.inJarFilters;
    }

    public List getOutJarFiles() {
        return this.outJarFiles;
    }

    public List getOutJarFilters() {
        return this.outJarFilters;
    }

    public List getInJarCounts() {
        return this.inJarCounts;
    }

    public List getLibraryJarFiles() {
        return this.libraryJarFiles;
    }

    public List getLibraryJarFilters() {
        return this.libraryJarFilters;
    }

    public List getConfigurationFiles() {
        return this.configurationFiles;
    }

    public void configuration(Object object) throws ParseException, IOException {
        this.configurationFiles.add(object);
    }

    public void injars(Object object) throws ParseException {
        this.injars(null, object);
    }

    public void injars(Map map, Object object) throws ParseException {
        this.inJarFiles.add(object);
        this.inJarFilters.add(map);
    }

    public void outjars(Object object) throws ParseException {
        this.outjars(null, object);
    }

    public void outjars(Map map, Object object) throws ParseException {
        this.outJarFiles.add(object);
        this.outJarFilters.add(map);
        this.inJarCounts.add(this.inJarFiles.size());
    }

    public void libraryjars(Object object) throws ParseException {
        this.libraryjars(null, object);
    }

    public void libraryjars(Map map, Object object) throws ParseException {
        this.libraryJarFiles.add(object);
        this.libraryJarFilters.add(map);
    }

    public Object getskipnonpubliclibraryclasses() {
        this.skipnonpubliclibraryclasses();
        return null;
    }

    public void skipnonpubliclibraryclasses() {
        this.configuration.skipNonPublicLibraryClasses = true;
    }

    public Object getdontskipnonpubliclibraryclassmembers() {
        this.dontskipnonpubliclibraryclassmembers();
        return null;
    }

    public void dontskipnonpubliclibraryclassmembers() {
        this.configuration.skipNonPublicLibraryClassMembers = false;
    }

    public Object getkeepdirectories() {
        this.keepdirectories();
        return null;
    }

    public void keepdirectories() {
        this.keepdirectories(null);
    }

    public void keepdirectories(String string) {
        this.configuration.keepDirectories = this.extendFilter(this.configuration.keepDirectories, string);
    }

    public void target(String string) {
        this.configuration.targetClassVersion = ClassUtil.internalClassVersion(string);
    }

    public Object getforceprocessing() {
        this.forceprocessing();
        return null;
    }

    public void forceprocessing() {
        this.configuration.lastModified = Long.MAX_VALUE;
    }

    public void keep(String string) throws ParseException {
        this.keep(null, string);
    }

    public void keep(Map map, String string) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(false, true, false, map, string));
    }

    public void keep(Map map) throws ParseException {
        this.keep(map, (Closure)null);
    }

    public void keep(Map map, Closure closure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(false, true, false, map, closure));
    }

    public void keepclassmembers(String string) throws ParseException {
        this.keepclassmembers(null, string);
    }

    public void keepclassmembers(Map map, String string) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(false, false, false, map, string));
    }

    public void keepclassmembers(Map map) throws ParseException {
        this.keepclassmembers(map, (Closure)null);
    }

    public void keepclassmembers(Map map, Closure closure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(false, false, false, map, closure));
    }

    public void keepclasseswithmembers(String string) throws ParseException {
        this.keepclasseswithmembers(null, string);
    }

    public void keepclasseswithmembers(Map map, String string) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(false, false, true, map, string));
    }

    public void keepclasseswithmembers(Map map) throws ParseException {
        this.keepclasseswithmembers(map, (Closure)null);
    }

    public void keepclasseswithmembers(Map map, Closure closure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(false, false, true, map, closure));
    }

    public void keepnames(String string) throws ParseException {
        this.keepnames(null, string);
    }

    public void keepnames(Map map, String string) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(true, true, false, map, string));
    }

    public void keepnames(Map map) throws ParseException {
        this.keepnames(map, (Closure)null);
    }

    public void keepnames(Map map, Closure closure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(true, true, false, map, closure));
    }

    public void keepclassmembernames(String string) throws ParseException {
        this.keepclassmembernames(null, string);
    }

    public void keepclassmembernames(Map map, String string) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(true, false, false, map, string));
    }

    public void keepclassmembernames(Map map) throws ParseException {
        this.keepclassmembernames(map, (Closure)null);
    }

    public void keepclassmembernames(Map map, Closure closure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(true, false, false, map, closure));
    }

    public void keepclasseswithmembernames(String string) throws ParseException {
        this.keepclasseswithmembernames(null, string);
    }

    public void keepclasseswithmembernames(Map map, String string) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(true, false, true, map, string));
    }

    public void keepclasseswithmembernames(Map map) throws ParseException {
        this.keepclasseswithmembernames(map, (Closure)null);
    }

    public void keepclasseswithmembernames(Map map, Closure closure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, this.createKeepClassSpecification(true, false, true, map, closure));
    }

    public Object getprintseeds() {
        this.printseeds();
        return null;
    }

    public void printseeds() {
        this.configuration.printSeeds = Configuration.STD_OUT;
    }

    public void printseeds(Object object) throws ParseException {
        this.configuration.printSeeds = this.getProject().file(object);
    }

    public Object getdontshrink() {
        this.dontshrink();
        return null;
    }

    public void dontshrink() {
        this.configuration.shrink = false;
    }

    public Object getprintusage() {
        this.printusage();
        return null;
    }

    public void printusage() {
        this.configuration.printUsage = Configuration.STD_OUT;
    }

    public void printusage(Object object) throws ParseException {
        this.configuration.printUsage = this.getProject().file(object);
    }

    public void whyareyoukeeping(String string) throws ParseException {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, this.createClassSpecification(string));
    }

    public void whyareyoukeeping(Map map) throws ParseException {
        this.whyareyoukeeping(map, null);
    }

    public void whyareyoukeeping(Map map, Closure closure) throws ParseException {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, this.createClassSpecification(map, closure));
    }

    public Object getdontoptimize() {
        this.dontoptimize();
        return null;
    }

    public void dontoptimize() {
        this.configuration.optimize = false;
    }

    public void optimizations(String string) {
        this.configuration.optimizations = this.extendFilter(this.configuration.optimizations, string);
    }

    public void optimizationpasses(int n) {
        this.configuration.optimizationPasses = n;
    }

    public void assumenosideeffects(String string) throws ParseException {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, this.createClassSpecification(string));
    }

    public void assumenosideeffects(Map map, Closure closure) throws ParseException {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, this.createClassSpecification(map, closure));
    }

    public Object getallowaccessmodification() {
        this.allowaccessmodification();
        return null;
    }

    public void allowaccessmodification() {
        this.configuration.allowAccessModification = true;
    }

    public Object getmergeinterfacesaggressively() {
        this.mergeinterfacesaggressively();
        return null;
    }

    public void mergeinterfacesaggressively() {
        this.configuration.mergeInterfacesAggressively = true;
    }

    public Object getdontobfuscate() {
        this.dontobfuscate();
        return null;
    }

    public void dontobfuscate() {
        this.configuration.obfuscate = false;
    }

    public Object getprintmapping() {
        this.printmapping();
        return null;
    }

    public void printmapping() {
        this.configuration.printMapping = Configuration.STD_OUT;
    }

    public void printmapping(Object object) throws ParseException {
        this.configuration.printMapping = this.getProject().file(object);
    }

    public void applymapping(Object object) throws ParseException {
        this.configuration.applyMapping = this.getProject().file(object);
    }

    public void obfuscationdictionary(Object object) throws ParseException {
        this.configuration.obfuscationDictionary = this.getProject().file(object);
    }

    public void classobfuscationdictionary(Object object) throws ParseException {
        this.configuration.classObfuscationDictionary = this.getProject().file(object);
    }

    public void packageobfuscationdictionary(Object object) throws ParseException {
        this.configuration.packageObfuscationDictionary = this.getProject().file(object);
    }

    public Object getoverloadaggressively() {
        this.overloadaggressively();
        return null;
    }

    public void overloadaggressively() {
        this.configuration.overloadAggressively = true;
    }

    public Object getuseuniqueclassmembernames() {
        this.useuniqueclassmembernames();
        return null;
    }

    public void useuniqueclassmembernames() {
        this.configuration.useUniqueClassMemberNames = true;
    }

    public Object getdontusemixedcaseclassnames() {
        this.dontusemixedcaseclassnames();
        return null;
    }

    public void dontusemixedcaseclassnames() {
        this.configuration.useMixedCaseClassNames = false;
    }

    public Object getkeeppackagenames() {
        this.keeppackagenames();
        return null;
    }

    public void keeppackagenames() {
        this.keeppackagenames(null);
    }

    public void keeppackagenames(String string) {
        this.configuration.keepPackageNames = this.extendFilter(this.configuration.keepPackageNames, string, true);
    }

    public Object getflattenpackagehierarchy() {
        this.flattenpackagehierarchy();
        return null;
    }

    public void flattenpackagehierarchy() {
        this.flattenpackagehierarchy("");
    }

    public void flattenpackagehierarchy(String string) {
        this.configuration.flattenPackageHierarchy = ClassUtil.internalClassName(string);
    }

    public Object getrepackageclasses() {
        this.repackageclasses();
        return null;
    }

    public void repackageclasses() {
        this.repackageclasses("");
    }

    public void repackageclasses(String string) {
        this.configuration.repackageClasses = ClassUtil.internalClassName(string);
    }

    public Object getkeepattributes() {
        this.keepattributes();
        return null;
    }

    public void keepattributes() {
        this.keepattributes(null);
    }

    public void keepattributes(String string) {
        this.configuration.keepAttributes = this.extendFilter(this.configuration.keepAttributes, string);
    }

    public Object getkeepparameternames() {
        this.keepparameternames();
        return null;
    }

    public void keepparameternames() {
        this.configuration.keepParameterNames = true;
    }

    public Object getrenamesourcefileattribute() {
        this.renamesourcefileattribute();
        return null;
    }

    public void renamesourcefileattribute() {
        this.renamesourcefileattribute("");
    }

    public void renamesourcefileattribute(String string) {
        this.configuration.newSourceFileAttribute = string;
    }

    public Object getadaptclassstrings() {
        this.adaptclassstrings();
        return null;
    }

    public void adaptclassstrings() {
        this.adaptclassstrings(null);
    }

    public void adaptclassstrings(String string) {
        this.configuration.adaptClassStrings = this.extendFilter(this.configuration.adaptClassStrings, string, true);
    }

    public Object getadaptresourcefilenames() {
        this.adaptresourcefilenames();
        return null;
    }

    public void adaptresourcefilenames() {
        this.adaptresourcefilenames(null);
    }

    public void adaptresourcefilenames(String string) {
        this.configuration.adaptResourceFileNames = this.extendFilter(this.configuration.adaptResourceFileNames, string);
    }

    public Object getadaptresourcefilecontents() {
        this.adaptresourcefilecontents();
        return null;
    }

    public void adaptresourcefilecontents() {
        this.adaptresourcefilecontents(null);
    }

    public void adaptresourcefilecontents(String string) {
        this.configuration.adaptResourceFileContents = this.extendFilter(this.configuration.adaptResourceFileContents, string);
    }

    public Object getdontpreverify() {
        this.dontpreverify();
        return null;
    }

    public void dontpreverify() {
        this.configuration.preverify = false;
    }

    public Object getmicroedition() {
        this.microedition();
        return null;
    }

    public void microedition() {
        this.configuration.microEdition = true;
    }

    public Object getverbose() {
        this.verbose();
        return null;
    }

    public void verbose() {
        this.configuration.verbose = true;
    }

    public Object getdontnote() {
        this.dontnote();
        return null;
    }

    public void dontnote() {
        this.dontnote(null);
    }

    public void dontnote(String string) {
        this.configuration.note = this.extendFilter(this.configuration.note, string, true);
    }

    public Object getdontwarn() {
        this.dontwarn();
        return null;
    }

    public void dontwarn() {
        this.dontwarn(null);
    }

    public void dontwarn(String string) {
        this.configuration.warn = this.extendFilter(this.configuration.warn, string, true);
    }

    public Object getignorewarnings() {
        this.ignorewarnings();
        return null;
    }

    public void ignorewarnings() {
        this.configuration.ignoreWarnings = true;
    }

    public Object getprintconfiguration() {
        this.printconfiguration();
        return null;
    }

    public void printconfiguration() {
        this.configuration.printConfiguration = Configuration.STD_OUT;
    }

    public void printconfiguration(Object object) throws ParseException {
        this.configuration.printConfiguration = this.getProject().file(object);
    }

    public Object getdump() {
        this.dump();
        return null;
    }

    public void dump() {
        this.configuration.dump = Configuration.STD_OUT;
    }

    public void dump(Object object) throws ParseException {
        this.configuration.dump = this.getProject().file(object);
    }

    public void field(Map map) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'field' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addField(this.createMemberSpecification(false, false, map));
    }

    public void constructor(Map map) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'constructor' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addMethod(this.createMemberSpecification(true, true, map));
    }

    public void method(Map map) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'method' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addMethod(this.createMemberSpecification(true, false, map));
    }

    @TaskAction
    public void proguard() throws ParseException, IOException {
        LoggingManagerInternal loggingManagerInternal = this.getLogging();
        loggingManagerInternal.captureStandardOutput(LogLevel.INFO);
        loggingManagerInternal.captureStandardError(LogLevel.WARN);
        new ProGuard(this.getConfiguration()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration getConfiguration() throws IOException, ParseException {
        int n;
        this.configuration.programJars = new ClassPath();
        int n2 = 0;
        int n3 = this.inJarCounts.size() == 0 ? -1 : (Integer)this.inJarCounts.get(0);
        for (n = 0; n < this.inJarFiles.size(); ++n) {
            this.configuration.programJars = this.extendClassPath(this.configuration.programJars, this.inJarFiles.get(n), (Map)this.inJarFilters.get(n), false);
            while (n == n3 - 1) {
                this.configuration.programJars = this.extendClassPath(this.configuration.programJars, this.outJarFiles.get(n2), (Map)this.outJarFilters.get(n2), true);
                n3 = this.inJarCounts.size() == ++n2 ? -1 : (Integer)this.inJarCounts.get(n2);
            }
        }
        this.configuration.libraryJars = new ClassPath();
        for (n = 0; n < this.libraryJarFiles.size(); ++n) {
            this.configuration.libraryJars = this.extendClassPath(this.configuration.libraryJars, this.libraryJarFiles.get(n), (Map)this.libraryJarFilters.get(n), false);
        }
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[]{this.configurationFiles});
        Iterator iterator = configurableFileCollection.iterator();
        while (iterator.hasNext()) {
            ConfigurationParser configurationParser = new ConfigurationParser((File)iterator.next(), System.getProperties());
            try {
                configurationParser.parse(this.configuration);
            }
            finally {
                configurationParser.close();
            }
        }
        this.configuration.lastModified = Long.MAX_VALUE;
        return this.configuration;
    }

    private ClassPath extendClassPath(ClassPath classPath, Object object, Map map, boolean bl) {
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[]{object});
        if (classPath == null) {
            classPath = new ClassPath();
        }
        for (File file : configurableFileCollection) {
            if (!bl && !file.exists()) continue;
            ClassPathEntry classPathEntry = new ClassPathEntry(file, bl);
            if (map != null) {
                classPathEntry.setFilter(ListUtil.commaSeparatedList((String)map.get("filter")));
                classPathEntry.setApkFilter(ListUtil.commaSeparatedList((String)map.get("apkfilter")));
                classPathEntry.setJarFilter(ListUtil.commaSeparatedList((String)map.get("jarfilter")));
                classPathEntry.setAarFilter(ListUtil.commaSeparatedList((String)map.get("aarfilter")));
                classPathEntry.setWarFilter(ListUtil.commaSeparatedList((String)map.get("warfilter")));
                classPathEntry.setEarFilter(ListUtil.commaSeparatedList((String)map.get("earfilter")));
                classPathEntry.setZipFilter(ListUtil.commaSeparatedList((String)map.get("zipfilter")));
            }
            classPath.add(classPathEntry);
        }
        return classPath;
    }

    private KeepClassSpecification createKeepClassSpecification(boolean bl, boolean bl2, boolean bl3, Map map, String string) throws ParseException {
        ClassSpecification classSpecification = this.createClassSpecification(string);
        return this.createKeepClassSpecification(bl, bl2, bl3, map, classSpecification);
    }

    private KeepClassSpecification createKeepClassSpecification(boolean bl, boolean bl2, boolean bl3, Map map, Closure closure) throws ParseException {
        ClassSpecification classSpecification = this.createClassSpecification(map, closure);
        return this.createKeepClassSpecification(bl, bl2, bl3, map, classSpecification);
    }

    private KeepClassSpecification createKeepClassSpecification(boolean bl, boolean bl2, boolean bl3, Map map, ClassSpecification classSpecification) {
        return new KeepClassSpecification(bl2, bl3, this.retrieveBoolean(map, "includedescriptorclasses", false), this.retrieveBoolean(map, "allowshrinking", bl), this.retrieveBoolean(map, "allowoptimization", false), this.retrieveBoolean(map, "allowobfuscation", false), classSpecification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSpecification createClassSpecification(String string) throws ParseException {
        ClassSpecification classSpecification;
        ConfigurationParser configurationParser = new ConfigurationParser(new String[]{string}, null);
        try {
            classSpecification = configurationParser.parseClassSpecificationArguments();
        }
        catch (Throwable throwable) {
            try {
                configurationParser.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ParseException(iOException.getMessage());
            }
        }
        configurationParser.close();
        return classSpecification;
    }

    private ClassSpecification createClassSpecification(Map map, Closure closure) throws ParseException {
        String string = (String)map.get("access");
        String string2 = (String)map.get("annotation");
        String string3 = (String)map.get("type");
        String string4 = (String)map.get("name");
        String string5 = (String)map.get("extendsannotation");
        String string6 = (String)map.get("extends");
        if (string6 == null) {
            string6 = (String)map.get("implements");
        }
        ClassSpecification classSpecification = new ClassSpecification(null, this.requiredClassAccessFlags(true, string, string3), this.requiredClassAccessFlags(false, string, string3), string2 != null ? ClassUtil.internalType(string2) : null, string4 != null ? ClassUtil.internalClassName(string4) : null, string5 != null ? ClassUtil.internalType(string5) : null, string6 != null ? ClassUtil.internalClassName(string6) : null);
        if (closure != null) {
            this.classSpecification = classSpecification;
            closure.call((Object)classSpecification);
            this.classSpecification = null;
        }
        return classSpecification;
    }

    private int requiredClassAccessFlags(boolean bl, String string, String string2) throws ParseException {
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string3;
                String string4 = stringTokenizer.nextToken();
                if (!(string4.startsWith("!") ^ bl)) continue;
                String string5 = string3 = string4.startsWith("!") ? string4.substring(1) : string4;
                int n3 = string3.equals("public") ? 1 : (string3.equals("final") ? 16 : (string3.equals("abstract") ? 1024 : (string3.equals("synthetic") ? 4096 : (n2 = string3.equals("@") ? 8192 : 0))));
                if (n2 == 0) {
                    throw new ParseException("Incorrect class access modifier [" + string3 + "]");
                }
                n |= n2;
            }
        }
        if (string2 != null && string2.startsWith("!") ^ bl) {
            int n4;
            int n5 = string2.equals("class") ? 0 : (string2.equals("interface") || string2.equals("!interface") ? 512 : (n4 = string2.equals("enum") || string2.equals("!enum") ? 16384 : -1));
            if (n4 == -1) {
                throw new ParseException("Incorrect class type [" + string2 + "]");
            }
            n |= n4;
        }
        return n;
    }

    private MemberSpecification createMemberSpecification(boolean bl, boolean bl2, Map map) throws ParseException {
        String string = (String)map.get("access");
        String string2 = (String)map.get("type");
        String string3 = (String)map.get("annotation");
        String string4 = (String)map.get("name");
        String string5 = (String)map.get("parameters");
        if (string3 != null) {
            string3 = ClassUtil.internalType(string3);
        }
        if (bl) {
            if (bl2) {
                if (string2 != null) {
                    throw new ParseException("Type attribute not allowed in constructor specification [" + string2 + "]");
                }
                if (string5 != null) {
                    string2 = "void";
                }
                string4 = "<init>";
            } else if (string2 != null ^ string5 != null) {
                throw new ParseException("Type and parameters attributes must always be present in combination in method specification");
            }
        } else if (string5 != null) {
            throw new ParseException("Parameters attribute not allowed in field specification [" + string5 + "]");
        }
        List list = ListUtil.commaSeparatedList(string5);
        String string6 = string5 != null ? ClassUtil.internalMethodDescriptor(string2, list) : (string2 != null ? ClassUtil.internalType(string2) : null);
        return new MemberSpecification(this.requiredMemberAccessFlags(true, string), this.requiredMemberAccessFlags(false, string), string3, string4, string6);
    }

    private int requiredMemberAccessFlags(boolean bl, String string) throws ParseException {
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (!(string3.startsWith("!") ^ bl)) continue;
                String string4 = string2 = string3.startsWith("!") ? string3.substring(1) : string3;
                int n3 = string2.equals("public") ? 1 : (string2.equals("private") ? 2 : (string2.equals("protected") ? 4 : (string2.equals("static") ? 8 : (string2.equals("final") ? 16 : (string2.equals("synchronized") ? 32 : (string2.equals("volatile") ? 64 : (string2.equals("transient") ? 128 : (string2.equals("bridge") ? 64 : (string2.equals("varargs") ? 128 : (string2.equals("native") ? 256 : (string2.equals("abstract") ? 1024 : (string2.equals("strictfp") ? 2048 : (n2 = string2.equals("synthetic") ? 4096 : 0)))))))))))));
                if (n2 == 0) {
                    throw new ParseException("Incorrect class member access modifier [" + string2 + "]");
                }
                n |= n2;
            }
        }
        return n;
    }

    private boolean retrieveBoolean(Map map, String string, boolean bl) {
        if (map == null) {
            return bl;
        }
        Object v = map.get(string);
        return v == null ? bl : (Boolean)v;
    }

    private List extendClassSpecifications(List arrayList, ClassSpecification classSpecification) {
        if (arrayList == null) {
            arrayList = new ArrayList<ClassSpecification>();
        }
        arrayList.add(classSpecification);
        return arrayList;
    }

    private List extendClassSpecifications(List arrayList, List list) {
        if (list != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List extendFilter(List list, String string) {
        return this.extendFilter(list, string, false);
    }

    private List extendFilter(List arrayList, String string, boolean bl) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (string == null) {
            arrayList.clear();
        } else {
            if (bl) {
                string = ClassUtil.internalClassName(string);
            }
            arrayList.addAll(ListUtil.commaSeparatedList(string));
        }
        return arrayList;
    }
}

