/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ClassOptimizationInfo;

public class PackageVisibleMemberContainingClassMarker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    @Override
    public void visitAnyClass(Clazz clazz) {
        if ((clazz.getAccessFlags() & 1) == 0) {
            PackageVisibleMemberContainingClassMarker.setPackageVisibleMembers(clazz);
        } else {
            clazz.fieldsAccept(this);
            clazz.methodsAccept(this);
        }
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        if ((member.getAccessFlags() & 3) == 0) {
            PackageVisibleMemberContainingClassMarker.setPackageVisibleMembers(clazz);
        }
    }

    private static void setPackageVisibleMembers(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (classOptimizationInfo != null) {
            classOptimizationInfo.setContainsPackageVisibleMembers();
        }
    }

    public static boolean containsPackageVisibleMembers(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        return classOptimizationInfo == null || classOptimizationInfo.containsPackageVisibleMembers();
    }
}

