/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.PolygonHandle;
import CH.ifa.draw.contrib.PolygonScaleHandle;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class PolygonFigure
extends AttributeFigure {
    static final int TOO_CLOSE = 2;
    private static final long serialVersionUID = 6254089689239215026L;
    private int polygonFigureSerializedDataVersion = 1;
    private Polygon fPoly;

    public PolygonFigure() {
        this.setInternalPolygon(new Polygon());
    }

    public PolygonFigure(int x, int y) {
        this();
        this.getInternalPolygon().addPoint(x, y);
    }

    public PolygonFigure(Polygon p) {
        this.setInternalPolygon(new Polygon(p.xpoints, p.ypoints, p.npoints));
    }

    public Rectangle displayBox() {
        return PolygonFigure.bounds(this.getInternalPolygon());
    }

    public boolean isEmpty() {
        return this.pointCount() < 3 || this.size().width < 2 && this.size().height < 2;
    }

    public Vector handles() {
        Vector<AbstractHandle> handles = new Vector<AbstractHandle>(this.pointCount());
        for (int i = 0; i < this.pointCount(); ++i) {
            handles.addElement(new PolygonHandle(this, PolygonFigure.locator(i), i));
        }
        handles.addElement(new PolygonScaleHandle(this));
        return handles;
    }

    public void basicDisplayBox(Point origin, Point corner) {
        Rectangle r = this.displayBox();
        int dx = origin.x - r.x;
        int dy = origin.y - r.y;
        this.getInternalPolygon().translate(dx, dy);
        r = this.displayBox();
        Point oldCorner = new Point(r.x + r.width, r.y + r.height);
        this.scaleRotate(oldCorner, this.getInternalPolygon(), corner);
    }

    public Polygon getPolygon() {
        return new Polygon(this.fPoly.xpoints, this.fPoly.ypoints, this.fPoly.npoints);
    }

    protected void setInternalPolygon(Polygon newPolygon) {
        this.fPoly = newPolygon;
    }

    public Polygon getInternalPolygon() {
        return this.fPoly;
    }

    public Point center() {
        return PolygonFigure.center(this.getInternalPolygon());
    }

    public Enumeration points() {
        Vector<Point> pts = new Vector<Point>(this.pointCount());
        for (int i = 0; i < this.pointCount(); ++i) {
            pts.addElement(new Point(this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i]));
        }
        return pts.elements();
    }

    public int pointCount() {
        return this.getInternalPolygon().npoints;
    }

    public void basicMoveBy(int dx, int dy) {
        this.getInternalPolygon().translate(dx, dy);
    }

    public void drawBackground(Graphics g) {
        g.fillPolygon(this.getInternalPolygon());
    }

    public void drawFrame(Graphics g) {
        g.drawPolygon(this.getInternalPolygon());
    }

    public boolean containsPoint(int x, int y) {
        return this.getInternalPolygon().contains(x, y);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopPolygonConnector(this);
    }

    public void addPoint(int x, int y) {
        this.getInternalPolygon().addPoint(x, y);
        this.changed();
    }

    public void setPointAt(Point p, int i) {
        this.willChange();
        this.getInternalPolygon().xpoints[i] = p.x;
        this.getInternalPolygon().ypoints[i] = p.y;
        this.changed();
    }

    public void insertPointAt(Point p, int i) {
        int j;
        this.willChange();
        int n = this.pointCount() + 1;
        int[] xs = new int[n];
        int[] ys = new int[n];
        for (j = 0; j < i; ++j) {
            xs[j] = this.getInternalPolygon().xpoints[j];
            ys[j] = this.getInternalPolygon().ypoints[j];
        }
        xs[i] = p.x;
        ys[i] = p.y;
        for (j = i; j < this.pointCount(); ++j) {
            xs[j + 1] = this.getInternalPolygon().xpoints[j];
            ys[j + 1] = this.getInternalPolygon().ypoints[j];
        }
        this.setInternalPolygon(new Polygon(xs, ys, n));
        this.changed();
    }

    public void removePointAt(int i) {
        int j;
        this.willChange();
        int n = this.pointCount() - 1;
        int[] xs = new int[n];
        int[] ys = new int[n];
        for (j = 0; j < i; ++j) {
            xs[j] = this.getInternalPolygon().xpoints[j];
            ys[j] = this.getInternalPolygon().ypoints[j];
        }
        for (j = i; j < n; ++j) {
            xs[j] = this.getInternalPolygon().xpoints[j + 1];
            ys[j] = this.getInternalPolygon().ypoints[j + 1];
        }
        this.setInternalPolygon(new Polygon(xs, ys, n));
        this.changed();
    }

    public void scaleRotate(Point anchor, Polygon originalPolygon, Point p) {
        this.willChange();
        Point ctr = PolygonFigure.center(originalPolygon);
        double anchorLen = Geom.length(ctr.x, ctr.y, anchor.x, anchor.y);
        if (anchorLen > 0.0) {
            double newLen = Geom.length(ctr.x, ctr.y, p.x, p.y);
            double ratio = newLen / anchorLen;
            double anchorAngle = Math.atan2(anchor.y - ctr.y, anchor.x - ctr.x);
            double newAngle = Math.atan2(p.y - ctr.y, p.x - ctr.x);
            double rotation = newAngle - anchorAngle;
            int n = originalPolygon.npoints;
            int[] xs = new int[n];
            int[] ys = new int[n];
            for (int i = 0; i < n; ++i) {
                int x = originalPolygon.xpoints[i];
                int y = originalPolygon.ypoints[i];
                double l = (double)Geom.length(ctr.x, ctr.y, x, y) * ratio;
                double a = Math.atan2(y - ctr.y, x - ctr.x) + rotation;
                xs[i] = (int)((double)ctr.x + l * Math.cos(a) + 0.5);
                ys[i] = (int)((double)ctr.y + l * Math.sin(a) + 0.5);
            }
            this.setInternalPolygon(new Polygon(xs, ys, n));
        }
        this.changed();
    }

    public void smoothPoints() {
        this.willChange();
        boolean removed = false;
        int n = this.pointCount();
        do {
            removed = false;
            int i = 0;
            while (i < n && n >= 3) {
                int prv = (i - 1 + n) % n;
                int nxt = (i + 1) % n;
                if (Geom.distanceFromLine(this.getInternalPolygon().xpoints[prv], this.getInternalPolygon().ypoints[prv], this.getInternalPolygon().xpoints[nxt], this.getInternalPolygon().ypoints[nxt], this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i]) < 2.0) {
                    removed = true;
                    --n;
                    for (int j = i; j < n; ++j) {
                        this.getInternalPolygon().xpoints[j] = this.getInternalPolygon().xpoints[j + 1];
                        this.getInternalPolygon().ypoints[j] = this.getInternalPolygon().ypoints[j + 1];
                    }
                    continue;
                }
                ++i;
            }
        } while (removed);
        if (n != this.pointCount()) {
            this.setInternalPolygon(new Polygon(this.getInternalPolygon().xpoints, this.getInternalPolygon().ypoints, n));
        }
        this.changed();
    }

    public int splitSegment(int x, int y) {
        int i = this.findSegment(x, y);
        if (i != -1) {
            this.insertPointAt(new Point(x, y), i + 1);
            return i + 1;
        }
        return -1;
    }

    public Point pointAt(int i) {
        return new Point(this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i]);
    }

    public Point outermostPoint() {
        Point ctr = this.center();
        int outer = 0;
        long dist = 0L;
        for (int i = 0; i < this.pointCount(); ++i) {
            long d = Geom.length2(ctr.x, ctr.y, this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i]);
            if (d <= dist) continue;
            dist = d;
            outer = i;
        }
        return new Point(this.getInternalPolygon().xpoints[outer], this.getInternalPolygon().ypoints[outer]);
    }

    public int findSegment(int x, int y) {
        double dist = 2.0;
        int best = -1;
        for (int i = 0; i < this.pointCount(); ++i) {
            int n = (i + 1) % this.pointCount();
            double d = Geom.distanceFromLine(this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i], this.getInternalPolygon().xpoints[n], this.getInternalPolygon().ypoints[n], x, y);
            if (!(d < dist)) continue;
            dist = d;
            best = i;
        }
        return best;
    }

    public Point chop(Point p) {
        return PolygonFigure.chop(this.getInternalPolygon(), p);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.pointCount());
        for (int i = 0; i < this.pointCount(); ++i) {
            dw.writeInt(this.getInternalPolygon().xpoints[i]);
            dw.writeInt(this.getInternalPolygon().ypoints[i]);
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        int[] xs = new int[size];
        int[] ys = new int[size];
        for (int i = 0; i < size; ++i) {
            xs[i] = dr.readInt();
            ys[i] = dr.readInt();
        }
        this.setInternalPolygon(new Polygon(xs, ys, size));
    }

    public static Locator locator(final int pointIndex) {
        return new AbstractLocator(){

            public Point locate(Figure owner) {
                PolygonFigure plf = (PolygonFigure)owner;
                if (pointIndex < plf.pointCount()) {
                    return ((PolygonFigure)owner).pointAt(pointIndex);
                }
                return new Point(-1, -1);
            }
        };
    }

    public static Rectangle bounds(Polygon p) {
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int n = p.npoints;
        for (int i = 0; i < n; ++i) {
            int x = p.xpoints[i];
            int y = p.ypoints[i];
            if (x > maxx) {
                maxx = x;
            }
            if (x < minx) {
                minx = x;
            }
            if (y > maxy) {
                maxy = y;
            }
            if (y >= miny) continue;
            miny = y;
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public static Point center(Polygon p) {
        long sx = 0L;
        long sy = 0L;
        int n = p.npoints;
        for (int i = 0; i < n; ++i) {
            sx += (long)p.xpoints[i];
            sy += (long)p.ypoints[i];
        }
        return new Point((int)(sx / (long)n), (int)(sy / (long)n));
    }

    public static Point chop(Polygon poly, Point p) {
        int i;
        Point ctr = PolygonFigure.center(poly);
        int cx = -1;
        int cy = -1;
        long len = Long.MAX_VALUE;
        for (i = 0; i < poly.npoints; ++i) {
            long cl;
            int nxt = (i + 1) % poly.npoints;
            Point chop = Geom.intersect(poly.xpoints[i], poly.ypoints[i], poly.xpoints[nxt], poly.ypoints[nxt], p.x, p.y, ctr.x, ctr.y);
            if (chop == null || (cl = Geom.length2(chop.x, chop.y, p.x, p.y)) >= len) continue;
            len = cl;
            cx = chop.x;
            cy = chop.y;
        }
        for (i = 0; i < poly.npoints; ++i) {
            long l = Geom.length2(poly.xpoints[i], poly.ypoints[i], p.x, p.y);
            if (l >= len) continue;
            len = l;
            cx = poly.xpoints[i];
            cy = poly.ypoints[i];
        }
        return new Point(cx, cy);
    }
}

