/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class ExtensionParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(ExtensionParam.class);
    private static final String EXTENSION_BASE_KEY = "extensions";
    private static final String ALL_EXTENSIONS_KEY = "extensions.extension";
    private static final String EXTENSION_NAME_KEY = "name";
    private static final String EXTENSION_ENABLED_KEY = "enabled";
    private List<ExtensionState> extensions = Collections.emptyList();

    @Override
    protected void parse() {
        try {
            List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_EXTENSIONS_KEY);
            this.extensions = new ArrayList<ExtensionState>(list.size());
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string = hierarchicalConfiguration.getString(EXTENSION_NAME_KEY, "");
                boolean bl = hierarchicalConfiguration.getBoolean(EXTENSION_ENABLED_KEY, true);
                this.extensions.add(new ExtensionState(string, bl));
            }
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)("Error while loading extensions' state: " + conversionException.getMessage()), (Throwable)conversionException);
            this.extensions = Collections.emptyList();
        }
    }

    List<ExtensionState> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    void setExtensions(List<ExtensionState> list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter extensionsState must not be null.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_EXTENSIONS_KEY);
        for (int i = 0; i < list.size(); ++i) {
            ExtensionState extensionState = list.get(i);
            if (extensionState.isEnabled()) continue;
            String string = "extensions.extension(" + i + ").";
            this.getConfig().setProperty(string + EXTENSION_NAME_KEY, (Object)extensionState.getName());
            this.getConfig().setProperty(string + EXTENSION_ENABLED_KEY, (Object)extensionState.isEnabled());
        }
        this.extensions = list;
    }

    static class ExtensionState {
        private final String name;
        private final boolean enabled;

        public ExtensionState(String string, boolean bl) {
            this.name = string;
            this.enabled = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

