/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputText
extends RowOutputBase {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    protected TextFileSettings textFileSettings;

    public RowOutputText(TextFileSettings textFileSettings) {
        this.initTextDatabaseRowOutput(textFileSettings);
    }

    private void initTextDatabaseRowOutput(TextFileSettings textFileSettings) {
        this.textFileSettings = textFileSettings;
        this.fieldSep = textFileSettings.fs;
        this.varSep = textFileSettings.vs;
        this.longvarSep = textFileSettings.lvs;
        if (this.fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            this.fieldSep = this.fieldSep.substring(0, this.fieldSep.length() - 1);
        }
        if (this.varSep.endsWith("\n")) {
            this.varSepEnd = true;
            this.varSep = this.varSep.substring(0, this.varSep.length() - 1);
        }
        if (this.longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            this.longvarSep = this.longvarSep.substring(0, this.longvarSep.length() - 1);
        }
    }

    @Override
    public void setStorageSize(int n) {
    }

    @Override
    public void writeEnd() {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.writeBytes(TextFileSettings.NL);
    }

    @Override
    public void writeSize(int n) {
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    @Override
    public void writeType(int n) {
    }

    @Override
    public void writeString(String string) {
        if ((string = this.checkConvertString(string, this.fieldSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String string) {
        if ((string = this.checkConvertString(string, this.varSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String string) {
        if ((string = this.checkConvertString(string, this.longvarSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected String checkConvertString(String string, String string2) {
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1) {
            throw new IllegalArgumentException(Error.getMessage(485));
        }
        if (string.indexOf(string2) != -1) {
            return null;
        }
        return string;
    }

    private byte[] getBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.textFileSettings.charEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.error(484, unsupportedEncodingException);
        }
        return byArray;
    }

    protected void writeByteArray(byte[] byArray) {
        if (this.textFileSettings.isUTF16) {
            byte[] byArray2 = new byte[byArray.length * 2];
            StringConverter.writeHexBytes(byArray2, 0, byArray);
            String string = new String(byArray2);
            this.writeBytes(string);
        } else {
            this.ensureRoom(byArray.length * 2);
            StringConverter.writeHexBytes(this.getBuffer(), this.count, byArray);
            this.count += byArray.length * 2;
        }
    }

    @Override
    public void writeShort(int n) {
        this.writeInt(n);
    }

    @Override
    public void writeInt(int n) {
        this.writeBytes(Integer.toString(n));
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    @Override
    public void writeLong(long l) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeBytes(String string) {
        if (this.textFileSettings.isUTF16) {
            try {
                if (string.length() <= 0) return;
                byte[] byArray = string.getBytes(this.textFileSettings.charEncoding);
                super.write(byArray);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw Error.error(484, unsupportedEncodingException);
            }
        } else {
            super.writeBytes(string);
        }
    }

    @Override
    protected void writeFieldType(Type type) {
        this.writeBytes(this.nextSep);
        switch (type.typeCode) {
            case 12: {
                this.nextSep = this.varSep;
                this.nextSepEnd = this.varSepEnd;
                break;
            }
            default: {
                this.nextSep = this.fieldSep;
                this.nextSepEnd = this.fieldSepEnd;
            }
        }
    }

    @Override
    protected void writeNull(Type type) {
        this.writeFieldType(type);
    }

    @Override
    protected void writeChar(String string, Type type) {
        switch (type.typeCode) {
            case 1: {
                this.writeString(string);
                return;
            }
            case 12: {
                this.writeVarString(string);
                return;
            }
        }
        this.writeLongVarString(string);
    }

    @Override
    protected void writeSmallint(Number number) {
        this.writeString(number.toString());
    }

    @Override
    protected void writeInteger(Number number) {
        this.writeString(number.toString());
    }

    @Override
    protected void writeBigint(Number number) {
        this.writeString(number.toString());
    }

    @Override
    protected void writeReal(Double d) {
        this.writeString(d.toString());
    }

    @Override
    protected void writeDecimal(BigDecimal bigDecimal, Type type) {
        this.writeString(type.convertToString(bigDecimal));
    }

    @Override
    protected void writeBoolean(Boolean bl) {
        this.writeString(bl.toString());
    }

    @Override
    protected void writeDate(TimestampData timestampData, Type type) {
        this.writeString(type.convertToString(timestampData));
    }

    @Override
    protected void writeTime(TimeData timeData, Type type) {
        this.writeString(type.convertToString(timeData));
    }

    @Override
    protected void writeTimestamp(TimestampData timestampData, Type type) {
        this.writeString(type.convertToString(timestampData));
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData intervalMonthData, Type type) {
        this.writeBytes(type.convertToString(intervalMonthData));
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData intervalSecondData, Type type) {
        this.writeBytes(type.convertToString(intervalSecondData));
    }

    @Override
    protected void writeOther(JavaObjectData javaObjectData) {
        byte[] byArray = javaObjectData.getBytes();
        this.writeByteArray(byArray);
    }

    @Override
    protected void writeBit(BinaryData binaryData) {
        String string = StringConverter.byteArrayToBitString(binaryData.getBytes(), (int)binaryData.bitLength(null));
        this.writeString(string);
    }

    @Override
    protected void writeBinary(BinaryData binaryData) {
        this.writeByteArray(binaryData.getBytes());
    }

    @Override
    protected void writeClob(ClobData clobData, Type type) {
        this.writeString(Long.toString(clobData.getId()));
    }

    @Override
    protected void writeBlob(BlobData blobData, Type type) {
        this.writeString(Long.toString(blobData.getId()));
    }

    @Override
    protected void writeArray(Object[] objectArray, Type type) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    @Override
    public int getSize(Row row) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(row, row.getTable().getColumnTypes());
            this.writeEnd();
        }
        catch (Exception exception) {
            this.reset();
        }
        int n = this.size();
        this.reset();
        return n;
    }

    @Override
    public int getStorageSize(int n) {
        return n;
    }

    @Override
    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }
}

