/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayToObjectArrayNode;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ArrayToObjectArrayNode.class)
public final class ArrayToObjectArrayNodeGen
extends ArrayToObjectArrayNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayToObjectArrayNodeGen(RubyNode array) {
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object[] executeToObjectArray(DynamicObject arrayValue) {
        return this.specialization_.executeObjectArray1(arrayValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayToObjectArrayNode create(RubyNode array) {
        return new ArrayToObjectArrayNodeGen(array);
    }

    @GeneratedBy(methodName="toObjectArrayOther(DynamicObject, ArrayStrategy)", value=ArrayToObjectArrayNode.class)
    private static final class ToObjectArrayOtherNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;

        ToObjectArrayOtherNode_(ArrayToObjectArrayNodeGen root, ArrayStrategy strategy) {
            super(root, 2);
            this.strategy = strategy;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue);
        }

        @Override
        public Object[] executeObjectArray1(DynamicObject arrayValue) {
            if (this.strategy.matches(arrayValue)) {
                return this.root.toObjectArrayOther(arrayValue, this.strategy);
            }
            return this.getNext().executeObjectArray1(arrayValue);
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.toObjectArrayOther(arrayValue_, this.strategy);
            }
            return this.getNext().executeObjectArray_(arrayValue);
        }

        static BaseNode_ create(ArrayToObjectArrayNodeGen root, ArrayStrategy strategy) {
            return new ToObjectArrayOtherNode_(root, strategy);
        }
    }

    @GeneratedBy(methodName="toObjectArrayNull(DynamicObject)", value=ArrayToObjectArrayNode.class)
    private static final class ToObjectArrayNullNode_
    extends BaseNode_ {
        ToObjectArrayNullNode_(ArrayToObjectArrayNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object[] executeObjectArray1(DynamicObject arrayValue) {
            if (ArrayGuards.isNullArray(arrayValue)) {
                return this.root.toObjectArrayNull(arrayValue);
            }
            return this.getNext().executeObjectArray1(arrayValue);
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && ArrayGuards.isNullArray(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.toObjectArrayNull(arrayValue_);
            }
            return this.getNext().executeObjectArray_(arrayValue);
        }

        static BaseNode_ create(ArrayToObjectArrayNodeGen root) {
            return new ToObjectArrayNullNode_(root);
        }
    }

    @GeneratedBy(value=ArrayToObjectArrayNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayToObjectArrayNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue) {
            return this.getNext().executeObjectArray_(arrayValue);
        }

        static BaseNode_ create(ArrayToObjectArrayNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayToObjectArrayNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayToObjectArrayNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue) {
            return (Object[])this.uninitialized((Frame)null, arrayValue);
        }

        static BaseNode_ create(ArrayToObjectArrayNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayToObjectArrayNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayToObjectArrayNodeGen root;

        BaseNode_(ArrayToObjectArrayNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayToObjectArrayNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.executeObjectArray_(arrayValue);
        }

        public abstract Object[] executeObjectArray_(Object var1);

        public Object[] executeObjectArray1(DynamicObject arrayValue) {
            return this.executeObjectArray_(arrayValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.executeObjectArray_(arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                BaseNode_ s;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return ToObjectArrayNullNode_.create(this.root);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                if (strategy2.matches(arrayValue_) && this.countSame(s = ToObjectArrayOtherNode_.create(this.root, strategy2)) < 25) {
                    return s;
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

