/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionarySerializer;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.postag.MutableTagDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;

public class POSDictionary
implements Iterable<String>,
MutableTagDictionary {
    private Map<String, String[]> dictionary = new HashMap<String, String[]>();
    private boolean caseSensitive = true;

    public POSDictionary() {
        this(true);
    }

    public POSDictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Deprecated
    public POSDictionary(String file) throws IOException {
        this(file, null, true);
    }

    @Deprecated
    public POSDictionary(String file, boolean caseSensitive) throws IOException {
        this(file, null, caseSensitive);
    }

    @Deprecated
    public POSDictionary(String file, String encoding, boolean caseSensitive) throws IOException {
        this(new BufferedReader(encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), encoding)), caseSensitive);
    }

    @Deprecated
    public POSDictionary(BufferedReader reader, boolean caseSensitive) throws IOException {
        this.caseSensitive = caseSensitive;
        String line = reader.readLine();
        while (line != null) {
            String[] parts = line.split(" ");
            String[] tags = new String[parts.length - 1];
            int tl = parts.length - 1;
            for (int ti = 0; ti < tl; ++ti) {
                tags[ti] = parts[ti + 1];
            }
            if (caseSensitive) {
                this.dictionary.put(parts[0], tags);
            } else {
                this.dictionary.put(StringUtil.toLowerCase(parts[0]), tags);
            }
            line = reader.readLine();
        }
    }

    @Override
    public String[] getTags(String word) {
        if (this.caseSensitive) {
            return this.dictionary.get(word);
        }
        return this.dictionary.get(StringUtil.toLowerCase(word));
    }

    void addTags(String word, String ... tags) {
        this.put(word, tags);
    }

    @Override
    public Iterator<String> iterator() {
        return this.dictionary.keySet().iterator();
    }

    private static String tagsToString(String[] tags) {
        StringBuilder tagString = new StringBuilder();
        for (String tag : tags) {
            tagString.append(tag);
            tagString.append(' ');
        }
        if (tagString.length() > 0) {
            tagString.setLength(tagString.length() - 1);
        }
        return tagString.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entries = new Iterator<Entry>(){
            Iterator<String> iterator;
            {
                this.iterator = POSDictionary.this.dictionary.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Entry next() {
                String word = this.iterator.next();
                Attributes tagAttribute = new Attributes();
                tagAttribute.setValue("tags", POSDictionary.tagsToString(POSDictionary.this.getTags(word)));
                return new Entry(new StringList(word), tagAttribute);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(out, entries, this.caseSensitive);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof POSDictionary) {
            POSDictionary dictionary = (POSDictionary)o;
            if (this.dictionary.size() == dictionary.dictionary.size()) {
                for (String word : this) {
                    Object[] bTags;
                    Object[] aTags = this.getTags(word);
                    if (Arrays.equals(aTags, bTags = dictionary.getTags(word))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "POSDictionary{size=" + this.dictionary.size() + ", caseSensitive=" + this.caseSensitive + "}";
    }

    public static POSDictionary create(InputStream in) throws IOException, InvalidFormatException {
        boolean isCaseSensitive;
        final POSDictionary newPosDict = new POSDictionary();
        newPosDict.caseSensitive = isCaseSensitive = DictionarySerializer.create(in, new EntryInserter(){

            @Override
            public void insert(Entry entry) throws InvalidFormatException {
                String tagString = entry.getAttributes().getValue("tags");
                String[] tags = tagString.split(" ");
                StringList word = entry.getTokens();
                if (word.size() != 1) {
                    throw new InvalidFormatException("Each entry must have exactly one token! " + word);
                }
                newPosDict.dictionary.put(word.getToken(0), tags);
            }
        });
        if (!isCaseSensitive) {
            HashMap<String, String[]> lowerCasedDictionary = new HashMap<String, String[]>();
            for (Map.Entry<String, String[]> entry : newPosDict.dictionary.entrySet()) {
                lowerCasedDictionary.put(StringUtil.toLowerCase(entry.getKey()), entry.getValue());
            }
            newPosDict.dictionary = lowerCasedDictionary;
        }
        return newPosDict;
    }

    @Override
    public String[] put(String word, String ... tags) {
        if (this.caseSensitive) {
            return this.dictionary.put(word, tags);
        }
        return this.dictionary.put(StringUtil.toLowerCase(word), tags);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

