/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchResult;
import org.zaproxy.zap.view.table.AbstractCustomColumnHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public class SearchResultsTableModel
extends AbstractCustomColumnHistoryReferencesTableModel<SearchResultTableEntry> {
    private static final long serialVersionUID = 5732679524771190690L;
    private static final String MATCH_COLUMN_NAME = Constant.messages.getString("search.results.table.header.match");
    private List<SearchResultTableEntry> results = new ArrayList<SearchResultTableEntry>();

    public SearchResultsTableModel() {
        super(new HistoryReferencesTableModel.Column[]{HistoryReferencesTableModel.Column.HREF_ID, HistoryReferencesTableModel.Column.METHOD, HistoryReferencesTableModel.Column.URL, HistoryReferencesTableModel.Column.CUSTOM});
    }

    public void addSearchResult(SearchResult searchResult) {
        SearchResultTableEntry searchResultTableEntry = null;
        if (this.results.size() > 1) {
            searchResultTableEntry = this.results.get(this.results.size() - 1);
        }
        this.results.add(SearchResultsTableModel.createSearchResultTableEntry(searchResult, searchResultTableEntry));
        this.fireTableRowsInserted(this.results.size() - 1, this.results.size() - 1);
    }

    private static SearchResultTableEntry createSearchResultTableEntry(SearchResult searchResult, SearchResultTableEntry searchResultTableEntry) {
        HistoryReference historyReference = searchResult.getMessage().getHistoryRef();
        Integer n = null;
        String string = null;
        String string2 = null;
        if (searchResultTableEntry != null) {
            Integer n2 = searchResultTableEntry.getHistoryId();
            if (n2.intValue() == historyReference.getHistoryId()) {
                n = n2;
            }
            if (searchResultTableEntry.getStringFound().equals(searchResult.getStringFound())) {
                string2 = searchResultTableEntry.getStringFound();
            }
            string = searchResult.getMessage().getRequestHeader().getURI().toString();
            if (searchResultTableEntry.getUri().equals(string)) {
                string = searchResultTableEntry.getUri();
            }
        }
        if (n == null) {
            n = historyReference.getHistoryId();
        }
        if (string2 == null) {
            string2 = searchResult.getStringFound();
        }
        if (string == null) {
            string = searchResult.getMessage().getRequestHeader().getURI().toString();
        }
        return new SearchResultTableEntry(historyReference, n, historyReference.getMethod(), string, string2, searchResult);
    }

    @Override
    public void addEntry(SearchResultTableEntry searchResultTableEntry) {
    }

    @Override
    public void refreshEntryRow(int n) {
    }

    @Override
    public void removeEntry(int n) {
    }

    @Override
    public SearchResultTableEntry getEntry(int n) {
        return this.results.get(n);
    }

    @Override
    public SearchResultTableEntry getEntryWithHistoryId(int n) {
        return null;
    }

    @Override
    public int getEntryRowIndex(int n) {
        return -1;
    }

    @Override
    public void clear() {
        this.results = new ArrayList<SearchResultTableEntry>();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    protected Class<?> getColumnClass(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getColumnClass(column);
    }

    @Override
    protected Object getPrototypeValue(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getPrototypeValue(column);
    }

    @Override
    protected Object getCustomValueAt(SearchResultTableEntry searchResultTableEntry, int n) {
        return searchResultTableEntry.getStringFound();
    }

    @Override
    protected String getCustomColumnName(int n) {
        return MATCH_COLUMN_NAME;
    }

    @Override
    protected Class<String> getCustomColumnClass(int n) {
        return String.class;
    }

    @Override
    protected Object getCustomPrototypeValue(int n) {
        return "A match with some long text";
    }

    public static class SearchResultTableEntry
    extends AbstractHistoryReferencesTableEntry {
        private static final int MAX_CHARS_FOUND_STRING = 150;
        private final Integer historyId;
        private final String method;
        private final String uri;
        private final String stringFound;
        private final SearchResult sr;

        public SearchResultTableEntry(HistoryReference historyReference, Integer n, String string, String string2, String string3, SearchResult searchResult) {
            super(historyReference);
            this.historyId = n;
            this.method = string;
            this.uri = string2;
            this.stringFound = string3.length() > 150 ? string3.substring(0, 150) + "..." : string3;
            this.sr = new HistoryReferenceSearchResult(searchResult, string3);
        }

        @Override
        public Integer getHistoryId() {
            return this.historyId;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        public String getStringFound() {
            return this.stringFound;
        }

        public SearchResult getSearchResult() {
            return this.sr;
        }

        private class CachedSearchMatch
        extends SearchMatch {
            public CachedSearchMatch(SearchMatch searchMatch) {
                super(null, searchMatch.getLocation(), searchMatch.getStart(), searchMatch.getEnd());
            }

            @Override
            public HttpMessage getMessage() {
                try {
                    return SearchResultTableEntry.this.getHistoryReference().getHttpMessage();
                }
                catch (DatabaseException | HttpMalformedHeaderException exception) {
                    return null;
                }
            }
        }

        private class HistoryReferenceSearchResult
        extends SearchResult {
            private List<CachedSearchMatch> matches;
            private CachedSearchMatch lastMatch;

            public HistoryReferenceSearchResult(SearchResult searchResult, String string) {
                super(null, searchResult.getType(), searchResult.getRegEx(), string);
                this.lastMatch = null;
                this.matches = new ArrayList<CachedSearchMatch>(1);
                this.matches.add(new CachedSearchMatch(searchResult.getFirstMatch(null, null)));
            }

            @Override
            public HttpMessage getMessage() {
                try {
                    return SearchResultTableEntry.this.getHistoryReference().getHttpMessage();
                }
                catch (DatabaseException | HttpMalformedHeaderException exception) {
                    return null;
                }
            }

            @Override
            public SearchMatch getFirstMatch(HttpPanel httpPanel, HttpPanel httpPanel2) {
                if (this.matches.size() > 0) {
                    this.lastMatch = this.matches.get(0);
                    return this.lastMatch;
                }
                return null;
            }

            @Override
            public SearchMatch getLastMatch(HttpPanel httpPanel, HttpPanel httpPanel2) {
                if (this.matches.size() > 0) {
                    this.lastMatch = this.matches.get(this.matches.size() - 1);
                    return this.lastMatch;
                }
                return null;
            }

            @Override
            public SearchMatch getNextMatch() {
                int n;
                if (this.lastMatch != null && (n = this.matches.indexOf(this.lastMatch)) >= 0 && n < this.matches.size() - 1) {
                    this.lastMatch = this.matches.get(n + 1);
                    return this.lastMatch;
                }
                return null;
            }

            @Override
            public SearchMatch getPrevMatch() {
                int n;
                if (this.lastMatch != null && (n = this.matches.indexOf(this.lastMatch)) >= 1) {
                    this.lastMatch = this.matches.get(n - 1);
                    return this.lastMatch;
                }
                return null;
            }
        }
    }
}

