/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.core.Prototype;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.util.JBroFuzzFileFilter;

public final class Verifier {
    private static final int MAX_CHARS = 65535;
    private static final int MAX_LINES = 4096;
    private static final int MAX_LINE_LENGTH = 2048;
    private static final int MAX_PROTO_NAME_LENGTH = 127;
    private static final int MAX_NO_OF_PAYLOADS = 1024;
    private static final int MAX_NO_OF_CATEGORIES = 127;
    private static final String ERROR_MSG = "\n\n\tBroken JBroFuzz Installation:\n\n\t";
    private static Map<String, Prototype> prototypes;
    private static Map<String, Prototype> headers;

    static {
        headers = null;
    }

    private Verifier() {
    }

    public static Map<String, Prototype> loadFile(String fileName) {
        if ("fuzzers.jbrf".equalsIgnoreCase(fileName)) {
            String inputContents;
            boolean extFilePresent = Verifier.checkExternalFile(fileName);
            if (extFilePresent) {
                Logger.log("Loading from the external file fuzzers.jbrf found in the current directory", 0);
                inputContents = Verifier.parseExtFile(fileName);
            } else {
                Logger.log("Loading from the internal file fuzzers.jbrf found in the current directory", 0);
                inputContents = Verifier.parseFile(fileName);
            }
            prototypes = new HashMap<String, Prototype>();
            Verifier.parsePrototypes(prototypes, inputContents);
            Logger.log("fuzzers.jbrf file loaded with " + prototypes.size() + " fuzzers", 0);
            return prototypes;
        }
        if ("headers.jbrf".equalsIgnoreCase(fileName)) {
            String headerContents = Verifier.parseFile(fileName);
            headers = new HashMap<String, Prototype>();
            Verifier.parsePrototypes(headers, headerContents);
            return headers;
        }
        throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tis not a valid name to load " + fileName);
    }

    public static Map<String, Prototype> loadAnyFile(String fuzzersFilePath) {
        if (fuzzersFilePath.length() > 512) {
            Logger.log("Cannot open a .jbrf file that has an absolute path greater than 512 characters", 4);
            return Verifier.loadFile("fuzzers.jbrf");
        }
        if (!fuzzersFilePath.endsWith(".jbrf")) {
            Logger.log("Cannot open file, does not have a .jbrf extension", 4);
            return Verifier.loadFile("fuzzers.jbrf");
        }
        boolean extFilePresent = Verifier.checkExternalFilePath(fuzzersFilePath);
        String inputContents = extFilePresent ? Verifier.parseExtFilePath(fuzzersFilePath) : Verifier.parseFile("fuzzers.jbrf");
        prototypes = new HashMap<String, Prototype>();
        Verifier.parsePrototypes(prototypes, inputContents);
        Logger.log("External file loaded with " + prototypes.size() + " fuzzers", 0);
        return prototypes;
    }

    private static boolean checkExternalFile(String fileName) {
        String dirString;
        try {
            dirString = System.getProperty("user.dir");
        }
        catch (SecurityException e) {
            return false;
        }
        File inputFile = new File(String.valueOf(dirString) + File.separator + fileName);
        JBroFuzzFileFilter jbfff = new JBroFuzzFileFilter();
        if (!jbfff.accept(inputFile)) {
            return false;
        }
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return false;
            }
            return inputFile.canRead();
        }
        return false;
    }

    private static boolean checkExternalFilePath(String fileNamePath) {
        File inputFile = new File(fileNamePath);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return false;
            }
            return inputFile.canRead();
        }
        return false;
    }

    private static String parseExtFile(String fileName) {
        JBroFuzzFileFilter jbfff = new JBroFuzzFileFilter();
        File inputFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + fileName);
        if (!jbfff.accept(inputFile)) {
            return "This file is not accepted";
        }
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return "File is a directory:\n\n" + fileName;
            }
            if (!inputFile.canRead()) {
                return "File cannot be read:\n\n" + fileName;
            }
        } else {
            return "File does not exist:\n\n" + fileName;
        }
        int counter = 0;
        BufferedInputStream in = null;
        FileInputStream fis = null;
        StringBuffer fileContents = new StringBuffer();
        try {
            try {
                int c;
                fis = new FileInputStream(inputFile);
                in = new BufferedInputStream(fis);
                while ((c = ((InputStream)in).read()) > 0 && counter <= 65535) {
                    if (CharUtils.isAsciiPrintable((char)c) || (char)c == '\n') {
                        fileContents.append((char)c);
                    }
                    ++counter;
                }
                ((InputStream)in).close();
                fis.close();
            }
            catch (IOException e) {
                String string = "Attempting to open the file caused an I/O Error:\n\n" + fileName;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(fis);
                return string;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(fis);
        if (counter == 65535) {
            String maxMessage = "\n... stopped reading file after 65535 characters.\n";
            fileContents.append("\n... stopped reading file after 65535 characters.\n");
            Logger.log("\n... stopped reading file after 65535 characters.\n", 3);
        }
        return fileContents.toString();
    }

    private static String parseExtFilePath(String fuzzersFilePath) {
        File inputFile = new File(fuzzersFilePath);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return "File is a directory:\n\n" + fuzzersFilePath;
            }
            if (!inputFile.canRead()) {
                return "File cannot be read:\n\n" + fuzzersFilePath;
            }
        } else {
            return "File does not exist:\n\n" + fuzzersFilePath;
        }
        int counter = 0;
        BufferedInputStream in = null;
        FileInputStream fis = null;
        StringBuffer fileContents = new StringBuffer();
        try {
            try {
                int c;
                fis = new FileInputStream(inputFile);
                in = new BufferedInputStream(fis);
                while ((c = ((InputStream)in).read()) > 0 && counter <= 65535) {
                    if (CharUtils.isAsciiPrintable((char)c) || (char)c == '\n') {
                        fileContents.append((char)c);
                    }
                    ++counter;
                }
                ((InputStream)in).close();
                fis.close();
            }
            catch (IOException e) {
                String string = "Attempting to open the file caused an I/O Error:\n\n" + fuzzersFilePath;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(fis);
                return string;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(fis);
        if (counter == 65535) {
            String maxMessage = "\n... stopped reading file after 65535 characters.\n";
            fileContents.append("\n... stopped reading file after 65535 characters.\n");
            Logger.log("\n... stopped reading file after 65535 characters.\n", 3);
        }
        return fileContents.toString();
    }

    private static String parseFile(String fileName) {
        StringBuffer fileContents = new StringBuffer();
        URL fileURL = ClassLoader.getSystemClassLoader().getResource(fileName);
        if (fileURL == null) {
            throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tcould not find " + fileName);
        }
        BufferedReader in = null;
        try {
            try {
                int c;
                URLConnection connection = fileURL.openConnection();
                connection.connect();
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                int counter = 0;
                while ((c = in.read()) > 0 && counter < 65535) {
                    if (CharUtils.isAsciiPrintable((char)c) || (char)c == '\n') {
                        fileContents.append((char)c);
                    }
                    ++counter;
                }
                in.close();
                if (counter == 65535) {
                    throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\t\n... stopped reading file :" + fileName + "\nafter " + 65535 + " characters.\n\n");
                }
            }
            catch (IOException e1) {
                throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tcould not read " + fileName);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return fileContents.toString();
    }

    private static void parsePrototypes(Map<String, Prototype> map, String input) {
        String[] fileInput = input.split("\n");
        if (fileInput.length > 4096) {
            throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tfuzzers.jbrf has more than 4096 lines.");
        }
        if (fileInput.length < 3) {
            throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tfuzzers.jbrf does not have enough lines.");
        }
        int i = 0;
        while (i < fileInput.length) {
            block26: {
                if (!fileInput[i].startsWith("#") && fileInput[i].length() <= 2048) {
                    char inputTypeChar;
                    try {
                        if (fileInput[i].charAt(1) != ':') break block26;
                        if (fileInput[i].charAt(13) != ':') {
                        }
                    }
                    catch (IndexOutOfBoundsException e1) {}
                    break block26;
                    String[] _fla = fileInput[i].split(":");
                    if (_fla.length == 4 && Prototype.isValidFuzzerType(inputTypeChar = _fla[0].charAt(0)) && !_fla[1].isEmpty() && !_fla[2].isEmpty() && _fla[2].length() <= 127) {
                        int noPayloads = 0;
                        try {
                            noPayloads = Integer.parseInt(_fla[3]);
                        }
                        catch (NumberFormatException e) {
                            break block26;
                        }
                        if (noPayloads <= 1024 && noPayloads != 0 && i + noPayloads <= fileInput.length) {
                            try {
                                if (!fileInput[i + 1].startsWith(">")) break block26;
                                if (!fileInput[i + 2].startsWith(">>")) {
                                }
                            }
                            catch (IndexOutOfBoundsException e) {}
                            break block26;
                            String line2 = "";
                            try {
                                line2 = fileInput[i + 1].substring(1);
                            }
                            catch (IndexOutOfBoundsException e) {
                                break block26;
                            }
                            String comment = "";
                            try {
                                comment = fileInput[i + 2].substring(2);
                            }
                            catch (IndexOutOfBoundsException e) {
                                break block26;
                            }
                            String[] _sla = line2.split("\\|");
                            if (_sla.length <= 127) {
                                Prototype proto = new Prototype(inputTypeChar, _fla[1], _fla[2]);
                                if (_sla.length > 0) {
                                    String[] stringArray = _sla;
                                    int n = _sla.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String categ_ry = stringArray[n2];
                                        categ_ry = StringUtils.stripEnd(categ_ry, " ");
                                        if (!(categ_ry = StringUtils.stripStart(categ_ry, " ")).isEmpty()) {
                                            proto.addCategory(categ_ry);
                                        }
                                        ++n2;
                                    }
                                } else {
                                    proto.addCategory("JBroFuzz");
                                }
                                proto.addComment(comment);
                                int j = 1;
                                while (j <= noPayloads) {
                                    try {
                                        proto.addPayload(fileInput[i + 2 + j]);
                                    }
                                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    ++j;
                                }
                                map.put(_fla[1], proto);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }
}

