/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.IncludedBuildFactory;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.composite.CompositeContextBuilder;
import org.gradle.internal.service.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBuildSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final ServiceRegistry buildServices;

    public CompositeBuildSettingsLoader(SettingsLoader delegate, ServiceRegistry buildServices) {
        this.delegate = delegate;
        this.buildServices = buildServices;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.delegate.findAndLoadSettings(gradle);
        Collection<IncludedBuild> includedBuilds = this.getIncludedBuilds(gradle.getStartParameter(), settings);
        if (!includedBuilds.isEmpty()) {
            gradle.setIncludedBuilds(includedBuilds);
            CompositeContextBuilder compositeContextBuilder = (CompositeContextBuilder)this.buildServices.get(CompositeContextBuilder.class);
            compositeContextBuilder.addToCompositeContext(includedBuilds);
        }
        return settings;
    }

    private Collection<IncludedBuild> getIncludedBuilds(StartParameter startParameter, SettingsInternal settings) {
        LinkedHashMap includedBuildMap = Maps.newLinkedHashMap();
        includedBuildMap.putAll(settings.getIncludedBuilds());
        for (File file : startParameter.getIncludedBuilds()) {
            IncludedBuildFactory includedBuildFactory = (IncludedBuildFactory)this.buildServices.get(IncludedBuildFactory.class);
            if (includedBuildMap.containsKey(file)) continue;
            includedBuildMap.put(file, includedBuildFactory.createBuild(file));
        }
        return this.validateBuildNames(includedBuildMap.values(), settings);
    }

    private Collection<IncludedBuild> validateBuildNames(Collection<IncludedBuild> builds, SettingsInternal settings) {
        HashSet names = Sets.newHashSet();
        for (IncludedBuild build : builds) {
            String buildName = build.getName();
            if (!names.add(buildName)) {
                throw new GradleException("Included build '" + buildName + "' is not unique in composite.");
            }
            if (settings.getRootProject().getName().equals(buildName)) {
                throw new GradleException("Included build '" + buildName + "' collides with root project name.");
            }
            if (settings.findProject(":" + buildName) == null) continue;
            throw new GradleException("Included build '" + buildName + "' collides with subproject of the same name.");
        }
        return builds;
    }
}

