/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile.builtin;

import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ProfilingDynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.profile.MethodEnhancer;
import org.jruby.runtime.profile.ProfileCollection;
import org.jruby.runtime.profile.ProfileReporter;
import org.jruby.runtime.profile.ProfilingService;
import org.jruby.runtime.profile.builtin.ProfileData;
import org.jruby.runtime.profile.builtin.ProfileOutput;
import org.jruby.runtime.profile.builtin.ProfilePrinter;

public class BuiltinProfilingService
implements ProfilingService {
    @Override
    public ProfileData newProfileCollection(ThreadContext context) {
        return new ProfileData(context);
    }

    @Override
    public DefaultMethodEnhancer newMethodEnhancer(Ruby runtime) {
        return new DefaultMethodEnhancer(runtime);
    }

    @Override
    public DefaultProfileReporter newProfileReporter(ThreadContext context) {
        return new DefaultProfileReporter(context);
    }

    private static final class DefaultProfileReporter
    implements ProfileReporter {
        private final ThreadContext context;

        public DefaultProfileReporter(ThreadContext context) {
            if (context == null) {
                throw new IllegalArgumentException("Given context must not be null.");
            }
            this.context = context;
        }

        private Ruby getRuntime() {
            return this.context.runtime;
        }

        private RubyInstanceConfig getConfig() {
            return this.getRuntime().getInstanceConfig();
        }

        @Override
        public void report(ProfileCollection collector) {
            if (!(collector instanceof ProfileData)) {
                throw new IllegalArgumentException("Given collector must be an instance of " + ProfileData.class.getName() + ".");
            }
            RubyInstanceConfig config = this.getConfig();
            ProfileData profileData = (ProfileData)collector;
            ProfileOutput output = config.getProfileOutput();
            ProfilePrinter profilePrinter = ProfilePrinter.newPrinter(config.getProfilingMode(), profileData);
            if (profilePrinter != null) {
                output.printProfile(profilePrinter);
            } else {
                this.getRuntime().getOut().println("\nno printer for profile mode: " + (Object)((Object)config.getProfilingMode()) + " !");
            }
        }
    }

    private static final class DefaultMethodEnhancer
    implements MethodEnhancer {
        private final Ruby runtime;

        public DefaultMethodEnhancer(Ruby runtime) {
            this.runtime = runtime;
        }

        private Ruby getRuntime() {
            return this.runtime;
        }

        @Override
        public DynamicMethod enhance(String name2, DynamicMethod delegate) {
            this.getRuntime().getProfiledMethods().addProfiledMethod(name2, delegate);
            return new ProfilingDynamicMethod(delegate);
        }
    }
}

