/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.digest;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.security.MessageDigest;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.stdlib.digest.DigestAlgorithm;
import org.jruby.truffle.stdlib.digest.DigestLayout;

@GeneratedBy(value=DigestLayout.class)
public class DigestLayoutImpl
extends BasicObjectLayoutImpl
implements DigestLayout {
    public static final DigestLayout INSTANCE = new DigestLayoutImpl();
    protected static final Shape.Allocator DIGEST_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ALGORITHM_IDENTIFIER = new HiddenKey("algorithm");
    protected static final Property ALGORITHM_PROPERTY = Property.create(ALGORITHM_IDENTIFIER, DIGEST_ALLOCATOR.locationForType(DigestAlgorithm.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey DIGEST_IDENTIFIER = new HiddenKey("digest");
    protected static final Property DIGEST_PROPERTY = Property.create(DIGEST_IDENTIFIER, DIGEST_ALLOCATOR.locationForType(MessageDigest.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);

    protected DigestLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createDigestShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new DigestType(logicalClass, metaClass)).addProperty(ALGORITHM_PROPERTY).addProperty(DIGEST_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createDigest(DynamicObjectFactory factory, DigestAlgorithm algorithm, MessageDigest digest) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (DigestLayoutImpl.createsDigest(factory));
        assert (factory.getShape().hasProperty(ALGORITHM_IDENTIFIER));
        assert (factory.getShape().hasProperty(DIGEST_IDENTIFIER));
        assert (algorithm != null);
        assert (digest != null);
        return factory.newInstance(new Object[]{algorithm, digest});
    }

    private static boolean isDigest(DynamicObject object) {
        return DigestLayoutImpl.isDigest(object.getShape().getObjectType());
    }

    private static boolean isDigest(ObjectType objectType) {
        return objectType instanceof DigestType;
    }

    private static boolean createsDigest(DynamicObjectFactory factory) {
        return DigestLayoutImpl.isDigest(factory.getShape().getObjectType());
    }

    @Override
    public DigestAlgorithm getAlgorithm(DynamicObject object) {
        assert (DigestLayoutImpl.isDigest(object));
        assert (object.getShape().hasProperty(ALGORITHM_IDENTIFIER));
        return (DigestAlgorithm)((Object)ALGORITHM_PROPERTY.get(object, DigestLayoutImpl.isDigest(object)));
    }

    @Override
    public MessageDigest getDigest(DynamicObject object) {
        assert (DigestLayoutImpl.isDigest(object));
        assert (object.getShape().hasProperty(DIGEST_IDENTIFIER));
        return (MessageDigest)DIGEST_PROPERTY.get(object, DigestLayoutImpl.isDigest(object));
    }

    public static class DigestType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public DigestType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public DigestType setLogicalClass(DynamicObject logicalClass) {
            return new DigestType(logicalClass, this.metaClass);
        }

        @Override
        public DigestType setMetaClass(DynamicObject metaClass) {
            return new DigestType(this.logicalClass, metaClass);
        }
    }
}

