/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NotNullLazyValue");
    private T myValue;

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result2 = this.myValue;
        if (result2 == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            result2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result2;
            }
        }
        T t = result2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue", "getValue"));
        }
        return t;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(final @NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        NotNullLazyValue notNullLazyValue = new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object object = value;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$1", "compute"));
                }
                return object;
            }
        };
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        return notNullLazyValue;
    }
}

