/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterUpdateSettingsAction
extends TransportMasterNodeAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private final AllocationService allocationService;
    private final DynamicSettings dynamicSettings;

    @Inject
    public TransportClusterUpdateSettingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, @ClusterDynamicSettings DynamicSettings dynamicSettings, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/settings/update", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterUpdateSettingsRequest.class);
        this.allocationService = allocationService;
        this.dynamicSettings = dynamicSettings;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterUpdateSettingsRequest request, ClusterState state) {
        if (request.transientSettings().getAsMap().isEmpty() && request.persistentSettings().getAsMap().size() == 1 && request.persistentSettings().get("cluster.blocks.read_only") != null || request.persistentSettings().getAsMap().isEmpty() && request.transientSettings().getAsMap().size() == 1 && request.transientSettings().get("cluster.blocks.read_only") != null) {
            return null;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterUpdateSettingsResponse newResponse() {
        return new ClusterUpdateSettingsResponse();
    }

    @Override
    protected void masterOperation(final ClusterUpdateSettingsRequest request, ClusterState state, final ActionListener<ClusterUpdateSettingsResponse> listener) {
        final Settings.Builder transientUpdates = Settings.settingsBuilder();
        final Settings.Builder persistentUpdates = Settings.settingsBuilder();
        this.clusterService.submitStateUpdateTask("cluster_update_settings", new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.IMMEDIATE, (AckedRequest)request, listener){
            private volatile boolean changed;
            {
                super(x0, x1, x2);
                this.changed = false;
            }

            @Override
            protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                return new ClusterUpdateSettingsResponse(acknowledged, transientUpdates.build(), persistentUpdates.build());
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    super.onAllNodesAcked(t);
                }
            }

            @Override
            public void onAckTimeout() {
                if (this.changed) {
                    this.reroute(false);
                } else {
                    super.onAckTimeout();
                }
            }

            private void reroute(final boolean updateSettingsAcked) {
                if (!TransportClusterUpdateSettingsAction.this.clusterService.state().nodes().localNodeMaster()) {
                    TransportClusterUpdateSettingsAction.this.logger.debug("Skipping reroute after cluster update settings, because node is no longer master", new Object[0]);
                    listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, transientUpdates.build(), persistentUpdates.build()));
                    return;
                }
                TransportClusterUpdateSettingsAction.this.clusterService.submitStateUpdateTask("reroute_after_cluster_update_settings", new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.URGENT, (AckedRequest)request, listener){

                    @Override
                    public boolean mustAck(DiscoveryNode discoveryNode) {
                        return updateSettingsAcked;
                    }

                    @Override
                    protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                        return new ClusterUpdateSettingsResponse(updateSettingsAcked && acknowledged, transientUpdates.build(), persistentUpdates.build());
                    }

                    @Override
                    public void onNoLongerMaster(String source) {
                        TransportClusterUpdateSettingsAction.this.logger.debug("failed to preform reroute after cluster settings were updated - current node is no longer a master", new Object[0]);
                        listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, transientUpdates.build(), persistentUpdates.build()));
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        TransportClusterUpdateSettingsAction.this.logger.debug("failed to perform [{}]", t, source);
                        listener.onFailure(new ElasticsearchException("reroute after update settings failed", t, new Object[0]));
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        RoutingAllocation.Result routingResult = TransportClusterUpdateSettingsAction.this.allocationService.reroute(currentState, "reroute after cluster update settings");
                        if (!routingResult.changed()) {
                            return currentState;
                        }
                        return ClusterState.builder(currentState).routingResult(routingResult).build();
                    }
                });
            }

            @Override
            public void onFailure(String source, Throwable t) {
                TransportClusterUpdateSettingsAction.this.logger.debug("failed to perform [{}]", t, source);
                super.onFailure(source, t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean updatedReadOnly;
                Settings.Builder transientSettings = Settings.settingsBuilder();
                transientSettings.put(currentState.metaData().transientSettings());
                for (Map.Entry<String, String> entry : request.transientSettings().getAsMap().entrySet()) {
                    if (TransportClusterUpdateSettingsAction.this.dynamicSettings.isDynamicOrLoggingSetting(entry.getKey())) {
                        String error = TransportClusterUpdateSettingsAction.this.dynamicSettings.validateDynamicSetting(entry.getKey(), entry.getValue(), TransportClusterUpdateSettingsAction.this.clusterService.state());
                        if (error == null) {
                            transientSettings.put(entry.getKey(), entry.getValue());
                            transientUpdates.put(entry.getKey(), entry.getValue());
                            this.changed = true;
                            continue;
                        }
                        TransportClusterUpdateSettingsAction.this.logger.warn("ignoring transient setting [{}], [{}]", entry.getKey(), error);
                        continue;
                    }
                    TransportClusterUpdateSettingsAction.this.logger.warn("ignoring transient setting [{}], not dynamically updateable", entry.getKey());
                }
                Settings.Builder persistentSettings = Settings.settingsBuilder();
                persistentSettings.put(currentState.metaData().persistentSettings());
                for (Map.Entry<String, String> entry : request.persistentSettings().getAsMap().entrySet()) {
                    if (TransportClusterUpdateSettingsAction.this.dynamicSettings.isDynamicOrLoggingSetting(entry.getKey())) {
                        String error = TransportClusterUpdateSettingsAction.this.dynamicSettings.validateDynamicSetting(entry.getKey(), entry.getValue(), TransportClusterUpdateSettingsAction.this.clusterService.state());
                        if (error == null) {
                            persistentSettings.put(entry.getKey(), entry.getValue());
                            persistentUpdates.put(entry.getKey(), entry.getValue());
                            this.changed = true;
                            continue;
                        }
                        TransportClusterUpdateSettingsAction.this.logger.warn("ignoring persistent setting [{}], [{}]", entry.getKey(), error);
                        continue;
                    }
                    TransportClusterUpdateSettingsAction.this.logger.warn("ignoring persistent setting [{}], not dynamically updateable", entry.getKey());
                }
                if (!this.changed) {
                    return currentState;
                }
                MetaData.Builder metaData = MetaData.builder(currentState.metaData()).persistentSettings(persistentSettings.build()).transientSettings(transientSettings.build());
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                boolean bl = updatedReadOnly = metaData.persistentSettings().getAsBoolean("cluster.blocks.read_only", (Boolean)false) != false || metaData.transientSettings().getAsBoolean("cluster.blocks.read_only", (Boolean)false) != false;
                if (updatedReadOnly) {
                    blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                } else {
                    blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                }
                return ClusterState.builder(currentState).metaData(metaData).blocks(blocks).build();
            }
        });
    }
}

