/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.fieldstats.FieldStatsRequest;
import org.elasticsearch.action.fieldstats.FieldStatsResponse;
import org.elasticsearch.action.fieldstats.FieldStatsShardRequest;
import org.elasticsearch.action.fieldstats.FieldStatsShardResponse;
import org.elasticsearch.action.fieldstats.IndexConstraint;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportFieldStatsTransportAction
extends TransportBroadcastAction<FieldStatsRequest, FieldStatsResponse, FieldStatsShardRequest, FieldStatsShardResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportFieldStatsTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super(settings, "indices:data/read/field_stats", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, FieldStatsRequest.class, FieldStatsShardRequest.class, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected FieldStatsResponse newResponse(FieldStatsRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        HashMap<String, Map<String, FieldStats>> indicesMergedFieldStats = new HashMap<String, Map<String, FieldStats>>();
        ArrayList<ShardOperationFailedException> shardFailures = new ArrayList<ShardOperationFailedException>();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            String indexName;
            Object shardValue = shardsResponses.get(i);
            if (shardValue == null) continue;
            if (shardValue instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardValue));
                continue;
            }
            ++successfulShards;
            FieldStatsShardResponse shardResponse = (FieldStatsShardResponse)shardValue;
            if ("cluster".equals(request.level())) {
                indexName = "_all";
            } else if ("indices".equals(request.level())) {
                indexName = shardResponse.getIndex();
            } else {
                throw new IllegalArgumentException("Illegal level option [" + request.level() + "]");
            }
            HashMap<String, FieldStats> indexMergedFieldStats = (HashMap<String, FieldStats>)indicesMergedFieldStats.get(indexName);
            if (indexMergedFieldStats == null) {
                indexMergedFieldStats = new HashMap<String, FieldStats>();
                indicesMergedFieldStats.put(indexName, indexMergedFieldStats);
            }
            Map<String, FieldStats> fieldStats = shardResponse.getFieldStats();
            for (Map.Entry<String, FieldStats> entry : fieldStats.entrySet()) {
                FieldStats existing = (FieldStats)indexMergedFieldStats.get(entry.getKey());
                if (existing != null) {
                    if (existing.getType() != entry.getValue().getType()) {
                        throw new IllegalStateException("trying to merge the field stats of field [" + entry.getKey() + "] from index [" + shardResponse.getIndex() + "] but the field type is incompatible, try to set the 'level' option to 'indices'");
                    }
                    existing.append(entry.getValue());
                    continue;
                }
                indexMergedFieldStats.put(entry.getKey(), entry.getValue());
            }
        }
        if (request.getIndexConstraints().length != 0) {
            HashSet<String> fieldStatFields = new HashSet<String>(Arrays.asList(request.getFields()));
            for (IndexConstraint indexConstraint : request.getIndexConstraints()) {
                Iterator iterator = indicesMergedFieldStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    FieldStats indexConstraintFieldStats = (FieldStats)((Map)entry.getValue()).get(indexConstraint.getField());
                    if (indexConstraintFieldStats != null && indexConstraintFieldStats.match(indexConstraint)) {
                        if (fieldStatFields.contains(indexConstraint.getField())) continue;
                        ((Map)entry.getValue()).remove(indexConstraint.getField());
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
        return new FieldStatsResponse(shardsResponses.length(), successfulShards, failedShards, shardFailures, indicesMergedFieldStats);
    }

    @Override
    protected FieldStatsShardRequest newShardRequest(int numShards, ShardRouting shard, FieldStatsRequest request) {
        return new FieldStatsShardRequest(shard.shardId(), request);
    }

    @Override
    protected FieldStatsShardResponse newShardResponse() {
        return new FieldStatsShardResponse();
    }

    @Override
    protected FieldStatsShardResponse shardOperation(FieldStatsShardRequest request) {
        ShardId shardId = request.shardId();
        HashMap<String, FieldStats> fieldStats = new HashMap<String, FieldStats>();
        IndexService indexServices = this.indicesService.indexServiceSafe(shardId.getIndex());
        MapperService mapperService = indexServices.mapperService();
        IndexShard shard = indexServices.shardSafe(shardId.id());
        try (Engine.Searcher searcher = shard.acquireSearcher("fieldstats");){
            for (String field : request.getFields()) {
                MappedFieldType fieldType = mapperService.fullName(field);
                if (fieldType != null) {
                    IndexReader reader = searcher.reader();
                    Terms terms = MultiFields.getTerms((IndexReader)reader, (String)field);
                    if (terms == null) continue;
                    fieldStats.put(field, fieldType.stats(terms, reader.maxDoc()));
                    continue;
                }
                throw new IllegalArgumentException("field [" + field + "] doesn't exist");
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        return new FieldStatsShardResponse(shardId, fieldStats);
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, FieldStatsRequest request, String[] concreteIndices) {
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, null, null);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, FieldStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, FieldStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }
}

