/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Locale;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class EnableAllocationDecider
extends AllocationDecider
implements NodeSettingsService.Listener {
    public static final String NAME = "enable";
    public static final String CLUSTER_ROUTING_ALLOCATION_ENABLE = "cluster.routing.allocation.enable";
    public static final String INDEX_ROUTING_ALLOCATION_ENABLE = "index.routing.allocation.enable";
    public static final String CLUSTER_ROUTING_REBALANCE_ENABLE = "cluster.routing.rebalance.enable";
    public static final String INDEX_ROUTING_REBALANCE_ENABLE = "index.routing.rebalance.enable";
    private volatile Rebalance enableRebalance;
    private volatile Allocation enableAllocation;

    @Inject
    public EnableAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.enableAllocation = Allocation.parse(settings.get(CLUSTER_ROUTING_ALLOCATION_ENABLE, Allocation.ALL.name()));
        this.enableRebalance = Rebalance.parse(settings.get(CLUSTER_ROUTING_REBALANCE_ENABLE, Rebalance.ALL.name()));
        nodeSettingsService.addListener(this);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "allocation disabling is ignored", new Object[0]);
        }
        Settings indexSettings = allocation.routingNodes().metaData().index(shardRouting.index()).getSettings();
        String enableIndexValue = indexSettings.get(INDEX_ROUTING_ALLOCATION_ENABLE);
        Allocation enable = enableIndexValue != null ? Allocation.parse(enableIndexValue) : this.enableAllocation;
        switch (enable) {
            case ALL: {
                return allocation.decision(Decision.YES, NAME, "all allocations are allowed", new Object[0]);
            }
            case NONE: {
                return allocation.decision(Decision.NO, NAME, "no allocations are allowed", new Object[0]);
            }
            case NEW_PRIMARIES: {
                if (shardRouting.primary() && !shardRouting.allocatedPostIndexCreate()) {
                    return allocation.decision(Decision.YES, NAME, "new primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "non-new primary allocations are forbidden", new Object[0]);
            }
            case PRIMARIES: {
                if (shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "replica allocations are forbidden", new Object[0]);
            }
        }
        throw new IllegalStateException("Unknown allocation option");
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "rebalance disabling is ignored", new Object[0]);
        }
        Settings indexSettings = allocation.routingNodes().metaData().index(shardRouting.index()).getSettings();
        String enableIndexValue = indexSettings.get(INDEX_ROUTING_REBALANCE_ENABLE);
        Rebalance enable = enableIndexValue != null ? Rebalance.parse(enableIndexValue) : this.enableRebalance;
        switch (enable) {
            case ALL: {
                return allocation.decision(Decision.YES, NAME, "all rebalancing is allowed", new Object[0]);
            }
            case NONE: {
                return allocation.decision(Decision.NO, NAME, "no rebalancing is allowed", new Object[0]);
            }
            case PRIMARIES: {
                if (shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "primary rebalancing is allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "replica rebalancing is forbidden", new Object[0]);
            }
            case REPLICAS: {
                if (!shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "replica rebalancing is allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "primary rebalancing is forbidden", new Object[0]);
            }
        }
        throw new IllegalStateException("Unknown rebalance option");
    }

    @Override
    public void onRefreshSettings(Settings settings) {
        Rebalance enableRebalance;
        Allocation enable = Allocation.parse(settings.get(CLUSTER_ROUTING_ALLOCATION_ENABLE, this.enableAllocation.name()));
        if (enable != this.enableAllocation) {
            this.logger.info("updating [{}] from [{}] to [{}]", new Object[]{CLUSTER_ROUTING_ALLOCATION_ENABLE, this.enableAllocation, enable});
            this.enableAllocation = enable;
        }
        if ((enableRebalance = Rebalance.parse(settings.get(CLUSTER_ROUTING_REBALANCE_ENABLE, this.enableRebalance.name()))) != this.enableRebalance) {
            this.logger.info("updating [{}] from [{}] to [{}]", new Object[]{CLUSTER_ROUTING_REBALANCE_ENABLE, this.enableRebalance, enableRebalance});
            this.enableRebalance = enableRebalance;
        }
    }

    public static enum Rebalance {
        NONE,
        PRIMARIES,
        REPLICAS,
        ALL;


        public static Rebalance parse(String strValue) {
            if (strValue == null) {
                return null;
            }
            strValue = strValue.toUpperCase(Locale.ROOT);
            try {
                return Rebalance.valueOf(strValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal rebalance.enable value [" + strValue + "]");
            }
        }
    }

    public static enum Allocation {
        NONE,
        NEW_PRIMARIES,
        PRIMARIES,
        ALL;


        public static Allocation parse(String strValue) {
            if (strValue == null) {
                return null;
            }
            strValue = strValue.toUpperCase(Locale.ROOT);
            try {
                return Allocation.valueOf(strValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal allocation.enable value [" + strValue + "]");
            }
        }
    }
}

