/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;

public class BulkByScrollTask
extends CancellableTask {
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong updated = new AtomicLong(0L);
    private final AtomicLong created = new AtomicLong(0L);
    private final AtomicLong deleted = new AtomicLong(0L);
    private final AtomicLong noops = new AtomicLong(0L);
    private final AtomicInteger batch = new AtomicInteger(0);
    private final AtomicLong versionConflicts = new AtomicLong(0L);
    private final AtomicLong retries = new AtomicLong(0L);
    private final AtomicLong throttledNanos = new AtomicLong();
    private volatile float requestsPerSecond;
    private final AtomicReference<DelayedPrepareBulkRequest> delayedPrepareBulkRequestReference = new AtomicReference();

    public BulkByScrollTask(long id, String type, String action, String description, float requestsPerSecond) {
        super(id, type, action, description);
        this.setRequestsPerSecond(requestsPerSecond);
    }

    protected void onCancelled() {
        this.rethrottle(0.0f);
    }

    public Status getStatus() {
        return new Status(this.total.get(), this.updated.get(), this.created.get(), this.deleted.get(), this.batch.get(), this.versionConflicts.get(), this.noops.get(), this.retries.get(), TimeValue.timeValueNanos((long)this.throttledNanos.get()), this.getRequestsPerSecond(), this.getReasonCancelled(), this.throttledUntil());
    }

    private TimeValue throttledUntil() {
        DelayedPrepareBulkRequest delayed = this.delayedPrepareBulkRequestReference.get();
        if (delayed == null) {
            return TimeValue.timeValueNanos((long)0L);
        }
        if (delayed.future == null) {
            return TimeValue.timeValueNanos((long)0L);
        }
        return TimeValue.timeValueNanos((long)Math.max(0L, delayed.future.getDelay(TimeUnit.NANOSECONDS)));
    }

    public long getSuccessfullyProcessed() {
        return this.updated.get() + this.created.get() + this.deleted.get();
    }

    public String toString() {
        return Strings.toString((ToXContent)this.getStatus());
    }

    void setTotal(long totalHits) {
        this.total.set(totalHits);
    }

    void countBatch() {
        this.batch.incrementAndGet();
    }

    void countNoop() {
        this.noops.incrementAndGet();
    }

    void countCreated() {
        this.created.incrementAndGet();
    }

    void countUpdated() {
        this.updated.incrementAndGet();
    }

    void countDeleted() {
        this.deleted.incrementAndGet();
    }

    void countVersionConflict() {
        this.versionConflicts.incrementAndGet();
    }

    void countRetry() {
        this.retries.incrementAndGet();
    }

    float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delayPrepareBulkRequest(ThreadPool threadPool, TimeValue delay, final AbstractRunnable prepareBulkRequestRunnable) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            AbstractRunnable oneTime = new AbstractRunnable(){
                private final AtomicBoolean hasRun = new AtomicBoolean(false);

                protected void doRun() throws Exception {
                    if (this.hasRun.compareAndSet(false, true)) {
                        prepareBulkRequestRunnable.run();
                    }
                }

                public void onFailure(Throwable t) {
                    prepareBulkRequestRunnable.onFailure(t);
                }
            };
            this.delayedPrepareBulkRequestReference.set(new DelayedPrepareBulkRequest(threadPool, this.getRequestsPerSecond(), delay, oneTime));
        }
    }

    private void setRequestsPerSecond(float requestsPerSecond) {
        this.requestsPerSecond = requestsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rethrottle(float newRequestsPerSecond) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            this.setRequestsPerSecond(newRequestsPerSecond);
            DelayedPrepareBulkRequest delayedPrepareBulkRequest = this.delayedPrepareBulkRequestReference.get();
            if (delayedPrepareBulkRequest == null) {
                return;
            }
            this.delayedPrepareBulkRequestReference.set(delayedPrepareBulkRequest.rethrottle(newRequestsPerSecond));
        }
    }

    class DelayedPrepareBulkRequest {
        private final ThreadPool threadPool;
        private final AbstractRunnable command;
        private final float requestsPerSecond;
        private final ScheduledFuture<?> future;

        DelayedPrepareBulkRequest(ThreadPool threadPool, float requestsPerSecond, final TimeValue delay, final AbstractRunnable command) {
            this.threadPool = threadPool;
            this.requestsPerSecond = requestsPerSecond;
            this.command = command;
            this.future = threadPool.schedule(delay, "generic", (Runnable)new AbstractRunnable(){

                protected void doRun() throws Exception {
                    BulkByScrollTask.this.throttledNanos.addAndGet(delay.nanos());
                    command.run();
                }

                public void onFailure(Throwable t) {
                    command.onFailure(t);
                }
            });
        }

        DelayedPrepareBulkRequest rethrottle(float newRequestsPerSecond) {
            if (newRequestsPerSecond != 0.0f && newRequestsPerSecond < this.requestsPerSecond) {
                return this;
            }
            long remainingDelay = this.future.getDelay(TimeUnit.NANOSECONDS);
            if (!FutureUtils.cancel(this.future)) {
                return this;
            }
            TimeValue newDelay = this.newDelay(remainingDelay, newRequestsPerSecond);
            return new DelayedPrepareBulkRequest(this.threadPool, this.requestsPerSecond, newDelay, this.command);
        }

        TimeValue newDelay(long remainingDelay, float newRequestsPerSecond) {
            if (remainingDelay < 0L || newRequestsPerSecond == 0.0f) {
                return TimeValue.timeValueNanos((long)0L);
            }
            return TimeValue.timeValueNanos((long)Math.round((float)remainingDelay * this.requestsPerSecond / newRequestsPerSecond));
        }
    }

    public static class Status
    implements Task.Status {
        public static final Status PROTOTYPE = new Status(0L, 0L, 0L, 0L, 0, 0L, 0L, 0L, null, 0.0f, null, null);
        public static final String NAME = "bulk-by-scroll";
        private final long total;
        private final long updated;
        private final long created;
        private final long deleted;
        private final int batches;
        private final long versionConflicts;
        private final long noops;
        private final long retries;
        private final TimeValue throttled;
        private final float requestsPerSecond;
        private final String reasonCancelled;
        private final TimeValue throttledUntil;

        public Status(long total, long updated, long created, long deleted, int batches, long versionConflicts, long noops, long retries, TimeValue throttled, float requestsPerSecond, @Nullable String reasonCancelled, TimeValue throttledUntil) {
            this.total = this.checkPositive(total, "total");
            this.updated = this.checkPositive(updated, "updated");
            this.created = this.checkPositive(created, "created");
            this.deleted = this.checkPositive(deleted, "deleted");
            this.batches = this.checkPositive(batches, "batches");
            this.versionConflicts = this.checkPositive(versionConflicts, "versionConflicts");
            this.noops = this.checkPositive(noops, "noops");
            this.retries = this.checkPositive(retries, "retries");
            this.throttled = throttled;
            this.requestsPerSecond = requestsPerSecond;
            this.reasonCancelled = reasonCancelled;
            this.throttledUntil = throttledUntil;
        }

        public Status(StreamInput in) throws IOException {
            this.total = in.readVLong();
            this.updated = in.readVLong();
            this.created = in.readVLong();
            this.deleted = in.readVLong();
            this.batches = in.readVInt();
            this.versionConflicts = in.readVLong();
            this.noops = in.readVLong();
            this.retries = in.readVLong();
            if (in.getVersion().onOrAfter(Version.V_2_4_0)) {
                this.throttled = TimeValue.readTimeValue((StreamInput)in);
                this.requestsPerSecond = in.readFloat();
            } else {
                this.throttled = TimeValue.timeValueNanos((long)0L);
                this.requestsPerSecond = Float.POSITIVE_INFINITY;
            }
            this.reasonCancelled = in.readOptionalString();
            this.throttledUntil = in.getVersion().onOrAfter(Version.V_2_4_0) ? TimeValue.readTimeValue((StreamInput)in) : TimeValue.timeValueNanos((long)0L);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeVLong(this.updated);
            out.writeVLong(this.created);
            out.writeVLong(this.deleted);
            out.writeVInt(this.batches);
            out.writeVLong(this.versionConflicts);
            out.writeVLong(this.noops);
            out.writeVLong(this.retries);
            if (out.getVersion().onOrAfter(Version.V_2_4_0)) {
                this.throttled.writeTo(out);
                out.writeFloat(this.requestsPerSecond);
            }
            out.writeOptionalString(this.reasonCancelled);
            if (out.getVersion().onOrAfter(Version.V_2_4_0)) {
                this.throttledUntil.writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerXContent(builder, params, true, true);
            return builder.endObject();
        }

        public XContentBuilder innerXContent(XContentBuilder builder, ToXContent.Params params, boolean includeCreated, boolean includeDeleted) throws IOException {
            builder.field("total", this.total);
            builder.field("updated", this.updated);
            if (includeCreated) {
                builder.field("created", this.created);
            }
            if (includeDeleted) {
                builder.field("deleted", this.deleted);
            }
            builder.field("batches", this.batches);
            builder.field("version_conflicts", this.versionConflicts);
            builder.field("noops", this.noops);
            builder.field("retries", this.retries);
            builder.timeValueField("throttled_millis", "throttled", this.throttled);
            builder.field("requests_per_second", this.requestsPerSecond == Float.POSITIVE_INFINITY ? "unlimited" : Float.valueOf(this.requestsPerSecond));
            if (this.reasonCancelled != null) {
                builder.field("canceled", this.reasonCancelled);
            }
            builder.timeValueField("throttled_until_millis", "throttled_until", this.throttledUntil);
            return builder;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BulkIndexByScrollResponse[");
            this.innerToString(builder, true, true);
            return builder.append(']').toString();
        }

        public void innerToString(StringBuilder builder, boolean includeCreated, boolean includeDeleted) {
            builder.append("updated=").append(this.updated);
            if (includeCreated) {
                builder.append(",created=").append(this.created);
            }
            if (includeDeleted) {
                builder.append(",deleted=").append(this.deleted);
            }
            builder.append(",batches=").append(this.batches);
            builder.append(",versionConflicts=").append(this.versionConflicts);
            builder.append(",noops=").append(this.noops);
            builder.append(",retries=").append(this.retries);
            if (this.reasonCancelled != null) {
                builder.append(",canceled=").append(this.reasonCancelled);
            }
            builder.append(",throttledUntil=").append(this.throttledUntil);
        }

        public String getWriteableName() {
            return NAME;
        }

        public Status readFrom(StreamInput in) throws IOException {
            return new Status(in);
        }

        public long getTotal() {
            return this.total;
        }

        public long getUpdated() {
            return this.updated;
        }

        public long getCreated() {
            return this.created;
        }

        public long getDeleted() {
            return this.deleted;
        }

        public int getBatches() {
            return this.batches;
        }

        public long getVersionConflicts() {
            return this.versionConflicts;
        }

        public long getNoops() {
            return this.noops;
        }

        public long getRetries() {
            return this.retries;
        }

        public TimeValue getThrottled() {
            return this.throttled;
        }

        public float getRequestsPerSecond() {
            return this.requestsPerSecond;
        }

        public String getReasonCancelled() {
            return this.reasonCancelled;
        }

        public TimeValue getThrottledUntil() {
            return this.throttledUntil;
        }

        private int checkPositive(int value, String name) {
            if (value < 0) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }

        private long checkPositive(long value, String name) {
            if (value < 0L) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }
    }
}

