/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.StyleSheet;

class CSSWriter {
    private char[] indentChars;
    private final String newLine = System.getProperty("line.separator");
    private final Writer writer;
    private final StyleSheet styleSheet;
    private int indentLen;

    public CSSWriter(Writer writer, StyleSheet styleSheet) {
        this.writer = writer;
        this.styleSheet = styleSheet;
    }

    public void write() throws IOException {
        Enumeration<?> rules = this.styleSheet.getStyleNames();
        while (rules.hasMoreElements()) {
            this.writeRule((String)rules.nextElement());
            try {
                Thread.currentThread();
                Thread.sleep(0L, 1);
            }
            catch (Exception exception) {}
        }
    }

    private void writeRule(String ruleName) throws IOException {
        this.writeRule(ruleName, this.styleSheet.getStyle(ruleName));
    }

    public void writeRule(String ruleName, AttributeSet rule) throws IOException {
        this.indentLen = ruleName.length() + 3;
        if (!ruleName.equalsIgnoreCase("default")) {
            this.writer.write(ruleName);
            this.writer.write(" { ");
            this.writeStyle(rule);
            this.writer.write(this.newLine);
        }
    }

    private boolean writeStyle(AttributeSet style) throws IOException {
        boolean closed = false;
        Enumeration<?> names = style.getAttributeNames();
        int count = 0;
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = style.getAttribute(key);
            if (!key.equals(StyleConstants.NameAttribute) && !key.equals(StyleConstants.ResolveAttribute)) {
                if (count > 0) {
                    this.writer.write(this.newLine);
                    this.indent(this.indentLen);
                } else {
                    ++count;
                }
                this.writer.write(key.toString());
                this.writer.write(":");
                this.writer.write(value.toString());
                this.writer.write(";");
                continue;
            }
            if (!key.equals(StyleConstants.ResolveAttribute)) continue;
            closed = this.writeStyle((Style)value);
        }
        if (!closed) {
            this.writer.write(" }");
            this.writer.write(this.newLine);
            closed = true;
        }
        return closed;
    }

    private void indent(int len) throws IOException {
        if (this.indentChars == null || len > this.indentChars.length) {
            this.indentChars = new char[len];
            for (int i = 0; i < len; ++i) {
                this.indentChars[i] = 32;
            }
        }
        this.writer.write(this.indentChars, 0, len);
    }
}

