/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputUILord;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.CommandLineTab;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.FavoriteTasksTab;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.GradleTab;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.SetupTab;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.TaskTreeTab;

public class MainGradlePanel
extends JPanel {
    private static final String CURRENT_TAB = "current-tab";
    private static final String MAIN_PANEL = "main_panel";
    private GradlePluginLord gradlePluginLord;
    private SettingsNode settings;
    private AlternateUIInteraction alternateUIInteraction;
    private List<GradleTab> gradleTabs = new ArrayList<GradleTab>();
    private JTabbedPane tabbedPane;
    private SetupTab setupTab;

    public MainGradlePanel(GradlePluginLord gradlePluginLord, OutputUILord outputUILord, SettingsNode settings, AlternateUIInteraction alternateUIInteraction) {
        this.alternateUIInteraction = alternateUIInteraction;
        this.gradlePluginLord = gradlePluginLord;
        this.settings = settings;
        this.addDefaultTabs(outputUILord, alternateUIInteraction);
    }

    private void addDefaultTabs(OutputUILord outputUILord, AlternateUIInteraction alternateUIInteraction) {
        this.gradleTabs.add(new TaskTreeTab(this.gradlePluginLord, this.settings.addChildIfNotPresent("task-tab"), alternateUIInteraction));
        this.gradleTabs.add(new FavoriteTasksTab(this.gradlePluginLord, this.settings.addChildIfNotPresent("favorites-tab")));
        this.gradleTabs.add(new CommandLineTab(this.gradlePluginLord, this.settings.addChildIfNotPresent("command_line-tab")));
        this.setupTab = new SetupTab(this.gradlePluginLord, outputUILord, this.settings.addChildIfNotPresent("setup-tab"));
        this.gradleTabs.add(this.setupTab);
    }

    private int getGradleTabIndex(Class soughtClass) {
        for (int index = 0; index < this.gradleTabs.size(); ++index) {
            GradleTab gradleTab = this.gradleTabs.get(index);
            if (gradleTab.getClass() != soughtClass) continue;
            return index;
        }
        return -1;
    }

    public int getGradleTabIndex(String name) {
        if (name != null) {
            for (int index = 0; index < this.gradleTabs.size(); ++index) {
                GradleTab gradleTab = this.gradleTabs.get(index);
                if (!name.equals(gradleTab.getName())) continue;
                return index;
            }
        }
        return -1;
    }

    public int getCurrentGradleTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setCurrentGradleTab(int index) {
        if (index >= 0 && index < this.getGradleTabCount()) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    public void addGradleTab(int index, GradleTab gradleTab) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.gradleTabs.size()) {
            index = this.gradleTabs.size();
        }
        this.gradleTabs.add(index, gradleTab);
        if (this.tabbedPane != null) {
            this.addGradleTabToTabbedPane(index, gradleTab);
        }
    }

    private void addGradleTabToTabbedPane(int index, GradleTab gradleTab) {
        this.tabbedPane.add(gradleTab.createComponent(), index);
        this.tabbedPane.setTitleAt(index, gradleTab.getName());
    }

    public void removeGradleTab(GradleTab gradleTab) {
        int existingIndex = this.gradleTabs.indexOf(gradleTab);
        if (existingIndex == -1) {
            return;
        }
        this.gradleTabs.remove(gradleTab);
        this.tabbedPane.remove(existingIndex);
        this.tabbedPane.invalidate();
        this.tabbedPane.revalidate();
        this.tabbedPane.repaint();
    }

    public int getGradleTabCount() {
        return this.gradleTabs.size();
    }

    public String getGradleTabName(int index) {
        return this.gradleTabs.get(index).getName();
    }

    public void aboutToShow() {
        this.setupUI();
        for (GradleTab gradleTab : this.gradleTabs) {
            gradleTab.aboutToShow();
        }
    }

    public void aboutToClose() {
    }

    private void setupUI() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.addTabs();
        this.restoreLastTab();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int selection = MainGradlePanel.this.tabbedPane.getSelectedIndex();
                if (selection >= 0 && selection < MainGradlePanel.this.gradleTabs.size()) {
                    SettingsNode rootNode = MainGradlePanel.this.settings.addChildIfNotPresent(MainGradlePanel.MAIN_PANEL);
                    rootNode.setValueOfChild(MainGradlePanel.CURRENT_TAB, ((GradleTab)MainGradlePanel.this.gradleTabs.get(selection)).getName());
                }
            }
        });
    }

    private void restoreLastTab() {
        if (!this.gradlePluginLord.isSetupComplete()) {
            int tabToSelect = this.getGradleTabIndex(SetupTab.class);
            if (tabToSelect != -1) {
                this.tabbedPane.setSelectedIndex(tabToSelect);
            }
        } else {
            int lastTabIndex = -1;
            SettingsNode rootNode = this.settings.getChildNode(MAIN_PANEL);
            if (rootNode != null) {
                String lastTabName = rootNode.getValueOfChild(CURRENT_TAB, "");
                lastTabIndex = this.getGradleTabIndex(lastTabName);
            }
            if (lastTabIndex != -1) {
                this.tabbedPane.setSelectedIndex(lastTabIndex);
            }
        }
    }

    private void addTabs() {
        for (GradleTab gradleTab : this.gradleTabs) {
            this.tabbedPane.add(gradleTab.getName(), gradleTab.createComponent());
        }
    }

    public void setCustomPanelToSetupTab(JComponent component) {
        this.setupTab.setCustomPanel(component);
    }
}

