/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gwt.dev.js.rhino;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.CodePosition;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.ErrorReporter;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.EvaluatorException;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.MessagesBundle;

public class Context {
    private static MessagesBundle messages = new MessagesBundle();
    private static Hashtable threadContexts = new Hashtable(11);
    private static Object threadLocalCx;
    private static Method threadLocalGet;
    private static Method threadLocalSet;
    int version;
    int errorCount;
    private ErrorReporter errorReporter;
    private boolean generatingSource = true;
    private int enterCount;

    public Context() {
        this.setLanguageVersion(0);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context cx) {
        Context old = Context.getCurrentContext();
        if (cx == null) {
            if (old != null) {
                cx = old;
            } else {
                cx = new Context();
                Context.setThreadContext(cx);
            }
        } else if (cx.enterCount != 0) {
            if (cx != old) {
                throw new RuntimeException("Cannot enter Context active on another thread");
            }
        } else if (old != null) {
            cx = old;
        } else {
            Context.setThreadContext(cx);
        }
        ++cx.enterCount;
        return cx;
    }

    public static void exit() {
        boolean released = false;
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("Calling Context.exit without previous Context.enter");
        }
        if (cx.enterCount < 1) {
            Context.codeBug();
        }
        --cx.enterCount;
        if (cx.enterCount == 0) {
            released = true;
            Context.setThreadContext(null);
        }
    }

    public static Context getCurrentContext() {
        if (threadLocalCx != null) {
            try {
                return (Context)threadLocalGet.invoke(threadLocalCx, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        return (Context)threadContexts.get(t);
    }

    private static void setThreadContext(Context cx) {
        if (threadLocalCx != null) {
            try {
                threadLocalSet.invoke(threadLocalCx, cx);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        if (cx != null) {
            threadContexts.put(t, cx);
        } else {
            threadContexts.remove(t);
        }
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int version) {
        this.version = version;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter reporter) {
        this.errorReporter = reporter;
        return reporter;
    }

    public static void reportWarning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/com/google/gwt/dev/js/rhino/Context", "reportWarning"));
        }
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "org/jetbrains/kotlin/com/google/gwt/dev/js/rhino/Context", "reportWarning"));
        }
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "org/jetbrains/kotlin/com/google/gwt/dev/js/rhino/Context", "reportWarning"));
        }
        Context cx = Context.getContext();
        cx.getErrorReporter().warning(message, startPosition, endPosition);
    }

    public static void reportError(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/com/google/gwt/dev/js/rhino/Context", "reportError"));
        }
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "org/jetbrains/kotlin/com/google/gwt/dev/js/rhino/Context", "reportError"));
        }
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "org/jetbrains/kotlin/com/google/gwt/dev/js/rhino/Context", "reportError"));
        }
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
        } else {
            throw new EvaluatorException(message);
        }
        cx.getErrorReporter().error(message, startPosition, endPosition);
    }

    public boolean hasFeature(int featureIndex) {
        switch (featureIndex) {
            case 1: {
                return this.version == 100 || this.version == 110 || this.version == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.version == 120;
            }
        }
        throw new IllegalArgumentException();
    }

    static String getMessage0(String messageId) {
        return Context.getMessage(messageId, null);
    }

    static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return Context.getMessage(messageId, arguments);
    }

    static Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return cx;
    }

    static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        try {
            formatString = messages.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("No message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }

    static void codeBug() {
        throw new RuntimeException("FAILED ASSERTION");
    }
}

