/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.io.BufferedInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.StringInterner;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;
import org.jetbrains.kotlin.org.jdom.Text;
import org.jetbrains.kotlin.org.jdom.filter.Filter;
import org.jetbrains.kotlin.org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOMUtil {
    private static final ThreadLocal<SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent2, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        if (parent2 != null) {
            List<Element> list2 = parent2.getChildren(name);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "getChildren"));
            }
            return list2;
        }
        List<Element> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        return list3;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.attListsEqual(e1.getAttributes(), e2.getAttributes()) && JDOMUtil.contentListsEqual(e1.getContent(CONTENT_FILTER), e2.getContent(CONTENT_FILTER));
    }

    public static void addContent(@NotNull Element targetElement, Object node) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "addContent"));
        }
        if (node instanceof Content) {
            Content content = (Content)node;
            targetElement.addContent(content);
        } else if (node instanceof List) {
            targetElement.addContent((List)node);
        } else {
            throw new IllegalArgumentException("Wrong node: " + node);
        }
    }

    public static void internElement(@NotNull Element element, @NotNull StringInterner interner) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        if (interner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interner", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        element.setName(interner.intern(element.getName()));
        for (Attribute attr : element.getAttributes()) {
            attr.setName(interner.intern(attr.getName()));
            attr.setValue(interner.intern(attr.getValue()));
        }
        for (Content o : element.getContent()) {
            if (o instanceof Element) {
                JDOMUtil.internElement((Element)o, interner);
                continue;
            }
            if (!(o instanceof Text)) continue;
            ((Text)o).setText(interner.intern(o.getValue()));
        }
    }

    private static boolean contentListsEqual(List c12, List c22) {
        if (c12 == null && c22 == null) {
            return true;
        }
        if (c12 == null || c22 == null) {
            return false;
        }
        ListIterator l1 = c12.listIterator();
        ListIterator l2 = c22.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next())) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c12, Content c22) {
        if (!(c12 instanceof Element) && !(c22 instanceof Element)) {
            return c12.getValue().equals(c22.getValue());
        }
        return c12 instanceof Element && c22 instanceof Element && JDOMUtil.areElementsEqual((Element)c12, (Element)c22);
    }

    private static boolean attListsEqual(@NotNull List a1, @NotNull List a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "attListsEqual"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "attListsEqual"));
        }
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            if (JDOMUtil.attEqual((Attribute)a1.get(i), (Attribute)a2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "attEqual"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "attEqual"));
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    private static SAXBuilder getSaxBuilder() {
        SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder saxBuilder = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    InputSource inputSource = new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                    if (inputSource == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$1", "resolveEntity"));
                    }
                    return inputSource;
                }
            });
            ourSaxBuilder.set(new SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @NotNull
    public static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.getSaxBuilder().build(reader);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(File file2) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(new BufferedInputStream(new FileInputStream(file2)));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull InputStream stream2) throws JDOMException, IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(new InputStreamReader(stream2, CharsetToolkit.UTF8_CHARSET));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull Class clazz, String resource) throws JDOMException, IOException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        InputStream stream2 = clazz.getResourceAsStream(resource);
        if (stream2 == null) {
            throw new FileNotFoundException(resource);
        }
        Document document = JDOMUtil.loadDocument(stream2);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(URLUtil.openStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil", "loadResourceDocument"));
        }
        return document;
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }
}

