/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class QualifiedName
implements Comparable<QualifiedName> {
    @NotNull
    private final List<String> myComponents;

    private QualifiedName(int count) {
        this.myComponents = new ArrayList<String>(count);
    }

    public static QualifiedName fromComponents(Collection<String> components) {
        QualifiedName qName = new QualifiedName(components.size());
        qName.myComponents.addAll(components);
        return qName;
    }

    @NotNull
    public static QualifiedName fromComponents(String ... components) {
        QualifiedName result2 = new QualifiedName(components.length);
        Collections.addAll(result2.myComponents, components);
        QualifiedName qualifiedName = result2;
        if (qualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "fromComponents"));
        }
        return qualifiedName;
    }

    public QualifiedName append(String name) {
        QualifiedName result2 = new QualifiedName(this.myComponents.size() + 1);
        result2.myComponents.addAll(this.myComponents);
        result2.myComponents.add(name);
        return result2;
    }

    public QualifiedName append(QualifiedName qName) {
        QualifiedName result2 = new QualifiedName(this.myComponents.size() + qName.getComponentCount());
        result2.myComponents.addAll(this.myComponents);
        result2.myComponents.addAll(qName.getComponents());
        return result2;
    }

    @NotNull
    public QualifiedName removeLastComponent() {
        QualifiedName qualifiedName = this.removeTail(1);
        if (qualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "removeLastComponent"));
        }
        return qualifiedName;
    }

    @NotNull
    public QualifiedName removeTail(int count) {
        int size = this.myComponents.size();
        QualifiedName result2 = new QualifiedName(size);
        result2.myComponents.addAll(this.myComponents);
        for (int i = 0; i < count && !result2.myComponents.isEmpty(); ++i) {
            result2.myComponents.remove(result2.myComponents.size() - 1);
        }
        QualifiedName qualifiedName = result2;
        if (qualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "removeTail"));
        }
        return qualifiedName;
    }

    @NotNull
    public QualifiedName removeHead(int count) {
        int size = this.myComponents.size();
        QualifiedName result2 = new QualifiedName(size);
        result2.myComponents.addAll(this.myComponents);
        for (int i = 0; i < count && !result2.myComponents.isEmpty(); ++i) {
            result2.myComponents.remove(0);
        }
        QualifiedName qualifiedName = result2;
        if (qualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "removeHead"));
        }
        return qualifiedName;
    }

    @NotNull
    public List<String> getComponents() {
        List<String> list2 = this.myComponents;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "getComponents"));
        }
        return list2;
    }

    public int getComponentCount() {
        return this.myComponents.size();
    }

    public boolean matches(String ... components) {
        if (this.myComponents.size() != components.length) {
            return false;
        }
        for (int i = 0; i < this.myComponents.size(); ++i) {
            if (this.myComponents.get(i).equals(components[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPrefix(QualifiedName prefix) {
        if (this.getComponentCount() < prefix.getComponentCount()) {
            return false;
        }
        for (int i = 0; i < prefix.getComponentCount(); ++i) {
            String component = this.getComponents().get(i);
            if (component != null && component.equals(prefix.getComponents().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(@NotNull String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "endsWith"));
        }
        return suffix.equals(this.getLastComponent());
    }

    public static void serialize(@Nullable QualifiedName qName, StubOutputStream dataStream) throws IOException {
        if (qName == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(qName.getComponentCount());
            for (String s : qName.myComponents) {
                dataStream.writeName(s);
            }
        }
    }

    @Nullable
    public static QualifiedName deserialize(StubInputStream dataStream) throws IOException {
        QualifiedName qName;
        int size = dataStream.readVarInt();
        if (size == 0) {
            qName = null;
        } else {
            qName = new QualifiedName(size);
            for (int i = 0; i < size; ++i) {
                StringRef name = dataStream.readName();
                qName.myComponents.add(name == null ? null : name.getString());
            }
        }
        return qName;
    }

    @Nullable
    public String getFirstComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(0);
    }

    @Nullable
    public String getLastComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(this.myComponents.size() - 1);
    }

    public String toString() {
        return this.join(".");
    }

    public String join(String separator) {
        return StringUtil.join(this.myComponents, separator);
    }

    @NotNull
    public static QualifiedName fromDottedString(@NotNull String refName) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "fromDottedString"));
        }
        QualifiedName qualifiedName = QualifiedName.fromComponents(refName.split("\\."));
        if (qualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "fromDottedString"));
        }
        return qualifiedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return this.myComponents.equals(that.myComponents);
    }

    public int hashCode() {
        return this.myComponents.hashCode();
    }

    public QualifiedName subQualifiedName(int fromIndex, int toIndex) {
        return QualifiedName.fromComponents(this.myComponents.subList(fromIndex, toIndex));
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/util/QualifiedName", "compareTo"));
        }
        return this.toString().compareTo(other.toString());
    }
}

