/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.DescriptorResolverUtils;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.types.JavaTypeResolverKt;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationAsAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassObjectAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaEnumValueAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J$\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0(H\u0002J\u0018\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0016\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u000200H\u0016R$\u0010\u0007\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\r\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0016\u001a\r\u0012\t\u0012\u00070\u0017\u00a2\u0006\u0002\b\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaAnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "c", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "javaAnnotation", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "(Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;)V", "allValueArguments", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "fqName", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/annotations/NotNull;", "getJavaAnnotation", "()Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "source", "Lorg/jetbrains/kotlin/load/java/sources/JavaSourceElement;", "type", "Lorg/jetbrains/kotlin/types/SimpleType;", "computeValueArguments", "createTypeForMissingDependencies", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getAllValueArguments", "getAnnotationClass", "getSource", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveAnnotationArgument", "argument", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationArgument;", "resolveFromAnnotation", "resolveFromArray", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "elements", "", "resolveFromEnumValue", "element", "Lorg/jetbrains/kotlin/load/java/structure/JavaField;", "resolveFromJavaClassObjectType", "javaType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "toString", "", "kotlin-compiler"})
public final class LazyJavaAnnotationDescriptor
implements AnnotationDescriptor {
    private final NullableLazyValue<FqName> fqName;
    private final NotNullLazyValue<SimpleType> type;
    private final JavaSourceElement source;
    private final ConstantValueFactory factory;
    private final NotNullLazyValue<Map<ValueParameterDescriptor, ConstantValue<?>>> allValueArguments;
    private final LazyJavaResolverContext c;
    @NotNull
    private final JavaAnnotation javaAnnotation;

    @Override
    @NotNull
    public KotlinType getType() {
        KotlinType kotlinType = (KotlinType)this.type.invoke();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type()");
        return kotlinType;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ConstantValue<?>> getAllValueArguments() {
        return (Map)this.allValueArguments.invoke();
    }

    @Override
    @NotNull
    public JavaSourceElement getSource() {
        return this.source;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ValueParameterDescriptor, ConstantValue<?>> computeValueArguments() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection<ConstructorDescriptor> constructors2 = this.getAnnotationClass().getConstructors();
        if (constructors2.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable $receiver$iv = this.javaAnnotation.getArguments();
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        Iterable iterable = $receiver$iv;
        Map map2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            JavaAnnotationArgument javaAnnotationArgument = (JavaAnnotationArgument)element$iv$iv;
            void var9_9 = destination$iv$iv;
            Name name = it.getName();
            var9_9.put(name, element$iv$iv);
        }
        void nameToArg = destination$iv$iv;
        return CollectionsKt.keysToMapExceptNulls((Iterable)((ConstructorDescriptor)kotlin.collections.CollectionsKt.first((Iterable)constructors2)).getValueParameters(), new Function1<ValueParameterDescriptor, ConstantValue<?>>(this, (Map)nameToArg){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;
            final /* synthetic */ Map $nameToArg;

            @Nullable
            public final ConstantValue<?> invoke(ValueParameterDescriptor valueParameter) {
                JavaAnnotationArgument javaAnnotationArgument = (JavaAnnotationArgument)this.$nameToArg.get(valueParameter.getName());
                if (javaAnnotationArgument == null && Intrinsics.areEqual(valueParameter.getName(), JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME)) {
                    javaAnnotationArgument = (JavaAnnotationArgument)this.$nameToArg.get(null);
                }
                return LazyJavaAnnotationDescriptor.access$resolveAnnotationArgument(this.this$0, javaAnnotationArgument);
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                this.$nameToArg = map2;
                super(1);
            }
        });
    }

    private final ClassDescriptor getAnnotationClass() {
        ClassifierDescriptor classifierDescriptor = this.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    private final ConstantValue<?> resolveAnnotationArgument(JavaAnnotationArgument argument) {
        ConstantValue<?> constantValue;
        JavaAnnotationArgument javaAnnotationArgument = argument;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            constantValue = this.factory.createConstantValue(((JavaLiteralAnnotationArgument)argument).getValue());
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            constantValue = this.resolveFromEnumValue(((JavaEnumValueAnnotationArgument)argument).resolve());
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            Name name = argument.getName();
            if (name == null) {
                Name name2 = JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME;
                name = name2;
                Intrinsics.checkExpressionValueIsNotNull(name2, "DEFAULT_ANNOTATION_MEMBER_NAME");
            }
            constantValue = this.resolveFromArray(name, ((JavaArrayAnnotationArgument)argument).getElements());
        } else {
            constantValue = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? this.resolveFromAnnotation(((JavaAnnotationAsAnnotationArgument)argument).getAnnotation()) : (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument ? this.resolveFromJavaClassObjectType(((JavaClassObjectAnnotationArgument)argument).getReferencedType()) : (ConstantValue<?>)null);
        }
        return constantValue;
    }

    private final ConstantValue<?> resolveFromAnnotation(JavaAnnotation javaAnnotation) {
        return this.factory.createAnnotationValue(new LazyJavaAnnotationDescriptor(this.c, javaAnnotation));
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> resolveFromArray(Name argumentName, List<? extends JavaAnnotationArgument> elements) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        if (this.getType().isError()) {
            return null;
        }
        ValueParameterDescriptor valueParameterDescriptor = DescriptorResolverUtils.getAnnotationParameterByName(argumentName, this.getAnnotationClass());
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor valueParameter = valueParameterDescriptor;
        Iterable iterable = elements;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void argument;
            JavaAnnotationArgument javaAnnotationArgument = (JavaAnnotationArgument)item$iv$iv;
            void var10_10 = destination$iv$iv;
            ConstantValue constantValue = this.resolveAnnotationArgument((JavaAnnotationArgument)argument);
            if (constantValue == null) {
                constantValue = this.factory.createNullValue();
            }
            ConstantValue constantValue2 = constantValue;
            var10_10.add(constantValue2);
        }
        List values = (List)destination$iv$iv;
        KotlinType kotlinType = valueParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "valueParameter.type");
        return this.factory.createArrayValue(values, kotlinType);
    }

    private final ConstantValue<?> resolveFromEnumValue(JavaField element) {
        if (element == null || !element.isEnumEntry()) {
            return null;
        }
        JavaClass containingJavaClass = element.getContainingClass();
        ClassDescriptor classDescriptor = this.c.getComponents().getModuleClassResolver().resolveClass(containingJavaClass);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor enumClass = classDescriptor;
        ClassifierDescriptor classifier = enumClass.getUnsubstitutedInnerClassesScope().getContributedClassifier(element.getName(), NoLookupLocation.FROM_JAVA_LOADER);
        if (!(classifier instanceof ClassDescriptor)) {
            return null;
        }
        return this.factory.createEnumValue((ClassDescriptor)classifier);
    }

    private final ConstantValue<?> resolveFromJavaClassObjectType(JavaType javaType) {
        KotlinType type2 = TypeUtils.makeNotNullable(this.c.getTypeResolver().transformJavaType(javaType, JavaTypeResolverKt.toAttributes$default(TypeUsage.MEMBER_SIGNATURE_INVARIANT, false, false, null, 6, null)));
        ClassDescriptor classDescriptor = DescriptorUtilsKt.resolveTopLevelClass(this.c.getModule(), new FqName("java.lang.Class"), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor jlClass = classDescriptor;
        List<TypeProjectionImpl> arguments = kotlin.collections.CollectionsKt.listOf(new TypeProjectionImpl(type2));
        SimpleType javaClassObjectType = KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), jlClass, arguments);
        return this.factory.createKClassValue(javaClassObjectType);
    }

    @NotNull
    public String toString() {
        return DescriptorRenderer.renderAnnotation$default(DescriptorRenderer.FQ_NAMES_IN_TYPES, this, null, 2, null);
    }

    private final ClassDescriptor createTypeForMissingDependencies(FqName fqName2) {
        ModuleDescriptor moduleDescriptor = this.c.getModule();
        ClassId classId = ClassId.topLevel(fqName2);
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(fqName)");
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(moduleDescriptor, classId, this.c.getComponents().getDeserializedDescriptorResolver().getComponents().getNotFoundClasses());
    }

    @NotNull
    public final JavaAnnotation getJavaAnnotation() {
        return this.javaAnnotation;
    }

    public LazyJavaAnnotationDescriptor(@NotNull LazyJavaResolverContext c, @NotNull JavaAnnotation javaAnnotation) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(javaAnnotation, "javaAnnotation");
        this.c = c;
        this.javaAnnotation = javaAnnotation;
        this.fqName = this.c.getStorageManager().createNullableLazyValue((Function0)new Function0<FqName>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @Nullable
            public final FqName invoke() {
                ClassId classId = this.this$0.getJavaAnnotation().getClassId();
                return classId != null ? classId.asSingleFqName() : null;
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
        this.type = this.c.getStorageManager().createLazyValue((Function0)new Function0<SimpleType>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @NotNull
            public final SimpleType invoke() {
                ClassDescriptor classDescriptor;
                FqName fqName2 = (FqName)LazyJavaAnnotationDescriptor.access$getFqName$p(this.this$0).invoke();
                if (fqName2 == null) {
                    return ErrorUtils.createErrorType("No fqName: " + this.this$0.getJavaAnnotation());
                }
                FqName fqName3 = fqName2;
                ClassDescriptor classDescriptor2 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName3, LazyJavaAnnotationDescriptor.access$getC$p(this.this$0).getModule().getBuiltIns());
                if (classDescriptor2 == null) {
                    JavaClass javaClass = this.this$0.getJavaAnnotation().resolve();
                    if (javaClass != null) {
                        JavaClass javaClass2 = javaClass;
                        JavaClass javaClass3 = javaClass2;
                        classDescriptor2 = LazyJavaAnnotationDescriptor.access$getC$p(this.this$0).getComponents().getModuleClassResolver().resolveClass(javaClass3);
                    } else {
                        classDescriptor2 = classDescriptor = null;
                    }
                }
                if (classDescriptor2 == null) {
                    FqName fqName4 = fqName3;
                    Intrinsics.checkExpressionValueIsNotNull(fqName4, "fqName");
                    classDescriptor = LazyJavaAnnotationDescriptor.access$createTypeForMissingDependencies(this.this$0, fqName4);
                }
                ClassDescriptor annotationClass = classDescriptor;
                return annotationClass.getDefaultType();
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
        this.source = this.c.getComponents().getSourceElementFactory().source(this.javaAnnotation);
        this.factory = new ConstantValueFactory(this.c.getModule().getBuiltIns());
        this.allValueArguments = this.c.getStorageManager().createLazyValue(new Function0<Map<ValueParameterDescriptor, ? extends ConstantValue<?>>>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @NotNull
            public final Map<ValueParameterDescriptor, ConstantValue<?>> invoke() {
                return LazyJavaAnnotationDescriptor.access$computeValueArguments(this.this$0);
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ConstantValue access$resolveAnnotationArgument(LazyJavaAnnotationDescriptor $this, @Nullable JavaAnnotationArgument argument) {
        return $this.resolveAnnotationArgument(argument);
    }

    @NotNull
    public static final /* synthetic */ NullableLazyValue access$getFqName$p(LazyJavaAnnotationDescriptor $this) {
        return $this.fqName;
    }

    @NotNull
    public static final /* synthetic */ LazyJavaResolverContext access$getC$p(LazyJavaAnnotationDescriptor $this) {
        return $this.c;
    }

    @NotNull
    public static final /* synthetic */ ClassDescriptor access$createTypeForMissingDependencies(LazyJavaAnnotationDescriptor $this, @NotNull FqName fqName2) {
        return $this.createTypeForMissingDependencies(fqName2);
    }

    @NotNull
    public static final /* synthetic */ Map access$computeValueArguments(LazyJavaAnnotationDescriptor $this) {
        return $this.computeValueArguments();
    }
}

