/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.AnalyzerExtensions;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u001b\u001a\u00020\r*\u00020\u0015H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension;", "Lorg/jetbrains/kotlin/resolve/AnalyzerExtensions$AnalyzerExtension;", "()V", "checkDefaults", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkHasInlinableAndNullability", "checkInlinableParameter", "", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkModalityAndOverrides", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "functionOrProperty", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "notSupportedInInlineCheck", "descriptor", "process", "isEffectivelyFinal", "kotlin-compiler"})
public final class InlineAnalyzerExtension
implements AnalyzerExtensions.AnalyzerExtension {
    public static final InlineAnalyzerExtension INSTANCE;

    @Override
    public void process(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtCallableDeclaration functionOrProperty, @NotNull BindingTrace trace) {
        block10: {
            block11: {
                block9: {
                    Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                    Intrinsics.checkParameterIsNotNull(functionOrProperty, "functionOrProperty");
                    Intrinsics.checkParameterIsNotNull(trace, "trace");
                    this.checkModalityAndOverrides(descriptor2, functionOrProperty, trace);
                    this.notSupportedInInlineCheck(descriptor2, functionOrProperty, trace);
                    if (!(descriptor2 instanceof FunctionDescriptor)) break block9;
                    boolean bl = functionOrProperty instanceof KtNamedFunction;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Function descriptor " + descriptor2 + " should have corresponded KtNamedFunction, but has " + functionOrProperty;
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    KtCallableDeclaration ktCallableDeclaration = functionOrProperty;
                    if (ktCallableDeclaration == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
                    }
                    this.checkDefaults((FunctionDescriptor)descriptor2, (KtNamedFunction)ktCallableDeclaration, trace);
                    this.checkHasInlinableAndNullability((FunctionDescriptor)descriptor2, (KtFunction)functionOrProperty, trace);
                    break block10;
                }
                boolean bl = descriptor2 instanceof PropertyDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    String string = "PropertyDescriptor expected, but was " + descriptor2;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = functionOrProperty instanceof KtProperty;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Property descriptor " + descriptor2 + " should have corresponded KtProperty, but has " + functionOrProperty;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                CallableMemberDescriptor callableMemberDescriptor = descriptor2;
                if (callableMemberDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                }
                boolean hasBackingField = Intrinsics.areEqual((Boolean)trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)callableMemberDescriptor), true);
                if (hasBackingField) break block11;
                KtCallableDeclaration ktCallableDeclaration = functionOrProperty;
                if (ktCallableDeclaration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                if (((KtProperty)ktCallableDeclaration).getDelegateExpression() == null) break block10;
            }
            trace.report(Errors.INLINE_PROPERTY_WITH_BACKING_FIELD.on((KtDeclaration)((PsiElement)functionOrProperty)));
        }
    }

    private final void notSupportedInInlineCheck(CallableMemberDescriptor descriptor2, KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        KtVisitorVoid visitor2 = new KtVisitorVoid(trace, descriptor2){
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ CallableMemberDescriptor $descriptor;

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                super.visitKtElement(element);
                element.acceptChildren(this);
            }

            public void visitClass(@NotNull KtClass klass) {
                Intrinsics.checkParameterIsNotNull(klass, "klass");
                this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)klass), klass, this.$descriptor));
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull(function2, "function");
                if (function2.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function2);
                } else {
                    this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)function2), function2, this.$descriptor));
                }
            }
            {
                this.$trace = $captured_local_variable$0;
                this.$descriptor = $captured_local_variable$1;
            }
        };
        functionOrProperty.acceptChildren(visitor2);
    }

    private final void checkDefaults(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        List<KtParameter> ktParameters = function2.getValueParameters();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            if (!DescriptorUtilsKt.hasDefaultValue(parameter)) continue;
            KtParameter ktParameter = ktParameters.get(parameter.getIndex());
            ParameterDescriptor parameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(parameterDescriptor, "parameter");
            KtElement ktElement = ktParameter;
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "ktParameter");
            if (!this.checkInlinableParameter(parameterDescriptor, ktElement, functionDescriptor, null) && parameter.declaresDefaultValue()) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)ktParameter), ktParameter, functionDescriptor));
        }
    }

    private final void checkModalityAndOverrides(CallableMemberDescriptor callableDescriptor, KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        boolean overridesAnything;
        if (callableDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        if (Visibilities.isPrivate(callableDescriptor.getVisibility())) {
            return;
        }
        Collection<? extends CallableMemberDescriptor> collection = callableDescriptor.getOverriddenDescriptors();
        boolean bl = overridesAnything = !collection.isEmpty();
        if (overridesAnything) {
            List<KtTypeParameter> ktTypeParameters = functionOrProperty.getTypeParameters();
            for (TypeParameterDescriptor typeParameter : callableDescriptor.getTypeParameters()) {
                if (!typeParameter.isReified()) continue;
                KtTypeParameter ktTypeParameter = ktTypeParameters.get(typeParameter.getIndex());
                PsiElement psiElement = ktTypeParameter.getModifierList();
                if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.REIFIED_KEYWORD)) == null) {
                    psiElement = ktTypeParameter;
                }
                PsiElement reportOn = psiElement;
                trace.report(Errors.REIFIED_TYPE_PARAMETER_IN_OVERRIDE.on(reportOn));
            }
        }
        if (this.isEffectivelyFinal(callableDescriptor)) {
            if (overridesAnything) {
                trace.report(Errors.OVERRIDE_BY_INLINE.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on((KtDeclaration)((PsiElement)functionOrProperty)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEffectivelyFinal(@NotNull CallableMemberDescriptor $receiver) {
        if (Intrinsics.areEqual((Object)$receiver.getModality(), (Object)Modality.FINAL)) return true;
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!(containingDeclaration instanceof ClassDescriptor)) return false;
        if (!Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getModality(), (Object)Modality.FINAL)) return false;
        return true;
    }

    private final void checkHasInlinableAndNullability(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        boolean hasInlinable = false;
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        int index2 = 0;
        for (ValueParameterDescriptor parameter : parameters2) {
            ParameterDescriptor parameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(parameterDescriptor, "parameter");
            KtElement ktElement = function2.getValueParameters().get(index2++);
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "function.valueParameters[index++]");
            hasInlinable |= this.checkInlinableParameter(parameterDescriptor, ktElement, functionDescriptor, trace);
        }
        if (!(hasInlinable |= InlineUtil.containsReifiedTypeParameters(functionDescriptor)) && !AnnotationUtilKt.isInlineOnlyOrReified(functionDescriptor)) {
            KtModifierList modifierList;
            KtModifierList ktModifierList = modifierList = function2.getModifierList();
            PsiElement inlineModifier = ktModifierList != null ? ktModifierList.getModifier(KtTokens.INLINE_KEYWORD) : null;
            PsiElement psiElement = inlineModifier;
            if (psiElement == null) {
                psiElement = function2;
            }
            PsiElement reportOn = psiElement;
            trace.report(Errors.NOTHING_TO_INLINE.on(reportOn, functionDescriptor));
        }
    }

    public final boolean checkInlinableParameter(@NotNull ParameterDescriptor parameter, @NotNull KtElement expression, @NotNull CallableDescriptor functionDescriptor, @Nullable BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        if (InlineUtil.isInlineLambdaParameter(parameter)) {
            if (parameter.getType().isMarkedNullable()) {
                BindingTrace bindingTrace = trace;
                if (bindingTrace != null) {
                    bindingTrace.report(Errors.NULLABLE_INLINE_PARAMETER.on((KtElement)((PsiElement)expression), expression, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private InlineAnalyzerExtension() {
        INSTANCE = this;
    }

    static {
        new InlineAnalyzerExtension();
    }
}

