/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.commons;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;

public class LocalVariablesSorter
extends MethodVisitor {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] mapping = new int[40];
    private Object[] newLocals = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;
    private boolean changed;

    protected LocalVariablesSorter(int api, int access, String desc, MethodVisitor mv) {
        super(api, mv);
        Type[] args = Type.getArgumentTypes(desc);
        this.nextLocal = (8 & access) == 0 ? 1 : 0;
        for (int i = 0; i < args.length; ++i) {
            this.nextLocal += args[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        Type type2;
        switch (opcode) {
            case 22: 
            case 55: {
                type2 = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type2 = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type2 = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type2 = Type.INT_TYPE;
                break;
            }
            default: {
                type2 = OBJECT_TYPE;
            }
        }
        this.mv.visitVarInsn(opcode, this.remap(var, type2));
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, Type.INT_TYPE), increment);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, this.nextLocal);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature2, Label start, Label end, int index2) {
        int newIndex = this.remap(index2, Type.getType(desc));
        this.mv.visitLocalVariable(name, desc, signature2, start, end, newIndex);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index2, String desc, boolean visible) {
        Type t = Type.getType(desc);
        int[] newIndex = new int[index2.length];
        for (int i = 0; i < newIndex.length; ++i) {
            newIndex[i] = this.remap(index2[i], t);
        }
        return this.mv.visitLocalVariableAnnotation(typeRef, typePath, start, end, newIndex, desc, visible);
    }

    @Override
    public void visitFrame(int type2, int nLocal, Object[] local, int nStack, Object[] stack) {
        int number;
        if (type2 != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (!this.changed) {
            this.mv.visitFrame(type2, nLocal, local, nStack, stack);
            return;
        }
        Object[] oldLocals = new Object[this.newLocals.length];
        System.arraycopy(this.newLocals, 0, oldLocals, 0, oldLocals.length);
        this.updateNewLocals(this.newLocals);
        int index2 = 0;
        for (number = 0; number < nLocal; ++number) {
            int size;
            Object t = local[number];
            int n = size = t == Opcodes.LONG || t == Opcodes.DOUBLE ? 2 : 1;
            if (t != Opcodes.TOP) {
                Type typ = OBJECT_TYPE;
                if (t == Opcodes.INTEGER) {
                    typ = Type.INT_TYPE;
                } else if (t == Opcodes.FLOAT) {
                    typ = Type.FLOAT_TYPE;
                } else if (t == Opcodes.LONG) {
                    typ = Type.LONG_TYPE;
                } else if (t == Opcodes.DOUBLE) {
                    typ = Type.DOUBLE_TYPE;
                } else if (t instanceof String) {
                    typ = Type.getObjectType((String)t);
                }
                this.setFrameLocal(this.remap(index2, typ), t);
            }
            index2 += size;
        }
        index2 = 0;
        number = 0;
        int i = 0;
        while (index2 < this.newLocals.length) {
            Object t;
            if ((t = this.newLocals[index2++]) != null && t != Opcodes.TOP) {
                this.newLocals[i] = t;
                number = i + 1;
                if (t == Opcodes.LONG || t == Opcodes.DOUBLE) {
                    ++index2;
                }
            } else {
                this.newLocals[i] = Opcodes.TOP;
            }
            ++i;
        }
        this.mv.visitFrame(type2, number, this.newLocals, nStack, stack);
        this.newLocals = oldLocals;
    }

    protected void updateNewLocals(Object[] newLocals) {
    }

    protected void setLocalType(int local, Type type2) {
    }

    private void setFrameLocal(int local, Object type2) {
        int l = this.newLocals.length;
        if (local >= l) {
            Object[] a = new Object[Math.max(2 * l, local + 1)];
            System.arraycopy(this.newLocals, 0, a, 0, l);
            this.newLocals = a;
        }
        this.newLocals[local] = type2;
    }

    private int remap(int var, Type type2) {
        int value;
        int size;
        if (var + type2.getSize() <= this.firstLocal) {
            return var;
        }
        int key = 2 * var + type2.getSize() - 1;
        if (key >= (size = this.mapping.length)) {
            int[] newMapping = new int[Math.max(2 * size, key + 1)];
            System.arraycopy(this.mapping, 0, newMapping, 0, size);
            this.mapping = newMapping;
        }
        if ((value = this.mapping[key]) == 0) {
            value = this.newLocalMapping(type2);
            this.setLocalType(value, type2);
            this.mapping[key] = value + 1;
        } else {
            --value;
        }
        if (value != var) {
            this.changed = true;
        }
        return value;
    }

    protected int newLocalMapping(Type type2) {
        int local = this.nextLocal;
        this.nextLocal += type2.getSize();
        return local;
    }
}

