/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.PluginRequest;

public class DefaultPluginRequest
implements PluginRequest {
    private final PluginId id;
    private final String version;
    private final boolean apply;
    private final int lineNumber;
    private final String scriptDisplayName;

    public DefaultPluginRequest(String id, String version, boolean apply, int lineNumber, ScriptSource scriptSource) {
        this(PluginId.of(id), version, apply, lineNumber, scriptSource);
    }

    public DefaultPluginRequest(PluginId id, String version, boolean apply, int lineNumber, ScriptSource scriptSource) {
        this(id, version, apply, lineNumber, scriptSource.getDisplayName());
    }

    public DefaultPluginRequest(String id, String version, boolean apply, int lineNumber, String scriptDisplayName) {
        this(PluginId.of(id), version, apply, lineNumber, scriptDisplayName);
    }

    public DefaultPluginRequest(PluginId id, String version, boolean apply, int lineNumber, String scriptDisplayName) {
        this.id = id;
        this.version = version;
        this.apply = apply;
        this.lineNumber = lineNumber;
        this.scriptDisplayName = scriptDisplayName;
    }

    public PluginId getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isApply() {
        return this.apply;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getScriptDisplayName() {
        return this.scriptDisplayName;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[id: '").append(this.id).append("'");
        if (this.version != null) {
            b.append(", version: '").append(this.version).append("'");
        }
        if (!this.apply) {
            b.append(", apply: false");
        }
        b.append("]");
        return b.toString();
    }

    public String getDisplayName() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPluginRequest that = (DefaultPluginRequest)o;
        if (this.apply != that.apply) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.apply ? 1 : 0);
        return result;
    }
}

