/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.source;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.config.LoggingSourceSystem;
import org.gradle.internal.logging.config.LoggingSystem;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class JavaUtilLoggingSystem
implements LoggingSourceSystem {
    private final Logger logger = Logger.getLogger("");
    private boolean installed;

    public LoggingSystem.Snapshot on(LogLevel minimumLevel, LogLevel defaultLevel) {
        SnapshotImpl snapshot = new SnapshotImpl(this.installed, this.logger.getLevel());
        this.install();
        return snapshot;
    }

    public void restore(LoggingSystem.Snapshot state) {
        SnapshotImpl snapshot = (SnapshotImpl)state;
        if (snapshot.installed) {
            this.install();
        } else {
            this.uninstall(snapshot.level);
        }
    }

    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.installed, this.logger.getLevel());
    }

    private void uninstall(Level level) {
        if (!this.installed) {
            return;
        }
        LogManager.getLogManager().reset();
        this.logger.setLevel(level);
        this.installed = false;
    }

    private void install() {
        if (this.installed) {
            return;
        }
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
        this.logger.setLevel(Level.FINE);
        this.installed = true;
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final boolean installed;
        private final Level level;

        public SnapshotImpl(boolean installed, Level level) {
            this.installed = installed;
            this.level = level;
        }
    }
}

