/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.composite.CompositeBuildIdeProjectResolver;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;
import org.gradle.plugins.ide.idea.model.internal.IdeaScopeMappingRule;
import org.gradle.plugins.ide.idea.model.internal.ModuleDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeDependencyKey;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.UnresolvedIdeRepoFileDependency;
import org.gradle.util.CollectionUtils;

public class IdeaDependenciesProvider {
    private final IdeDependenciesExtractor dependenciesExtractor;
    private final ModuleDependencyBuilder moduleDependencyBuilder;
    private Transformer<FilePath, File> getPath;
    private Map<GeneratedIdeaScope, List<IdeaScopeMappingRule>> scopeMappings = new EnumMap<GeneratedIdeaScope, List<IdeaScopeMappingRule>>(GeneratedIdeaScope.class);

    public IdeaDependenciesProvider(ServiceRegistry serviceRegistry) {
        this(new IdeDependenciesExtractor(), serviceRegistry);
    }

    IdeaDependenciesProvider(IdeDependenciesExtractor dependenciesExtractor, ServiceRegistry serviceRegistry) {
        this.dependenciesExtractor = dependenciesExtractor;
        this.scopeMappings.put(GeneratedIdeaScope.PROVIDED_TEST, Collections.singletonList(new IdeaScopeMappingRule("providedRuntime", "test")));
        this.scopeMappings.put(GeneratedIdeaScope.PROVIDED, Lists.newArrayList((Object[])new IdeaScopeMappingRule[]{new IdeaScopeMappingRule("providedCompile"), new IdeaScopeMappingRule("providedRuntime")}));
        this.scopeMappings.put(GeneratedIdeaScope.COMPILE, Collections.singletonList(new IdeaScopeMappingRule("compile")));
        this.scopeMappings.put(GeneratedIdeaScope.RUNTIME_COMPILE_CLASSPATH, Collections.singletonList(new IdeaScopeMappingRule("compileClasspath", "runtime")));
        this.scopeMappings.put(GeneratedIdeaScope.RUNTIME_TEST_COMPILE_CLASSPATH, Collections.singletonList(new IdeaScopeMappingRule("compileClasspath", "testRuntime")));
        this.scopeMappings.put(GeneratedIdeaScope.RUNTIME_TEST, Collections.singletonList(new IdeaScopeMappingRule("testCompile", "runtime")));
        this.scopeMappings.put(GeneratedIdeaScope.RUNTIME, Collections.singletonList(new IdeaScopeMappingRule("runtime")));
        this.scopeMappings.put(GeneratedIdeaScope.TEST, Lists.newArrayList((Object[])new IdeaScopeMappingRule[]{new IdeaScopeMappingRule("testCompileClasspath"), new IdeaScopeMappingRule("testCompile"), new IdeaScopeMappingRule("testRuntime")}));
        this.scopeMappings.put(GeneratedIdeaScope.COMPILE_CLASSPATH, Collections.singletonList(new IdeaScopeMappingRule("compileClasspath")));
        this.moduleDependencyBuilder = new ModuleDependencyBuilder(new CompositeBuildIdeProjectResolver(serviceRegistry));
    }

    public Set<Dependency> provide(final IdeaModule ideaModule) {
        this.getPath = new Transformer<FilePath, File>(){

            @Nullable
            public FilePath transform(File file) {
                return file != null ? ideaModule.getPathFactory().path(file) : null;
            }
        };
        LinkedHashSet<Dependency> result = new LinkedHashSet<Dependency>();
        if (ideaModule.getSingleEntryLibraries() != null) {
            for (Map.Entry<String, Iterable<File>> singleEntryLibrary : ideaModule.getSingleEntryLibraries().entrySet()) {
                String scope = singleEntryLibrary.getKey();
                for (File file : singleEntryLibrary.getValue()) {
                    if (file == null || !file.isDirectory()) continue;
                    result.add(new SingleEntryModuleLibrary((FilePath)this.getPath.transform((Object)file), scope));
                }
            }
        }
        result.addAll(this.provideFromScopeRuleMappings(ideaModule));
        return result;
    }

    public Collection<UnresolvedIdeRepoFileDependency> getUnresolvedDependencies(IdeaModule ideaModule) {
        TreeSet usedUnresolvedDependencies = Sets.newTreeSet((Comparator)new Comparator<UnresolvedIdeRepoFileDependency>(){

            @Override
            public int compare(UnresolvedIdeRepoFileDependency left, UnresolvedIdeRepoFileDependency right) {
                return left.getDisplayName().compareTo(right.getDisplayName());
            }
        });
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            Map<String, Collection<Object>> plusMinusConfigurations = ideaModule.getScopes().get(scope.name());
            if (plusMinusConfigurations == null) {
                if (!this.shouldProcessScope(scope, ideaModule.getScopes())) continue;
                plusMinusConfigurations = Collections.emptyMap();
            }
            ArrayList plusConfigurations = plusMinusConfigurations.containsKey("plus") ? Lists.newArrayList((Iterable)plusMinusConfigurations.get("plus")) : Lists.newArrayList();
            ArrayList minusConfigurations = plusMinusConfigurations.containsKey("minus") ? Lists.newArrayList((Iterable)plusMinusConfigurations.get("minus")) : Lists.newArrayList();
            for (IdeaScopeMappingRule scopeMappingRule : this.scopeMappings.get((Object)scope)) {
                for (Configuration configuration : ideaModule.getProject().getConfigurations()) {
                    if (!scopeMappingRule.configurationNames.contains(configuration.getName())) continue;
                    plusConfigurations.add(configuration);
                }
            }
            usedUnresolvedDependencies.addAll(this.dependenciesExtractor.unresolvedExternalDependencies(plusConfigurations, minusConfigurations));
        }
        return usedUnresolvedDependencies;
    }

    private Set<Dependency> provideFromScopeRuleMappings(IdeaModule ideaModule) {
        LinkedHashMultimap dependencyToConfigurations = LinkedHashMultimap.create();
        for (Configuration configuration : this.ideaConfigurations(ideaModule)) {
            IdeDependencyKey<IdeDependency, Dependency> key;
            Collection<IdeProjectDependency> ideProjectDependencies = this.dependenciesExtractor.extractProjectDependencies(ideaModule.getProject(), Collections.singletonList(configuration), Collections.emptyList());
            for (IdeProjectDependency ideProjectDependency : ideProjectDependencies) {
                IdeDependencyKey<IdeProjectDependency, Dependency> key2 = IdeDependencyKey.forProjectDependency(ideProjectDependency, new IdeDependencyKey.DependencyBuilder<IdeProjectDependency, Dependency>(){

                    @Override
                    public Dependency buildDependency(IdeProjectDependency dependency, String scope) {
                        return IdeaDependenciesProvider.this.moduleDependencyBuilder.create(dependency, scope);
                    }
                });
                dependencyToConfigurations.put(key2, (Object)configuration.getName());
            }
            if (!ideaModule.isOffline()) {
                Collection<IdeExtendedRepoFileDependency> ideRepoFileDependencies = this.dependenciesExtractor.extractRepoFileDependencies(ideaModule.getProject().getDependencies(), Collections.singletonList(configuration), Collections.emptyList(), ideaModule.isDownloadSources(), ideaModule.isDownloadJavadoc());
                for (IdeExtendedRepoFileDependency ideRepoFileDependency : ideRepoFileDependencies) {
                    key = IdeDependencyKey.forRepoFileDependency(ideRepoFileDependency, new IdeDependencyKey.DependencyBuilder<IdeExtendedRepoFileDependency, Dependency>(){

                        @Override
                        public Dependency buildDependency(IdeExtendedRepoFileDependency dependency, String scope) {
                            Set javadoc = (Set)CollectionUtils.collect(dependency.getJavadocFiles(), new LinkedHashSet(), (Transformer)IdeaDependenciesProvider.this.getPath);
                            Set source = (Set)CollectionUtils.collect(dependency.getSourceFiles(), new LinkedHashSet(), (Transformer)IdeaDependenciesProvider.this.getPath);
                            SingleEntryModuleLibrary library = new SingleEntryModuleLibrary((FilePath)IdeaDependenciesProvider.this.getPath.transform((Object)dependency.getFile()), javadoc, source, scope);
                            library.setModuleVersion(dependency.getId());
                            return library;
                        }
                    });
                    dependencyToConfigurations.put(key, (Object)configuration.getName());
                }
            }
            Collection<IdeLocalFileDependency> ideLocalFileDependencies = this.dependenciesExtractor.extractLocalFileDependencies(Collections.singletonList(configuration), Collections.emptyList());
            for (IdeLocalFileDependency fileDependency : ideLocalFileDependencies) {
                key = IdeDependencyKey.forLocalFileDependency(fileDependency, new IdeDependencyKey.DependencyBuilder<IdeLocalFileDependency, Dependency>(){

                    @Override
                    public Dependency buildDependency(IdeLocalFileDependency dependency, String scope) {
                        return new SingleEntryModuleLibrary((FilePath)IdeaDependenciesProvider.this.getPath.transform((Object)dependency.getFile()), scope);
                    }
                });
                dependencyToConfigurations.put(key, (Object)configuration.getName());
            }
        }
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            List<IdeDependencyKey<?, Dependency>> matchingDependencies;
            Collection<Configuration> minusConfigurations;
            Map<String, Collection<Object>> plusMinusConfigurations = ideaModule.getScopes().get(scope.name());
            if (plusMinusConfigurations == null) {
                if (!this.shouldProcessScope(scope, ideaModule.getScopes())) continue;
                plusMinusConfigurations = Collections.emptyMap();
            }
            ArrayList minusConfigurationNames = (minusConfigurations = plusMinusConfigurations.get("minus")) != null ? Lists.newArrayList((Iterable)Iterables.transform(minusConfigurations, (Function)new Function<Configuration, String>(){

                public String apply(Configuration configuration) {
                    return configuration.getName();
                }
            })) : Collections.emptyList();
            for (IdeaScopeMappingRule ideaScopeMappingRule : this.scopeMappings.get((Object)scope)) {
                matchingDependencies = this.extractDependencies((Multimap<IdeDependencyKey<?, Dependency>, String>)dependencyToConfigurations, (Collection<String>)ideaScopeMappingRule.configurationNames, minusConfigurationNames);
                for (IdeDependencyKey ideDependencyKey : matchingDependencies) {
                    dependencies.addAll(Lists.newArrayList((Iterable)Iterables.transform(scope.scopes, IdeaDependenciesProvider.scopeToDependency(ideDependencyKey))));
                }
            }
            if (!plusMinusConfigurations.containsKey("plus")) continue;
            for (Configuration configuration : plusMinusConfigurations.get("plus")) {
                matchingDependencies = this.extractDependencies((Multimap<IdeDependencyKey<?, Dependency>, String>)dependencyToConfigurations, (Collection<String>)Collections.singletonList(configuration.getName()), minusConfigurationNames);
                for (IdeDependencyKey ideDependencyKey : matchingDependencies) {
                    dependencies.addAll(Lists.newArrayList((Iterable)Iterables.transform(scope.scopes, IdeaDependenciesProvider.scopeToDependency(ideDependencyKey))));
                }
            }
        }
        return dependencies;
    }

    private boolean shouldProcessScope(GeneratedIdeaScope scope, Map<String, Map<String, Collection<Configuration>>> scopes) {
        for (String scopeName : scope.scopes) {
            if (scopes.containsKey(scopeName)) continue;
            return false;
        }
        return true;
    }

    private static Function<String, Dependency> scopeToDependency(final IdeDependencyKey<?, Dependency> dependencyKey) {
        return new Function<String, Dependency>(){

            @Nullable
            public Dependency apply(String s) {
                return (Dependency)dependencyKey.buildDependency(s);
            }
        };
    }

    private Iterable<Configuration> ideaConfigurations(final IdeaModule ideaModule) {
        LinkedHashSet configurations = Sets.newLinkedHashSet((Iterable)ideaModule.getProject().getConfigurations());
        for (Map<String, Collection<Configuration>> scopeMap : ideaModule.getScopes().values()) {
            for (Configuration cfg : Iterables.concat(scopeMap.values())) {
                configurations.add(cfg);
            }
        }
        return Iterables.filter((Iterable)configurations, (Predicate)new Predicate<Configuration>(){

            public boolean apply(Configuration input) {
                return IdeaDependenciesProvider.this.isMappedToIdeaScope(input, ideaModule);
            }
        });
    }

    private boolean isMappedToIdeaScope(final Configuration configuration, IdeaModule ideaModule) {
        Iterable rules = Iterables.concat(this.scopeMappings.values());
        boolean matchesRule = Iterables.any((Iterable)rules, (Predicate)new Predicate<IdeaScopeMappingRule>(){

            public boolean apply(IdeaScopeMappingRule ideaScopeMappingRule) {
                return ideaScopeMappingRule.configurationNames.contains(configuration.getName());
            }
        });
        if (matchesRule) {
            return true;
        }
        for (Map<String, Collection<Configuration>> scopeMap : ideaModule.getScopes().values()) {
            Iterable configurations = Iterables.concat(scopeMap.values());
            if (!Iterables.any((Iterable)configurations, (Predicate)Predicates.equalTo((Object)configuration))) continue;
            return true;
        }
        return false;
    }

    private List<IdeDependencyKey<?, Dependency>> extractDependencies(Multimap<IdeDependencyKey<?, Dependency>, String> dependenciesToConfigs, Collection<String> configurations, Collection<String> minusConfigurations) {
        ArrayList deps = new ArrayList();
        ArrayList<IdeDependencyKey> minusDeps = new ArrayList<IdeDependencyKey>();
        for (IdeDependencyKey dependencyKey : dependenciesToConfigs.keySet()) {
            if (!dependenciesToConfigs.get((Object)dependencyKey).containsAll(configurations)) continue;
            boolean isInMinus = false;
            for (String minusConfiguration : minusConfigurations) {
                if (!dependenciesToConfigs.get((Object)dependencyKey).contains(minusConfiguration)) continue;
                isInMinus = true;
                break;
            }
            if (!isInMinus) {
                deps.add(dependencyKey);
                continue;
            }
            minusDeps.add(dependencyKey);
        }
        for (IdeDependencyKey key : Iterables.concat(deps, minusDeps)) {
            dependenciesToConfigs.removeAll((Object)key);
        }
        return deps;
    }
}

