/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultExclude
implements Exclude {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName artifact;
    private final Set<String> configurations;
    private final String patternMatcher;

    public DefaultExclude(String group, String module, String artifact, String type, String extension, String[] configurations, String patternMatcher) {
        this.moduleId = DefaultModuleIdentifier.newId(group, module);
        this.artifact = new DefaultIvyArtifactName(artifact, type, extension);
        this.configurations = ImmutableSet.copyOf((Object[])configurations);
        this.patternMatcher = patternMatcher;
    }

    public DefaultExclude(String group, String module, String[] configurations, String patternMatcher) {
        this.moduleId = DefaultModuleIdentifier.newId(group, module);
        this.artifact = new DefaultIvyArtifactName("*", "*", "*");
        this.configurations = ImmutableSet.copyOf((Object[])configurations);
        this.patternMatcher = patternMatcher;
    }

    public DefaultExclude(String group, String module) {
        this.moduleId = DefaultModuleIdentifier.newId(group, module);
        this.artifact = new DefaultIvyArtifactName("*", "*", "*");
        this.configurations = ImmutableSet.of();
        this.patternMatcher = "exact";
    }

    public String toString() {
        return "{exclude moduleId: " + this.moduleId + ", artifact: " + this.artifact + "}";
    }

    @Override
    public ModuleIdentifier getModuleId() {
        return this.moduleId;
    }

    @Override
    public IvyArtifactName getArtifact() {
        return this.artifact;
    }

    @Override
    public Set<String> getConfigurations() {
        return this.configurations;
    }

    @Override
    public String getMatcher() {
        return this.patternMatcher;
    }
}

