/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.BinaryDocument;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.export._VrmlExporter;
import org.jmol.java.BS;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class _StlExporter
extends _VrmlExporter {
    private boolean isDebug;
    private String header;
    private OC oc;
    private ByteArrayOutputStream bos;
    private M4 m4;
    Lst<M4> lstMatrix;
    private T3 trans = new P3();
    private M4 m4a = new M4();
    private int nTri;

    public _StlExporter() {
        this.useTable = null;
        this.isBinary = true;
        this.solidOnly = true;
        this.isDebug = Logger.debugging;
        if (!this.isDebug) {
            this.oc = new OC();
            this.oc.setBigEndian(false);
            this.bos = new ByteArrayOutputStream();
            this.oc.setParams(null, null, false, this.bos);
        }
    }

    @Override
    protected void outputHeader() {
        this.header = ("solid model generated by Jmol " + Viewer.getJmolVersion() + "                                                                                ").substring(0, 80);
        if (this.isDebug) {
            this.out.append(this.header);
            this.out.append("\n");
        } else {
            this.oc.write(this.header.getBytes(), 0, 80);
            this.oc.write(new byte[4], 0, 4);
        }
        this.lstMatrix = new Lst();
        this.m4 = new M4();
        this.m4.setIdentity();
        this.lstMatrix.addLast(this.m4);
        this.outputInitialTransform();
    }

    private void writePoint(String s, T3 p) {
        if (this.isDebug) {
            this.out.append(s);
        }
        this.writeFloat(p.x);
        this.writeFloat(p.y);
        this.writeFloat(p.z);
        if (this.isDebug) {
            this.out.append("\n");
        }
    }

    private void writeFloat(float f) {
        if (this.isDebug) {
            this.out.append(" " + f);
        } else {
            this.oc.writeInt(Float.floatToIntBits(f));
        }
    }

    @Override
    protected void output(String data) {
    }

    @Override
    protected void pushMatrix() {
        this.lstMatrix.addLast(this.m4);
        this.m4 = M4.newM4(this.m4);
    }

    @Override
    protected void popMatrix() {
        this.m4 = this.lstMatrix.removeItemAt(this.lstMatrix.size() - 1);
    }

    @Override
    protected void outputTranslation(T3 pt) {
        this.m4a.setIdentity();
        this.m4a.setTranslation(pt);
        this.m4.mul(this.m4a);
    }

    @Override
    protected void outputRotation(A4 a) {
        this.m4a.setToAA(a);
        this.m4.mul(this.m4a);
    }

    @Override
    protected void outputScale(float x, float y, float z) {
        this.m4a.setIdentity();
        this.m4a.m00 = x;
        this.m4a.m11 = y;
        this.m4a.m22 = z;
        this.m4.mul(this.m4a);
    }

    @Override
    protected void outputGeometry(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, BS bsPolygons, int faceVertexMax, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        for (int i = 0; i < nPolygons; ++i) {
            if (bsPolygons != null && !bsPolygons.get(i)) continue;
            int[] face = indices[i];
            this.writeFacet(vertices, face, 0, 1, 2);
            if (faceVertexMax != 4 || face.length < 4 || face[2] == face[3]) continue;
            this.writeFacet(vertices, face, 2, 3, 0);
        }
    }

    private void writeFacet(T3[] vertices, int[] face, int i, int j, int k) {
        this.tempQ1.setT(vertices[face[i]]);
        this.tempQ2.setT(vertices[face[j]]);
        this.tempQ3.setT(vertices[face[k]]);
        this.m4.rotTrans(this.tempQ1);
        this.m4.rotTrans(this.tempQ2);
        this.m4.rotTrans(this.tempQ3);
        Measure.calcNormalizedNormal(this.tempQ1, this.tempQ2, this.tempQ3, this.tempV1, this.tempV2);
        if (Float.isNaN(this.tempV1.x)) {
            return;
        }
        this.writePoint("facet normal", this.tempV1);
        this.writePoint("outer loop\nvertex", this.tempQ1);
        this.writePoint("vertex", this.tempQ2);
        this.writePoint("vertex", this.tempQ3);
        if (this.isDebug) {
            this.out.append("endloop\nendfacet\n");
        } else {
            this.oc.writeByteAsInt(0);
            this.oc.writeByteAsInt(0);
        }
        ++this.nTri;
    }

    @Override
    protected String finalizeOutput() {
        if (this.isDebug) {
            this.out.append("endsolid model\n");
        } else {
            byte[] b = this.bos.toByteArray();
            b[80] = (byte)(this.nTri & 0xFF);
            b[81] = (byte)(this.nTri >> 8 & 0xFF);
            b[82] = (byte)(this.nTri >> 16 & 0xFF);
            b[83] = (byte)(this.nTri >> 24 & 0xFF);
            this.out.write(b, 0, b.length);
        }
        return this.finalizeOutput2();
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
    }

    private void checkFile(String fname) {
        BinaryDocument doc = new BinaryDocument();
        doc.setStream((BufferedInputStream)this.vwr.fm.getBufferedReaderOrErrorMessageFromName(fname, null, true, false), false);
        try {
            int j;
            for (j = 0; j < 20; ++j) {
                doc.readInt();
            }
            System.out.println(doc.readInt());
            for (j = 0; j < 10; ++j) {
                for (int k = 0; k < 12; ++k) {
                    float f = doc.readFloat();
                    System.out.println(j + " " + f + "\t" + Integer.toHexString(Float.floatToIntBits(f)));
                    if (k % 3 != 2) continue;
                    System.out.println("");
                }
                System.out.println(j + " " + doc.readShort() + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        doc.close();
    }
}

