/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.ParallelWays;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ParallelWayAction
extends MapMode
implements ModifierListener,
MapViewPaintable {
    private static final CachingProperty<BasicStroke> HELPER_LINE_STROKE = new StrokeProperty(ParallelWayAction.prefKey("stroke.hepler-line"), "1").cached();
    private static final CachingProperty<BasicStroke> REF_LINE_STROKE = new StrokeProperty(ParallelWayAction.prefKey("stroke.ref-line"), "2 2 3").cached();
    private static final CachingProperty<Double> SNAP_THRESHOLD = new DoubleProperty(ParallelWayAction.prefKey("snap-threshold-percent"), 0.7).cached();
    private static final CachingProperty<Boolean> SNAP_DEFAULT = new BooleanProperty(ParallelWayAction.prefKey("snap-default"), true).cached();
    private static final CachingProperty<Boolean> COPY_TAGS_DEFAULT = new BooleanProperty(ParallelWayAction.prefKey("copy-tags-default"), true).cached();
    private static final CachingProperty<Integer> INITIAL_MOVE_DELAY = new IntegerProperty(ParallelWayAction.prefKey("initial-move-delay"), 200).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_METRIC = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-metric"), 0.5).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_IMPERIAL = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-imperial"), 1.0).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_CHINESE = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-chinese"), 1.0).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_NAUTICAL = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-nautical"), 0.1).cached();
    private static final CachingProperty<Color> MAIN_COLOR = new ColorProperty(I18n.marktr("make parallel helper line"), (Color)null).cached();
    private static final CachingProperty<Map<Modifier, Boolean>> SNAP_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("snap-modifier-combo"), "?sC").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> COPY_TAGS_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("copy-tags-modifier-combo"), "As?").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> ADD_TO_SELECTION_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("add-to-selection-modifier-combo"), "aSc").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> TOGGLE_SELECTED_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("toggle-selection-modifier-combo"), "asC").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> SET_SELECTED_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("set-selection-modifier-combo"), "asc").cached();
    private Mode mode;
    private boolean copyTags;
    private boolean snap;
    private final MapView mv;
    private Point mousePressedPos;
    private boolean mouseIsDown;
    private long mousePressedTime;
    private boolean mouseHasBeenDragged;
    private transient WaySegment referenceSegment;
    private transient ParallelWays pWays;
    private transient Set<Way> sourceWays;
    private EastNorth helperLineStart;
    private EastNorth helperLineEnd;

    public ParallelWayAction(MapFrame mapFrame) {
        super(I18n.tr("Parallel", new Object[0]), "parallel", I18n.tr("Make parallel copies of ways", new Object[0]), Shortcut.registerShortcut("mapmode:parallel", I18n.tr("Mode: {0}", I18n.tr("Parallel", new Object[0])), 80, 5005), mapFrame, ImageProvider.getCursor("normal", "parallel"));
        this.putValue("help", HelpUtil.ht("/Action/Parallel"));
        this.mv = mapFrame.mapView;
    }

    @Override
    public void enterMode() {
        this.setMode(Mode.NORMAL);
        this.pWays = null;
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.addTemporaryLayer(this);
        Main.map.keyDetector.addModifierListener(this);
        this.sourceWays = new LinkedHashSet<Way>(this.getLayerManager().getEditDataSet().getSelectedWays());
        for (Way way : this.sourceWays) {
            way.setHighlighted(true);
        }
        this.mv.repaint();
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.removeTemporaryLayer(this);
        Main.map.statusLine.setDist(-1.0);
        Main.map.statusLine.repaint();
        Main.map.keyDetector.removeModifierListener(this);
        ParallelWayAction.removeWayHighlighting(this.sourceWays);
        this.pWays = null;
        this.sourceWays = null;
        this.referenceSegment = null;
        this.mv.repaint();
    }

    @Override
    public String getModeHelpText() {
        switch (this.mode) {
            case NORMAL: {
                return I18n.tr("Select ways as in Select mode. Drag selected ways or a single way to create a parallel copy (Alt toggles tag preservation)", new Object[0]);
            }
            case DRAGGING: {
                return I18n.tr("Hold Ctrl to toggle snapping", new Object[0]);
            }
        }
        return "";
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void modifiersChanged(int n) {
        if (Main.map == null || this.mv == null || !this.mv.isActiveLayerDrawable()) {
            return;
        }
        if (this.updateModifiersState(n)) {
            this.updateStatusLine();
            this.updateCursor();
        }
    }

    private boolean updateModifiersState(int n) {
        boolean bl = this.alt;
        boolean bl2 = this.shift;
        boolean bl3 = this.ctrl;
        this.updateKeyModifiers(n);
        return bl != this.alt || bl2 != this.shift || bl3 != this.ctrl;
    }

    private void updateCursor() {
        Cursor cursor = null;
        switch (this.mode) {
            case NORMAL: {
                if (this.matchesCurrentModifiers(SET_SELECTED_MODIFIER_COMBO)) {
                    cursor = ImageProvider.getCursor("normal", "parallel");
                    break;
                }
                if (this.matchesCurrentModifiers(ADD_TO_SELECTION_MODIFIER_COMBO)) {
                    cursor = ImageProvider.getCursor("normal", "parallel_add");
                    break;
                }
                if (!this.matchesCurrentModifiers(TOGGLE_SELECTED_MODIFIER_COMBO)) break;
                cursor = ImageProvider.getCursor("normal", "parallel_remove");
                break;
            }
            case DRAGGING: {
                cursor = Cursor.getPredefinedCursor(13);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (cursor != null) {
            this.mv.setNewCursor(cursor, (Object)this);
        }
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        this.updateCursor();
        this.updateStatusLine();
    }

    private boolean sanityCheck() {
        boolean bl;
        boolean bl2 = bl = this.mv.isActiveLayerVisible() && this.mv.isActiveLayerDrawable() && (Boolean)this.getValue("active") != false;
        assert (bl);
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInMapView();
        this.updateModifiersState(mouseEvent.getModifiers());
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!this.sanityCheck()) {
            return;
        }
        this.updateFlagsOnlyChangeableOnPress();
        this.updateFlagsChangeableAlways();
        if (this.pWays != null && this.pWays.getWays() != null) {
            this.getLayerManager().getEditDataSet().clearSelection(this.pWays.getWays());
            this.pWays = null;
        }
        this.mouseIsDown = true;
        this.mousePressedPos = mouseEvent.getPoint();
        this.mousePressedTime = System.currentTimeMillis();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateModifiersState(mouseEvent.getModifiers());
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!this.mouseHasBeenDragged) {
            Way way = this.mv.getNearestWay(mouseEvent.getPoint(), OsmPrimitive::isSelectable);
            if (way == null) {
                if (this.matchesCurrentModifiers(SET_SELECTED_MODIFIER_COMBO)) {
                    this.clearSourceWays();
                }
                this.resetMouseTrackingState();
                return;
            }
            boolean bl = way.isSelected();
            if (this.matchesCurrentModifiers(ADD_TO_SELECTION_MODIFIER_COMBO)) {
                if (!bl) {
                    this.addSourceWay(way);
                }
            } else if (this.matchesCurrentModifiers(TOGGLE_SELECTED_MODIFIER_COMBO)) {
                if (bl) {
                    this.removeSourceWay(way);
                } else {
                    this.addSourceWay(way);
                }
            } else if (this.matchesCurrentModifiers(SET_SELECTED_MODIFIER_COMBO)) {
                this.clearSourceWays();
                this.addSourceWay(way);
            }
        } else if (this.mode == Mode.DRAGGING) {
            this.clearSourceWays();
        }
        this.setMode(Mode.NORMAL);
        this.resetMouseTrackingState();
        this.mv.repaint();
    }

    private static void removeWayHighlighting(Collection<Way> collection) {
        if (collection == null) {
            return;
        }
        for (Way way : collection) {
            way.setHighlighted(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        double d;
        if (!this.mouseIsDown) {
            return;
        }
        boolean bl = this.updateModifiersState(mouseEvent.getModifiers());
        this.updateFlagsChangeableAlways();
        if (bl) {
            this.updateStatusLine();
            this.updateCursor();
        }
        if (System.currentTimeMillis() - this.mousePressedTime < (long)INITIAL_MOVE_DELAY.get().intValue()) {
            return;
        }
        this.mouseHasBeenDragged = true;
        if (this.mode == Mode.NORMAL) {
            if (!this.isModifiersValidForDragMode()) {
                return;
            }
            if (!this.initParallelWays(this.mousePressedPos, this.copyTags)) {
                return;
            }
            this.setMode(Mode.DRAGGING);
        }
        Point point = mouseEvent.getPoint();
        EastNorth eastNorth = this.mv.getEastNorth((int)point.getX(), (int)point.getY());
        EastNorth eastNorth2 = Geometry.closestPointToLine(this.referenceSegment.getFirstNode().getEastNorth(), this.referenceSegment.getSecondNode().getEastNorth(), eastNorth);
        double d2 = eastNorth.distance(eastNorth2);
        double d3 = d = this.mv.getProjection().eastNorth2latlon(eastNorth).greatCircleDistance(this.mv.getProjection().eastNorth2latlon(eastNorth2));
        boolean bl2 = Geometry.angleIsClockwise(this.referenceSegment.getFirstNode(), this.referenceSegment.getSecondNode(), new Node(eastNorth));
        if (this.snap) {
            SystemOfMeasurement systemOfMeasurement = SystemOfMeasurement.getSystemOfMeasurement();
            double d4 = systemOfMeasurement.equals(SystemOfMeasurement.CHINESE) ? SNAP_DISTANCE_CHINESE.get() * SystemOfMeasurement.CHINESE.aValue : (systemOfMeasurement.equals(SystemOfMeasurement.IMPERIAL) ? SNAP_DISTANCE_IMPERIAL.get() * SystemOfMeasurement.IMPERIAL.aValue : (systemOfMeasurement.equals(SystemOfMeasurement.NAUTICAL_MILE) ? SNAP_DISTANCE_NAUTICAL.get() * SystemOfMeasurement.NAUTICAL_MILE.aValue : SNAP_DISTANCE_METRIC.get()));
            double d5 = d % d4;
            double d6 = d5 < d4 / 2.0 ? d - d5 : d + (d4 - d5);
            d3 = Math.abs(d6 - d) < SNAP_THRESHOLD.get() * d4 ? d6 : d6 + Math.signum(d - d6) * d4;
        }
        d2 = d3 * (d2 / d);
        this.helperLineStart = eastNorth2;
        this.helperLineEnd = eastNorth;
        if (bl2) {
            d2 = -d2;
        }
        this.pWays.changeOffset(d2);
        Main.map.statusLine.setDist(Math.abs(d3));
        Main.map.statusLine.repaint();
        this.mv.repaint();
    }

    private boolean matchesCurrentModifiers(CachingProperty<Map<Modifier, Boolean>> cachingProperty) {
        return this.matchesCurrentModifiers(cachingProperty.get());
    }

    private boolean matchesCurrentModifiers(Map<Modifier, Boolean> map) {
        EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
        if (this.ctrl) {
            enumSet.add(Modifier.CTRL);
        }
        if (this.alt) {
            enumSet.add(Modifier.ALT);
        }
        if (this.shift) {
            enumSet.add(Modifier.SHIFT);
        }
        return map.entrySet().stream().allMatch(entry -> enumSet.contains(entry.getKey()) == ((Boolean)entry.getValue()).booleanValue());
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.mode == Mode.DRAGGING) {
            CheckParameterUtil.ensureParameterNotNull(mapView, "mv");
            Color color = MAIN_COLOR.get();
            if (color == null) {
                color = PaintColors.SELECTED.get();
            }
            graphics2D.setStroke(REF_LINE_STROKE.get());
            graphics2D.setColor(color);
            MapViewPath mapViewPath = new MapViewPath(mapView);
            mapViewPath.moveTo(this.referenceSegment.getFirstNode());
            mapViewPath.lineTo(this.referenceSegment.getSecondNode());
            graphics2D.draw(mapViewPath);
            graphics2D.setStroke(HELPER_LINE_STROKE.get());
            graphics2D.setColor(color);
            mapViewPath = new MapViewPath(mapView);
            mapViewPath.moveTo(this.helperLineStart);
            mapViewPath.lineTo(this.helperLineEnd);
            graphics2D.draw(mapViewPath);
        }
    }

    private boolean isModifiersValidForDragMode() {
        return !this.alt && !this.shift && !this.ctrl || this.matchesCurrentModifiers(SNAP_MODIFIER_COMBO) || this.matchesCurrentModifiers(COPY_TAGS_MODIFIER_COMBO);
    }

    private void updateFlagsOnlyChangeableOnPress() {
        this.copyTags = COPY_TAGS_DEFAULT.get().booleanValue() != this.matchesCurrentModifiers(COPY_TAGS_MODIFIER_COMBO);
    }

    private void updateFlagsChangeableAlways() {
        this.snap = SNAP_DEFAULT.get().booleanValue() != this.matchesCurrentModifiers(SNAP_MODIFIER_COMBO);
    }

    private void addSourceWay(Way way) {
        assert (this.sourceWays != null);
        this.getLayerManager().getEditDataSet().addSelected(way);
        way.setHighlighted(true);
        this.sourceWays.add(way);
    }

    private void removeSourceWay(Way way) {
        assert (this.sourceWays != null);
        this.getLayerManager().getEditDataSet().clearSelection(way);
        way.setHighlighted(false);
        this.sourceWays.remove(way);
    }

    private void clearSourceWays() {
        assert (this.sourceWays != null);
        this.getLayerManager().getEditDataSet().clearSelection(this.sourceWays);
        for (Way way : this.sourceWays) {
            way.setHighlighted(false);
        }
        this.sourceWays.clear();
    }

    private void resetMouseTrackingState() {
        this.mouseIsDown = false;
        this.mousePressedPos = null;
        this.mouseHasBeenDragged = false;
    }

    private boolean initParallelWays(Point point, boolean bl) {
        this.referenceSegment = this.mv.getNearestWaySegment(point, AbstractPrimitive::isUsable, true);
        if (this.referenceSegment == null) {
            return false;
        }
        if (!this.sourceWays.contains(this.referenceSegment.way)) {
            this.clearSourceWays();
            this.addSourceWay(this.referenceSegment.way);
        }
        try {
            int n = -1;
            int n2 = 0;
            for (Way way : this.sourceWays) {
                if (way == this.referenceSegment.way) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.pWays = new ParallelWays(this.sourceWays, bl, n);
            this.pWays.commit();
            this.getLayerManager().getEditDataSet().setSelected(this.pWays.getWays());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.debug(illegalArgumentException);
            new Notification(I18n.tr("ParallelWayAction\nThe ways selected must form a simple branchless path", new Object[0])).setIcon(1).show();
            this.resetMouseTrackingState();
            this.pWays = null;
            return false;
        }
    }

    private static String prefKey(String string) {
        return "edit.make-parallel-way-action." + string;
    }

    private static enum Modifier {
        CTRL('c'),
        ALT('a'),
        SHIFT('s');

        private final char shortChar;

        private Modifier(char c) {
            this.shortChar = Character.toLowerCase(c);
        }

        public static Optional<Modifier> findWithShortCode(int n) {
            return Stream.of(Modifier.values()).filter(modifier -> modifier.shortChar == Character.toLowerCase(n)).findAny();
        }
    }

    private static class KeyboardModifiersProperty
    extends AbstractToStringProperty<Map<Modifier, Boolean>> {
        KeyboardModifiersProperty(String string, String string2) {
            super(string, KeyboardModifiersProperty.createFromString(string2));
        }

        KeyboardModifiersProperty(String string, Map<Modifier, Boolean> map) {
            super(string, map);
        }

        @Override
        protected String toString(Map<Modifier, Boolean> map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Modifier modifier : Modifier.values()) {
                Boolean bl = map.get((Object)modifier);
                if (bl == null) {
                    stringBuilder.append('?');
                    continue;
                }
                if (bl.booleanValue()) {
                    stringBuilder.append(Character.toUpperCase(modifier.shortChar));
                    continue;
                }
                stringBuilder.append(modifier.shortChar);
            }
            return stringBuilder.toString();
        }

        @Override
        protected Map<Modifier, Boolean> fromString(String string) {
            return KeyboardModifiersProperty.createFromString(string);
        }

        private static Map<Modifier, Boolean> createFromString(String string) {
            EnumMap<Modifier, Boolean> enumMap = new EnumMap<Modifier, Boolean>(Modifier.class);
            for (char c : string.toCharArray()) {
                if (c == '?') continue;
                Optional<Modifier> optional = Modifier.findWithShortCode(c);
                if (optional.isPresent()) {
                    enumMap.put(optional.get(), Character.isUpperCase(c));
                    continue;
                }
                Main.debug("Ignoring unknown modifier {0}", Character.valueOf(c));
            }
            return Collections.unmodifiableMap(enumMap);
        }
    }

    private static enum Mode {
        DRAGGING,
        NORMAL;

    }
}

