/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class MapViewState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int OUTSIDE_TOP = 1;
    public static final int OUTSIDE_BOTTOM = 2;
    public static final int OUTSIDE_LEFT = 4;
    public static final int OUTSIDE_RIGHT = 8;
    private final transient Projecting projecting;
    private final int viewWidth;
    private final int viewHeight;
    private final double scale;
    private final EastNorth topLeft;
    private final Point topLeftOnScreen;
    private final Point topLeftInWindow;

    private MapViewState(Projecting projecting, int n, int n2, double d, EastNorth eastNorth) {
        this.projecting = projecting;
        this.scale = d;
        this.topLeft = eastNorth;
        this.viewWidth = n;
        this.viewHeight = n2;
        this.topLeftInWindow = new Point(0, 0);
        this.topLeftOnScreen = new Point(0, 0);
    }

    private MapViewState(EastNorth eastNorth, MapViewState mapViewState) {
        this.projecting = mapViewState.projecting;
        this.scale = mapViewState.scale;
        this.topLeft = eastNorth;
        this.viewWidth = mapViewState.viewWidth;
        this.viewHeight = mapViewState.viewHeight;
        this.topLeftInWindow = mapViewState.topLeftInWindow;
        this.topLeftOnScreen = mapViewState.topLeftOnScreen;
    }

    private MapViewState(double d, MapViewState mapViewState) {
        this.projecting = mapViewState.projecting;
        this.scale = d;
        this.topLeft = mapViewState.topLeft;
        this.viewWidth = mapViewState.viewWidth;
        this.viewHeight = mapViewState.viewHeight;
        this.topLeftInWindow = mapViewState.topLeftInWindow;
        this.topLeftOnScreen = mapViewState.topLeftOnScreen;
    }

    private MapViewState(JComponent jComponent, MapViewState mapViewState) {
        this.projecting = mapViewState.projecting;
        this.scale = mapViewState.scale;
        this.topLeft = mapViewState.topLeft;
        this.viewWidth = jComponent.getWidth();
        this.viewHeight = jComponent.getHeight();
        this.topLeftInWindow = new Point();
        for (Container container = jComponent; container != null; container = container.getParent()) {
            this.topLeftInWindow.x += ((Component)container).getX();
            this.topLeftInWindow.y += ((Component)container).getY();
        }
        try {
            this.topLeftOnScreen = jComponent.getLocationOnScreen();
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("position", jComponent).put("parent", jComponent::getParent);
        }
    }

    private MapViewState(Projecting projecting, MapViewState mapViewState) {
        this.projecting = projecting;
        this.scale = mapViewState.scale;
        this.topLeft = mapViewState.topLeft;
        this.viewWidth = mapViewState.viewWidth;
        this.viewHeight = mapViewState.viewHeight;
        this.topLeftInWindow = mapViewState.topLeftInWindow;
        this.topLeftOnScreen = mapViewState.topLeftOnScreen;
    }

    public double getScale() {
        return this.scale;
    }

    public MapViewPoint getForView(double d, double d2) {
        return new MapViewViewPoint(d, d2);
    }

    public MapViewPoint getPointFor(EastNorth eastNorth) {
        return new MapViewEastNorthPoint(eastNorth);
    }

    public MapViewPoint getPointFor(LatLon latLon) {
        return this.getPointFor(this.getProjection().latlon2eastNorth(latLon));
    }

    public MapViewPoint getPointFor(Node node) {
        return this.getPointFor(node.getEastNorth(this.getProjection()));
    }

    public MapViewRectangle getViewArea() {
        return this.getForView(0.0, 0.0).rectTo(this.getForView(this.viewWidth, this.viewHeight));
    }

    public MapViewRectangle getViewArea(Rectangle2D rectangle2D) {
        return this.getForView(rectangle2D.getMinX(), rectangle2D.getMinY()).rectTo(this.getForView(rectangle2D.getMaxX(), rectangle2D.getMaxY()));
    }

    public MapViewPoint getCenter() {
        return this.getForView((double)this.viewWidth / 2.0, (double)this.viewHeight / 2.0);
    }

    public MapViewPoint getCenterAtPixel() {
        return this.getForView(this.viewWidth / 2, this.viewHeight / 2);
    }

    public double getViewWidth() {
        return this.viewWidth;
    }

    public double getViewHeight() {
        return this.viewHeight;
    }

    public Projection getProjection() {
        return this.projecting.getBaseProjection();
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(1.0 / this.scale, 0.0, 0.0, -1.0 / this.scale, -this.topLeft.east() / this.scale, this.topLeft.north() / this.scale);
    }

    public Area getArea(Bounds bounds) {
        Path2D.Double double_ = new Path2D.Double();
        bounds.visitEdge(this.getProjection(), latLon -> {
            MapViewPoint mapViewPoint = this.getPointFor((LatLon)latLon);
            if (double_.getCurrentPoint() == null) {
                double_.moveTo(mapViewPoint.getInViewX(), mapViewPoint.getInViewY());
            } else {
                double_.lineTo(mapViewPoint.getInViewX(), mapViewPoint.getInViewY());
            }
        });
        double_.closePath();
        return new Area(double_);
    }

    public MapViewState usingCenter(EastNorth eastNorth) {
        return this.movedTo(this.getCenter(), eastNorth);
    }

    public MapViewState movedTo(MapViewPoint mapViewPoint, EastNorth eastNorth) {
        EastNorth eastNorth2 = eastNorth.subtract(mapViewPoint.getEastNorth());
        if (eastNorth2.distanceSq(0.0, 0.0) < 1.0E-21) {
            return this;
        }
        return new MapViewState(this.topLeft.add(eastNorth2), this);
    }

    public MapViewState usingScale(double d) {
        return new MapViewState(d, this);
    }

    public MapViewState usingLocation(JComponent jComponent) {
        EastNorth eastNorth = this.getCenter().getEastNorth();
        return new MapViewState(jComponent, this).usingCenter(eastNorth);
    }

    public MapViewState usingProjection(Projection projection) {
        if (projection.equals(this.projecting)) {
            return this;
        }
        return new MapViewState(projection, this);
    }

    public static MapViewState createDefaultState(int n, int n2) {
        Projection projection = Main.getProjection();
        double d = projection.getDefaultZoomInPPD();
        MapViewState mapViewState = new MapViewState(projection, n, n2, d, new EastNorth(0.0, 0.0));
        EastNorth eastNorth = MapViewState.calculateDefaultCenter();
        return mapViewState.movedTo(mapViewState.getCenter(), eastNorth);
    }

    private static EastNorth calculateDefaultCenter() {
        Bounds bounds = DownloadDialog.getSavedDownloadBounds();
        if (bounds == null) {
            bounds = Main.getProjection().getWorldBoundsLatLon();
        }
        return Main.getProjection().latlon2eastNorth(bounds.getCenter());
    }

    public class MapViewRectangle {
        private final MapViewPoint p1;
        private final MapViewPoint p2;

        MapViewRectangle(MapViewPoint mapViewPoint, MapViewPoint mapViewPoint2) {
            this.p1 = mapViewPoint;
            this.p2 = mapViewPoint2;
        }

        public ProjectionBounds getProjectionBounds() {
            ProjectionBounds projectionBounds = new ProjectionBounds(this.p1.getEastNorth());
            projectionBounds.extend(this.p2.getEastNorth());
            return projectionBounds;
        }

        public Bounds getCornerBounds() {
            Bounds bounds = new Bounds(this.p1.getLatLon());
            bounds.extend(this.p2.getLatLon());
            return bounds;
        }

        public Bounds getLatLonBoundsBox() {
            return MapViewState.this.projecting.getBaseProjection().getLatLonBoundsBox(this.getProjectionBounds());
        }

        public Rectangle2D getInView() {
            double d = this.p1.getInViewX();
            double d2 = this.p1.getInViewY();
            double d3 = this.p2.getInViewX();
            double d4 = this.p2.getInViewY();
            return new Rectangle2D.Double(Math.min(d, d3), Math.min(d2, d4), Math.abs(d - d3), Math.abs(d2 - d4));
        }

        public boolean isInView() {
            return this.getInView().intersects(MapViewState.this.getViewArea().getInView());
        }
    }

    private class MapViewEastNorthPoint
    extends MapViewPoint {
        private final EastNorth eastNorth;

        MapViewEastNorthPoint(EastNorth eastNorth) {
            this.eastNorth = eastNorth;
        }

        @Override
        public double getInViewX() {
            return (this.eastNorth.east() - MapViewState.this.topLeft.east()) / MapViewState.this.scale;
        }

        @Override
        public double getInViewY() {
            return (MapViewState.this.topLeft.north() - this.eastNorth.north()) / MapViewState.this.scale;
        }

        @Override
        public EastNorth getEastNorth() {
            return this.eastNorth;
        }

        public String toString() {
            return "MapViewEastNorthPoint [eastNorth=" + this.eastNorth + ']';
        }
    }

    private class MapViewViewPoint
    extends MapViewPoint {
        private final double x;
        private final double y;

        MapViewViewPoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        @Override
        public double getInViewX() {
            return this.x;
        }

        @Override
        public double getInViewY() {
            return this.y;
        }

        public String toString() {
            return "MapViewViewPoint [x=" + this.x + ", y=" + this.y + ']';
        }
    }

    public abstract class MapViewPoint {
        public Point2D getInView() {
            return new Point2D.Double(this.getInViewX(), this.getInViewY());
        }

        public abstract double getInViewX();

        public abstract double getInViewY();

        public Point2D getInWindow() {
            return this.getUsingCorner(MapViewState.this.topLeftInWindow);
        }

        public Point2D getOnScreen() {
            return this.getUsingCorner(MapViewState.this.topLeftOnScreen);
        }

        private Point2D.Double getUsingCorner(Point point) {
            return new Point2D.Double(point.getX() + this.getInViewX(), point.getY() + this.getInViewY());
        }

        public EastNorth getEastNorth() {
            return new EastNorth(MapViewState.this.topLeft.east() + this.getInViewX() * MapViewState.this.scale, MapViewState.this.topLeft.north() - this.getInViewY() * MapViewState.this.scale);
        }

        public MapViewRectangle rectTo(MapViewPoint mapViewPoint) {
            return new MapViewRectangle(this, mapViewPoint);
        }

        public LatLon getLatLon() {
            return MapViewState.this.projecting.getBaseProjection().eastNorth2latlon(this.getEastNorth());
        }

        public LatLon getLatLonClamped() {
            return MapViewState.this.projecting.eastNorth2latlonClamped(this.getEastNorth());
        }

        public MapViewPoint add(EastNorth eastNorth) {
            return new MapViewEastNorthPoint(this.getEastNorth().add(eastNorth));
        }

        public boolean isInView() {
            return this.inRange(this.getInViewX(), 0, MapViewState.this.getViewWidth()) && this.inRange(this.getInViewY(), 0, MapViewState.this.getViewHeight());
        }

        private boolean inRange(double d, int n, double d2) {
            return d >= (double)n && d < d2;
        }

        public int getOutsideRectangleFlags(MapViewRectangle mapViewRectangle) {
            Rectangle2D rectangle2D = mapViewRectangle.getInView();
            int n = 0;
            if (this.getInViewX() < rectangle2D.getMinX()) {
                n |= 4;
            } else if (this.getInViewX() > rectangle2D.getMaxX()) {
                n |= 8;
            }
            if (this.getInViewY() < rectangle2D.getMinY()) {
                n |= 1;
            } else if (this.getInViewY() > rectangle2D.getMaxY()) {
                n |= 2;
            }
            return n;
        }

        public double oneNormInView(MapViewPoint mapViewPoint) {
            return Math.abs(this.getInViewX() - mapViewPoint.getInViewX()) + Math.abs(this.getInViewY() - mapViewPoint.getInViewY());
        }

        public double distanceToInViewSq(MapViewPoint mapViewPoint) {
            double d = this.getInViewX() - mapViewPoint.getInViewX();
            double d2 = this.getInViewY() - mapViewPoint.getInViewY();
            return d * d + d2 * d2;
        }

        public double distanceToInView(MapViewPoint mapViewPoint) {
            return Math.sqrt(this.distanceToInViewSq(mapViewPoint));
        }

        public MapViewPoint interpolate(MapViewPoint mapViewPoint, int n) {
            return new MapViewViewPoint((double)(1 - n) * this.getInViewX() + (double)n * mapViewPoint.getInViewX(), (double)(1 - n) * this.getInViewY() + (double)n * mapViewPoint.getInViewY());
        }
    }
}

