/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;

public class CancelHandler {
    private boolean isCanceled;
    private final List<ProgressMonitor.CancelListener> listeners = new ArrayList<ProgressMonitor.CancelListener>();

    public synchronized void cancel() {
        if (!this.isCanceled) {
            this.isCanceled = true;
            for (ProgressMonitor.CancelListener cancelListener : this.listeners) {
                cancelListener.operationCanceled();
            }
        }
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void addCancelListener(ProgressMonitor.CancelListener cancelListener) {
        this.listeners.add(cancelListener);
    }

    public synchronized void removeCancelListener(ProgressMonitor.CancelListener cancelListener) {
        this.listeners.remove(cancelListener);
    }
}

