/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class ComboMultiSelect
extends KeyedItem {
    private static final Renderer RENDERER = new Renderer();
    public String locale_text;
    public String values;
    public String values_from;
    public String values_context;
    public boolean values_no_i18n;
    public boolean values_sort = true;
    public String display_values;
    public String locale_display_values;
    public String short_descriptions;
    public String locale_short_descriptions;
    public String default_;
    public String delimiter = ";";
    public String use_last_as_default = "false";
    public String values_searchable = "false";
    protected JComponent component;
    protected final Map<String, PresetListEntry> lhm = new LinkedHashMap<String, PresetListEntry>();
    private boolean initialized;
    protected KeyedItem.Usage usage;
    protected Object originalValue;

    public static String[] splitEscaped(char c, String string) {
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                stringBuilder.append(c2);
                bl = false;
                continue;
            }
            if (c2 == '\\') {
                bl = true;
                continue;
            }
            if (c2 == c) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected abstract Object getSelectedItem();

    protected abstract void addToPanelAnchor(JPanel var1, String var2, boolean var3);

    protected char getDelChar() {
        return this.delimiter.isEmpty() ? (char)';' : this.delimiter.charAt(0);
    }

    @Override
    public Collection<String> getValues() {
        this.initListEntries();
        return this.lhm.keySet();
    }

    public Collection<String> getDisplayValues() {
        this.initListEntries();
        return this.lhm.values().stream().map(presetListEntry -> presetListEntry.getDisplayValue(true)).collect(Collectors.toList());
    }

    @Override
    public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
        this.initListEntries();
        this.usage = ComboMultiSelect.determineTextUsage(collection, this.key);
        if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
            this.lhm.put(DIFFERENT, new PresetListEntry(DIFFERENT));
        }
        JLabel jLabel = new JLabel(I18n.tr("{0}:", this.locale_text));
        jLabel.setToolTipText(this.getKeyTooltipText());
        jPanel.add((Component)jLabel, GBC.std().insets(0, 0, 10, 0));
        this.addToPanelAnchor(jPanel, this.default_, bl);
        jLabel.setLabelFor(this.component);
        this.component.setToolTipText(this.getKeyTooltipText());
        return true;
    }

    private void initListEntries() {
        if (this.initialized) {
            this.lhm.remove(DIFFERENT);
            return;
        }
        if (this.lhm.isEmpty()) {
            this.initListEntriesFromAttributes();
        } else {
            if (this.values != null) {
                Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "values", "list_entry"));
            }
            if (this.display_values != null || this.locale_display_values != null) {
                Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "display_values", "list_entry"));
            }
            if (this.short_descriptions != null || this.locale_short_descriptions != null) {
                Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "short_descriptions", "list_entry"));
            }
            for (PresetListEntry presetListEntry : this.lhm.values()) {
                if (presetListEntry.value_context != null) continue;
                presetListEntry.value_context = this.values_context;
            }
        }
        if (this.locale_text == null) {
            this.locale_text = ComboMultiSelect.getLocaleText(this.text, this.text_context, null);
        }
        this.initialized = true;
    }

    private void initListEntriesFromAttributes() {
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        char c = this.getDelChar();
        Object[] objectArray3 = null;
        if (this.values_from != null && (objectArray2 = this.values_from.split("#")) != null && objectArray2.length == 2) {
            try {
                object = Class.forName(objectArray2[0]).getMethod(objectArray2[1], new Class[0]);
                int n = ((Method)object).getModifiers();
                if (Modifier.isPublic(n) && Modifier.isStatic(n) && ((Method)object).getReturnType().equals(String[].class) && ((Method)object).getParameterTypes().length == 0) {
                    objectArray3 = (String[])((Method)object).invoke(null, new Object[0]);
                } else {
                    Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' is not \"{2}\"", this.key, this.text, "public static String[] methodName()"));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' threw {2} ({3})", this.key, this.text, reflectiveOperationException.getClass().getName(), reflectiveOperationException.getMessage()));
                Main.debug(reflectiveOperationException);
            }
        }
        if (objectArray3 == null) {
            objectArray3 = ComboMultiSelect.splitEscaped(c, this.values);
        }
        objectArray2 = objectArray3;
        if (!this.values_no_i18n) {
            object = Utils.firstNonNull(this.locale_display_values, this.display_values);
            objectArray2 = object == null ? objectArray3 : ComboMultiSelect.splitEscaped(c, (String)object);
        }
        Object[] objectArray4 = objectArray = (object = Utils.firstNonNull(this.locale_short_descriptions, this.short_descriptions)) == null ? null : ComboMultiSelect.splitEscaped(c, (String)object);
        if (objectArray2.length != objectArray3.length) {
            Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''display_values'' must be the same as in ''values''", this.key, this.text));
            Main.error(I18n.tr("Detailed information: {0} <> {1}", Arrays.toString(objectArray2), Arrays.toString(objectArray3)));
            objectArray2 = objectArray3;
        }
        if (objectArray != null && objectArray.length != objectArray3.length) {
            Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''short_descriptions'' must be the same as in ''values''", this.key, this.text));
            Main.error(I18n.tr("Detailed information: {0} <> {1}", Arrays.toString(objectArray), Arrays.toString(objectArray3)));
            objectArray = null;
        }
        ArrayList<PresetListEntry> arrayList = new ArrayList<PresetListEntry>(objectArray3.length);
        for (int i = 0; i < objectArray3.length; ++i) {
            PresetListEntry presetListEntry = new PresetListEntry(objectArray3[i]);
            Object object2 = presetListEntry.locale_display_value = this.locale_display_values != null || this.values_no_i18n ? objectArray2[i] : I18n.trc(this.values_context, ComboMultiSelect.fixPresetString((String)objectArray2[i]));
            if (objectArray != null) {
                presetListEntry.locale_short_description = this.locale_short_descriptions != null ? objectArray[i] : I18n.tr(ComboMultiSelect.fixPresetString((String)objectArray[i]), new Object[0]);
            }
            arrayList.add(presetListEntry);
        }
        if (Main.pref.getBoolean("taggingpreset.sortvalues", true) && this.values_sort) {
            Collections.sort(arrayList);
        }
        for (PresetListEntry presetListEntry : arrayList) {
            this.lhm.put(presetListEntry.value, presetListEntry);
        }
    }

    protected String getDisplayIfNull() {
        return null;
    }

    @Override
    public void addCommands(List<Tag> list) {
        Object object = this.getSelectedItem();
        String string = object == null ? null : object.toString();
        String string2 = null;
        if (string == null) {
            string = this.getDisplayIfNull();
        }
        if (string != null) {
            for (Map.Entry<String, PresetListEntry> entry : this.lhm.entrySet()) {
                String string3 = entry.getValue().toString();
                if (string3 == null || !string3.equals(string)) continue;
                string2 = entry.getKey();
                break;
            }
            if (string2 == null) {
                string2 = string;
            }
        } else {
            string2 = "";
        }
        string2 = Tag.removeWhiteSpaces(string2);
        if (this.originalValue == null ? string2.isEmpty() : string2.equals(this.originalValue.toString())) {
            return;
        }
        if (!"false".equals(this.use_last_as_default)) {
            LAST_VALUES.put(this.key, string2);
        }
        list.add(new Tag(this.key, string2));
    }

    public void addListEntry(PresetListEntry presetListEntry) {
        this.lhm.put(presetListEntry.value, presetListEntry);
    }

    public void addListEntries(Collection<PresetListEntry> collection) {
        for (PresetListEntry presetListEntry : collection) {
            this.addListEntry(presetListEntry);
        }
    }

    protected ListCellRenderer<PresetListEntry> getListCellRenderer() {
        return RENDERER;
    }

    @Override
    public KeyedItem.MatchType getDefaultMatch() {
        return KeyedItem.MatchType.NONE;
    }

    public static class PresetListEntry
    implements Comparable<PresetListEntry> {
        public String value;
        public String value_context;
        public String display_value;
        public String short_description;
        public String icon;
        public String icon_size;
        public String locale_display_value;
        public String locale_short_description;
        private final File zipIcons = TaggingPresetReader.getZipIcons();
        public int prefferedWidth = -1;
        public int prefferedHeight = -1;

        public PresetListEntry() {
        }

        public PresetListEntry(String string) {
            this.value = string;
        }

        public String getListDisplay() {
            if (this.value.equals(KeyedItem.DIFFERENT)) {
                return "<b>" + Utils.escapeReservedCharactersHTML(KeyedItem.DIFFERENT) + "</b>";
            }
            String string = Utils.escapeReservedCharactersHTML(this.getDisplayValue(true));
            String string2 = this.getShortDescription(true);
            if (string.isEmpty() && (string2 == null || string2.isEmpty())) {
                return "&nbsp;";
            }
            StringBuilder stringBuilder = new StringBuilder("<b>").append(string).append("</b>");
            if (string2 != null) {
                stringBuilder.append("<div style=\"width:300px; padding:0 0 5px 5px\">").append(string2).append("</div>");
            }
            return stringBuilder.toString();
        }

        public ImageIcon getIcon() {
            return this.icon == null ? null : ComboMultiSelect.loadImageIcon(this.icon, this.zipIcons, ComboMultiSelect.parseInteger(this.icon_size));
        }

        public String getDisplayValue(boolean bl) {
            return bl ? Utils.firstNonNull(this.locale_display_value, I18n.tr(this.display_value, new Object[0]), I18n.trc(this.value_context, this.value)) : Utils.firstNonNull(this.display_value, this.value);
        }

        public String getShortDescription(boolean bl) {
            return bl ? Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0])) : this.short_description;
        }

        public String toString() {
            if (KeyedItem.DIFFERENT.equals(this.value)) {
                return KeyedItem.DIFFERENT;
            }
            String string = this.getDisplayValue(true);
            return string != null ? string.replaceAll("<.*>", "") : "";
        }

        @Override
        public int compareTo(PresetListEntry presetListEntry) {
            return AlphanumComparator.getInstance().compare(this.getDisplayValue(true), presetListEntry.getDisplayValue(true));
        }
    }

    protected static class ConcatenatingJList
    extends JList<PresetListEntry> {
        private final String delimiter;

        protected ConcatenatingJList(String string, PresetListEntry ... presetListEntryArray) {
            super(presetListEntryArray);
            this.delimiter = string;
        }

        public void setSelectedItem(Object object) {
            if (object == null) {
                this.clearSelection();
            } else {
                String string = object.toString();
                TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(string.split(this.delimiter)));
                ListModel listModel = this.getModel();
                int[] nArray = new int[listModel.getSize()];
                int n = 0;
                for (int i = 0; i < listModel.getSize(); ++i) {
                    String string2 = ((PresetListEntry)listModel.getElementAt((int)i)).value;
                    if (!treeSet.contains(string2)) continue;
                    nArray[n++] = i;
                    treeSet.remove(string2);
                }
                this.setSelectedIndices(Arrays.copyOf(nArray, n));
                this.setEnabled(treeSet.isEmpty());
            }
        }

        public String getSelectedItem() {
            ListModel listModel = this.getModel();
            int[] nArray = this.getSelectedIndices();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(this.delimiter);
                }
                stringBuilder.append(((PresetListEntry)listModel.getElementAt((int)nArray[i])).value);
            }
            return stringBuilder.toString();
        }
    }

    private static final class Renderer
    implements ListCellRenderer<PresetListEntry> {
        private final JLabel lbl = new JLabel();

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PresetListEntry> jList, PresetListEntry presetListEntry, int n, boolean bl, boolean bl2) {
            if (!jList.isShowing() && presetListEntry.prefferedWidth != -1 && presetListEntry.prefferedHeight != -1) {
                if (n == -1) {
                    this.lbl.setPreferredSize(new Dimension(presetListEntry.prefferedWidth, 10));
                } else {
                    this.lbl.setPreferredSize(new Dimension(presetListEntry.prefferedWidth, presetListEntry.prefferedHeight));
                }
                return this.lbl;
            }
            this.lbl.setPreferredSize(null);
            if (bl) {
                this.lbl.setBackground(jList.getSelectionBackground());
                this.lbl.setForeground(jList.getSelectionForeground());
            } else {
                this.lbl.setBackground(jList.getBackground());
                this.lbl.setForeground(jList.getForeground());
            }
            this.lbl.setOpaque(true);
            this.lbl.setFont(this.lbl.getFont().deriveFont(0));
            this.lbl.setText("<html>" + presetListEntry.getListDisplay() + "</html>");
            this.lbl.setIcon(presetListEntry.getIcon());
            this.lbl.setEnabled(jList.isEnabled());
            presetListEntry.prefferedWidth = this.lbl.getPreferredSize().width;
            presetListEntry.prefferedHeight = this.lbl.getPreferredSize().height;
            if (n == -1) {
                this.lbl.setPreferredSize(new Dimension(this.lbl.getPreferredSize().width, 10));
            }
            return this.lbl;
        }
    }
}

