/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.exception.ExceptionLayoutImpl;
import org.jruby.truffle.core.exception.NameErrorLayout;
import org.jruby.truffle.language.backtrace.Backtrace;

@GeneratedBy(value=NameErrorLayout.class)
public class NameErrorLayoutImpl
extends ExceptionLayoutImpl
implements NameErrorLayout {
    public static final NameErrorLayout INSTANCE = new NameErrorLayoutImpl();
    protected static final Shape.Allocator NAME_ERROR_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey RECEIVER_IDENTIFIER;
    protected static final Property RECEIVER_PROPERTY;
    protected static final HiddenKey NAME_IDENTIFIER;
    protected static final Property NAME_PROPERTY;

    protected NameErrorLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createNameErrorShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new NameErrorType(logicalClass, metaClass)).addProperty(MESSAGE_PROPERTY).addProperty(BACKTRACE_PROPERTY).addProperty(RECEIVER_PROPERTY).addProperty(NAME_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createNameError(DynamicObjectFactory factory, Object message, Backtrace backtrace, Object receiver, Object name) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (NameErrorLayoutImpl.createsNameError(factory));
        assert (factory.getShape().hasProperty(MESSAGE_IDENTIFIER));
        assert (factory.getShape().hasProperty(BACKTRACE_IDENTIFIER));
        assert (factory.getShape().hasProperty(RECEIVER_IDENTIFIER));
        assert (factory.getShape().hasProperty(NAME_IDENTIFIER));
        assert (message != null);
        assert (name != null);
        return factory.newInstance(message, backtrace, receiver, name);
    }

    private static boolean isNameError(DynamicObject object) {
        return NameErrorLayoutImpl.isNameError(object.getShape().getObjectType());
    }

    private static boolean isNameError(ObjectType objectType) {
        return objectType instanceof NameErrorType;
    }

    private static boolean createsNameError(DynamicObjectFactory factory) {
        return NameErrorLayoutImpl.isNameError(factory.getShape().getObjectType());
    }

    @Override
    public Object getReceiver(DynamicObject object) {
        assert (NameErrorLayoutImpl.isNameError(object));
        assert (object.getShape().hasProperty(RECEIVER_IDENTIFIER));
        return RECEIVER_PROPERTY.get(object, NameErrorLayoutImpl.isNameError(object));
    }

    @Override
    public void setReceiver(DynamicObject object, Object value) {
        assert (NameErrorLayoutImpl.isNameError(object));
        assert (object.getShape().hasProperty(RECEIVER_IDENTIFIER));
        try {
            RECEIVER_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Object getName(DynamicObject object) {
        assert (NameErrorLayoutImpl.isNameError(object));
        assert (object.getShape().hasProperty(NAME_IDENTIFIER));
        return NAME_PROPERTY.get(object, NameErrorLayoutImpl.isNameError(object));
    }

    @Override
    public void setName(DynamicObject object, Object value) {
        assert (NameErrorLayoutImpl.isNameError(object));
        assert (object.getShape().hasProperty(NAME_IDENTIFIER));
        assert (value != null);
        try {
            NAME_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        NAME_ERROR_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull));
        NAME_ERROR_ALLOCATOR.locationForType(Backtrace.class);
        RECEIVER_IDENTIFIER = new HiddenKey("receiver");
        RECEIVER_PROPERTY = Property.create(RECEIVER_IDENTIFIER, NAME_ERROR_ALLOCATOR.locationForType(Object.class), 0);
        NAME_IDENTIFIER = new HiddenKey("name");
        NAME_PROPERTY = Property.create(NAME_IDENTIFIER, NAME_ERROR_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), 0);
    }

    public static class NameErrorType
    extends ExceptionLayoutImpl.ExceptionType {
        public NameErrorType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public NameErrorType setLogicalClass(DynamicObject logicalClass) {
            return new NameErrorType(logicalClass, this.metaClass);
        }

        @Override
        public NameErrorType setMetaClass(DynamicObject metaClass) {
            return new NameErrorType(this.logicalClass, metaClass);
        }
    }
}

