/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u001e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH$J\u0016\u0010\u001f\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH\u0002J\u0016\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\"\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010#\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010$\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH$J\u001e\u0010%\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH$J\u001e\u0010&\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH$J3\u0010'\u001a\u0004\u0018\u00010\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\n2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0,\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/backend/common/DataClassMethodGenerator;", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "dataProperties", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getDataProperties", "()Ljava/util/List;", "primaryConstructorParameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPrimaryConstructorParameters", "generate", "", "generateComponentFunction", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "generateComponentFunctionsForDataClasses", "generateCopyFunction", "constructorParameters", "generateCopyFunctionForDataClasses", "generateDataClassEqualsIfNeeded", "properties", "generateDataClassHashCodeIfNeeded", "generateDataClassToStringIfNeeded", "generateEqualsMethod", "generateHashCodeMethod", "generateToStringMethod", "getDeclaredMember", "name", "", "returnedClassifier", "valueParameterClassifiers", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;[Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isTrivial", "", "kotlin-compiler"})
public abstract class DataClassMethodGenerator {
    @NotNull
    private final ClassDescriptor classDescriptor;
    private final KotlinBuiltIns builtIns;
    private final KtClassOrObject declaration;
    private final BindingContext bindingContext;

    @NotNull
    protected final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public final void generate() {
        this.generateComponentFunctionsForDataClasses();
        this.generateCopyFunctionForDataClasses(this.getPrimaryConstructorParameters());
        List<PropertyDescriptor> properties2 = this.getDataProperties();
        Collection collection = properties2;
        if (!collection.isEmpty()) {
            this.generateDataClassToStringIfNeeded(properties2);
            this.generateDataClassHashCodeIfNeeded(properties2);
            this.generateDataClassEqualsIfNeeded(properties2);
        }
    }

    protected abstract void generateComponentFunction(@NotNull FunctionDescriptor var1, @NotNull ValueParameterDescriptor var2);

    protected abstract void generateCopyFunction(@NotNull FunctionDescriptor var1, @NotNull List<? extends KtParameter> var2);

    protected abstract void generateToStringMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateHashCodeMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateEqualsMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    private final void generateComponentFunctionsForDataClasses() {
        ConstructorDescriptor constructorDescriptor = this.classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor constructor = constructorDescriptor;
        for (ValueParameterDescriptor parameter : constructor.getValueParameters()) {
            FunctionDescriptor function = (FunctionDescriptor)this.bindingContext.get(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter);
            if (function == null) continue;
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameter");
            this.generateComponentFunction(function, valueParameterDescriptor);
        }
    }

    private final void generateCopyFunctionForDataClasses(List<? extends KtParameter> constructorParameters) {
        FunctionDescriptor copyFunction;
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DATA_CLASS_COPY_FUNCTION, this.classDescriptor);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = copyFunction = functionDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "copyFunction");
        this.generateCopyFunction(functionDescriptor2, constructorParameters);
    }

    private final void generateDataClassToStringIfNeeded(List<? extends PropertyDescriptor> properties2) {
        ClassDescriptor classDescriptor = this.builtIns.getString();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "builtIns.string");
        FunctionDescriptor function = this.getDeclaredMember("toString", classDescriptor, new ClassDescriptor[0]);
        if (function != null && this.isTrivial(function)) {
            this.generateToStringMethod(function, properties2);
        }
    }

    private final void generateDataClassHashCodeIfNeeded(List<? extends PropertyDescriptor> properties2) {
        ClassDescriptor classDescriptor = this.builtIns.getInt();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "builtIns.int");
        FunctionDescriptor function = this.getDeclaredMember("hashCode", classDescriptor, new ClassDescriptor[0]);
        if (function != null && this.isTrivial(function)) {
            this.generateHashCodeMethod(function, properties2);
        }
    }

    private final void generateDataClassEqualsIfNeeded(List<? extends PropertyDescriptor> properties2) {
        ClassDescriptor classDescriptor = this.builtIns.getBoolean();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "builtIns.boolean");
        ClassDescriptor[] classDescriptorArray = new ClassDescriptor[1];
        ClassDescriptor classDescriptor2 = this.builtIns.getAny();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "builtIns.any");
        classDescriptorArray[0] = classDescriptor2;
        FunctionDescriptor function = this.getDeclaredMember("equals", classDescriptor, classDescriptorArray);
        if (function != null && this.isTrivial(function)) {
            this.generateEqualsMethod(function, properties2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PropertyDescriptor> getDataProperties() {
        void var3_3;
        KtParameter it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.getPrimaryConstructorParameters();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (KtParameter)element$iv$iv;
            if (!it.hasValOrVar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object v = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, it);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)v;
            collection.add(propertyDescriptor);
        }
        return (List)var3_3;
    }

    private final List<KtParameter> getPrimaryConstructorParameters() {
        KtClassOrObject ktClassOrObject = this.declaration;
        if (!(ktClassOrObject instanceof KtClass)) {
            ktClassOrObject = null;
        }
        KtClass ktClass = (KtClass)ktClassOrObject;
        List<KtParameter> list2 = ktClass != null ? ktClass.getPrimaryConstructorParameters() : null;
        List<KtParameter> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private final FunctionDescriptor getDeclaredMember(String name, ClassDescriptor returnedClassifier, ClassDescriptor ... valueParameterClassifiers) {
        Name name2 = Name.identifier(name);
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(name)");
        ClassifierDescriptor[] classifierDescriptorArray = valueParameterClassifiers;
        return CodegenUtil.getDeclaredFunctionByRawSignature(this.classDescriptor, name2, returnedClassifier, Arrays.copyOf(classifierDescriptorArray, classifierDescriptorArray.length));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrivial(FunctionDescriptor function) {
        boolean bl;
        if (!(Intrinsics.areEqual((Object)function.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true)) return false;
        Iterable $receiver$iv = OverridingUtil.getOverriddenDeclarations(function);
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            CallableMemberDescriptor overridden = (CallableMemberDescriptor)element$iv;
            if (overridden instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)overridden.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) && Intrinsics.areEqual(overridden.getContainingDeclaration(), this.builtIns.getAny()) ^ true) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public DataClassMethodGenerator(@NotNull KtClassOrObject declaration, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        this.declaration = declaration;
        this.bindingContext = bindingContext;
        Object v = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, this.declaration);
        Intrinsics.checkExpressionValueIsNotNull(v, "BindingContextUtils.getN\u2026ntext.CLASS, declaration)");
        this.classDescriptor = (ClassDescriptor)v;
        this.builtIns = DescriptorUtilsKt.getBuiltIns(this.classDescriptor);
    }
}

