type token =
  | TComment of (Ast_css.info)
  | S of (Ast_css.info)
  | CHARSET of (Ast_css.info)
  | IMPORT of (Ast_css.info)
  | MEDIA of (Ast_css.info)
  | PAGE of (Ast_css.info)
  | FONTFACE of (Ast_css.info)
  | OPEN_CURLY of (Ast_css.info)
  | CLOSE_CURLY of (Ast_css.info)
  | OPEN_ROUND of (Ast_css.info)
  | CLOSE_ROUND of (Ast_css.info)
  | OPEN_SQUARE of (Ast_css.info)
  | CLOSE_SQUARE of (Ast_css.info)
  | SEMICOLON of (Ast_css.info)
  | COLON of (Ast_css.info)
  | DOUBLE_COLON of (Ast_css.info)
  | COMMA of (Ast_css.info)
  | PERIOD of (Ast_css.info)
  | SLASH of (Ast_css.info)
  | ASTERISK of (Ast_css.info)
  | QUOTIENT of (Ast_css.info)
  | PLUS of (Ast_css.info)
  | MINUS of (Ast_css.info)
  | TILDE of (Ast_css.info)
  | GT of (Ast_css.info)
  | IMPORTANT of (Ast_css.info)
  | ATTR_EQUALS of (Ast_css.info)
  | ATTR_INCLUDES of (Ast_css.info)
  | ATTR_DASHMATCH of (Ast_css.info)
  | ATTR_PREFIX of (Ast_css.info)
  | ATTR_SUFFIX of (Ast_css.info)
  | ATTR_SUBSTRING of (Ast_css.info)
  | URI of (Ast_css.info)
  | TString of (string * Ast_css.info)
  | IDENT of (string * Ast_css.info)
  | NTH of (string * Ast_css.info)
  | HASH of (string * Ast_css.info)
  | VAR of (string * Ast_css.info)
  | SEL_FUNC of (string * Ast_css.info)
  | TERM_FUNC of (string * Ast_css.info)
  | QUANTITY of (string * Ast_css.info)
  | TUnknown of (Ast_css.info)
  | EOF of (Ast_css.info)

val stylesheet :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_css.stylesheet
