/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.ConditionalExpression;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DecompositionView;
import ch.interlis.ili2c.metamodel.DerivedUnit;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumValType;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.FormattedTypeBaseAttrRef;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.FunctionallyDerivedUnit;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.JoinView;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.MetaObject;
import ch.interlis.ili2c.metamodel.MetaobjectType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.ParameterAssignment;
import ch.interlis.ili2c.metamodel.ParameterValue;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RefSystemRef;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SetConstraint;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.SignInstruction;
import ch.interlis.ili2c.metamodel.StructuredUnit;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UnionView;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public class Interlis2Generator {
    IndentPrintWriter ipw;
    TransferDescription td;
    PredefinedModel modelInterlis;
    Unit anyUnit;
    boolean withPredefined;
    int numErrors = 0;
    private ArrayList selfStandingConstraints = null;

    public static Interlis2Generator generateElements(Writer out, TransferDescription td) {
        Interlis2Generator i = new Interlis2Generator();
        i.setup(out, td, false);
        return i;
    }

    public static String debugToString(TransferDescription td, Element ele) {
        StringWriter syntaxBuffer = new StringWriter();
        Interlis2Generator makeSyntax = Interlis2Generator.generateElements(syntaxBuffer, td);
        makeSyntax.printElement(ele.getContainer(), null, ele);
        makeSyntax.ipw.flush();
        return syntaxBuffer.toString();
    }

    private void finish() {
        this.ipw.close();
    }

    protected void printError() {
        this.ipw.print(Element.makeErrorName(null));
        ++this.numErrors;
    }

    public int generate(Writer out, TransferDescription td) {
        return this.generate(out, td, false);
    }

    public int generate(Writer out, TransferDescription td, boolean withPredefined) {
        this.setup(out, td, withPredefined);
        this.printTransferDescription(td);
        this.finish();
        return this.numErrors;
    }

    private void setup(Writer out, TransferDescription td, boolean withPredefined) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
        this.modelInterlis = td.INTERLIS;
        this.anyUnit = td.INTERLIS.ANYUNIT;
        this.withPredefined = withPredefined;
    }

    private boolean printModifierHelper(boolean first, boolean flag, String what) {
        if (flag) {
            if (!first) {
                this.ipw.print(", ");
            }
            this.ipw.print(what);
            return false;
        }
        return first;
    }

    protected void printModifiers(boolean _abstract, boolean _final, boolean _extended, boolean _ordered, boolean _external, boolean _transient) {
        if (!(_abstract || _final || _extended || _ordered || _external || _transient)) {
            return;
        }
        boolean first = true;
        this.ipw.print(" (");
        first = this.printModifierHelper(first, _abstract, "ABSTRACT");
        first = this.printModifierHelper(first, _final, "FINAL");
        first = this.printModifierHelper(first, _extended, "EXTENDED");
        first = this.printModifierHelper(first, _ordered, "ORDERED");
        first = this.printModifierHelper(first, _external, "EXTERNAL");
        first = this.printModifierHelper(first, _transient, "TRANSIENT");
        this.ipw.print(')');
    }

    protected void printTopic(Topic topic) {
        Iterator<Topic> it;
        Domain classOid;
        if (topic == null) {
            return;
        }
        this.selfStandingConstraints = new ArrayList();
        Topic extending = (Topic)topic.getExtending();
        this.printDocumentation(topic.getDocumentation());
        this.ipw.print("TOPIC ");
        this.ipw.print(topic.getName());
        this.printModifiers(topic.isAbstract(), topic.isFinal(), false, false, false, false);
        if (extending != null) {
            this.ipw.print(" EXTENDS ");
            this.ipw.print(extending.getScopedName(topic));
        }
        this.ipw.println(" =");
        this.ipw.indent();
        Domain basketOid = topic.getBasketOid();
        if (basketOid != null) {
            this.ipw.print("BASKET OID AS ");
            this.ipw.print(basketOid.getScopedName(topic));
            this.ipw.println(';');
        }
        if ((classOid = topic.getOid()) != null) {
            this.ipw.print("OID AS ");
            this.ipw.print(classOid.getScopedName(topic));
            this.ipw.println(';');
        }
        if ((it = topic.getDependentOn()).hasNext()) {
            this.ipw.print("DEPENDS ON ");
            this.ipw.print(it.next().getScopedName(topic));
            while (it.hasNext()) {
                this.ipw.print(", ");
                this.ipw.print(it.next().getScopedName(topic));
            }
            this.ipw.println(';');
            this.ipw.println();
        }
        this.printElements(topic);
        Iterator csi = this.selfStandingConstraints.iterator();
        Viewable view = null;
        Viewable lastView = null;
        while (csi.hasNext()) {
            Constraint cs = (Constraint)csi.next();
            view = (Viewable)cs.getContainer();
            if (view != lastView) {
                if (lastView != null) {
                    this.ipw.unindent();
                    this.ipw.println("END;");
                } else {
                    this.ipw.println();
                }
                lastView = view;
                this.ipw.print("CONSTRAINTS OF ");
                this.ipw.print(view.getName());
                this.ipw.println('=');
                this.ipw.indent();
            }
            this.printConstraint(cs);
        }
        if (lastView != null) {
            this.ipw.unindent();
            this.ipw.println("END;");
        }
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        this.ipw.print(topic.getName());
        this.ipw.println(';');
    }

    protected void printAbstractClassDef(AbstractClassDef def) {
        String keyword;
        this.printDocumentation(def.getDocumentation());
        this.printMetaValues(def.getMetaValues());
        if (def instanceof Table) {
            Table tdef = (Table)def;
            keyword = tdef.isIdentifiable() ? "CLASS" : "STRUCTURE";
        } else if (def instanceof AssociationDef) {
            keyword = "ASSOCIATION";
        } else {
            throw new IllegalArgumentException();
        }
        this.printStart(keyword, def, null);
        this.ipw.println(" =");
        this.ipw.indent();
        Domain oid = def.getOid();
        if (oid != null) {
            if (oid instanceof NoOid) {
                this.ipw.println("NO OID;");
            } else {
                this.ipw.print("OID AS ");
                this.ipw.print(oid.getScopedName(def.getContainer()));
                this.ipw.println(";");
            }
        }
        this.printElements(def);
        this.printEnd(def);
    }

    private void printRenamedViewableRef(Container scope, ViewableAlias ref) {
        if (ref == null) {
            this.printError();
            return;
        }
        String name = ref.getName();
        Viewable v = ref.getAliasing();
        if (name == null || v == null) {
            this.printError();
            return;
        }
        if (!name.equals(v.getName())) {
            this.ipw.print(name);
            this.ipw.print('~');
        }
        this.ipw.print(v.getScopedName(scope));
    }

    protected void printRenamedViewableRefs(Container scope, ViewableAlias[] refs) {
        if (refs == null || refs.length == 0) {
            return;
        }
        this.printRenamedViewableRef(scope, refs[0]);
        for (int i = 1; i < refs.length; ++i) {
            this.ipw.print(", ");
            this.printRenamedViewableRef(scope, refs[i]);
        }
    }

    protected void printStart(String keyword, ExtendableContainer ec, Viewable basedOn) {
        if (ec == null) {
            return;
        }
        ExtendableContainer extending = (ExtendableContainer)ec.getExtending();
        boolean extendingSameName = false;
        if (extending != null) {
            Topic myTopic = (Topic)ec.getContainer(Topic.class);
            Topic extendedTopic = (Topic)extending.getContainer(Topic.class);
            if (myTopic != null && extendedTopic != null && myTopic.isExtending(extendedTopic) && ec.getName().equals(extending.getName())) {
                extendingSameName = true;
            }
        }
        this.ipw.print(keyword);
        this.ipw.print(' ');
        this.ipw.print(ec.getName());
        boolean _transient = false;
        if (ec instanceof View) {
            _transient = ((View)ec).isTransient();
        }
        this.printModifiers(ec.isAbstract(), ec.isFinal(), extendingSameName, false, false, _transient);
        if (extending != null && !extendingSameName) {
            this.ipw.print(" EXTENDS ");
            this.ipw.print(extending.getScopedName(ec.getContainer(Element.class)));
        }
        if (basedOn != null) {
            this.ipw.print(" BASED ON ");
            this.ipw.print(basedOn.getScopedName((Container)ec.getContainer(Element.class)));
        }
    }

    protected void printEnd(ExtendableContainer ec) {
        if (ec == null) {
            return;
        }
        this.ipw.unindent();
        this.ipw.print("END ");
        this.ipw.print(ec.getName());
        this.ipw.println(';');
    }

    public void printView(View view) {
        this.printDocumentation(view.getDocumentation());
        this.printMetaValues(view.getMetaValues());
        this.printStart("VIEW", view, null);
        this.ipw.println("");
        this.ipw.indent();
        if (view instanceof Projection) {
            this.ipw.print("PROJECTION OF ");
            this.ipw.print(((Projection)view).getSelected().getAliasing().getScopedName((Container)view));
        } else if (view instanceof JoinView) {
            this.ipw.print("JOIN OF ");
            this.printRenamedViewableRefs(view, ((JoinView)view).getJoining());
        } else if (view instanceof UnionView) {
            this.ipw.print("UNION OF ");
            this.printRenamedViewableRefs(view, ((UnionView)view).getUnited());
        } else if (view instanceof DecompositionView) {
            Object decomposedViewable = null;
            ObjectPath decomposedAttribute = ((DecompositionView)view).getDecomposedAttribute();
            if (((DecompositionView)view).isAreaDecomposition()) {
                this.ipw.print("AREA ");
            }
            this.ipw.print("DECOMPOSITION OF ");
            if (decomposedAttribute == null) {
                this.printError();
            }
        } else {
            this.printError();
            this.ipw.println("<unknown view type>");
        }
        this.ipw.println("; =");
        this.printElements(view);
        this.printEnd(view);
    }

    public void printGraphic(Graphic graph) {
        if (graph == null) {
            return;
        }
        this.printDocumentation(graph.getDocumentation());
        this.printMetaValues(graph.getMetaValues());
        this.printStart("GRAPHIC", graph, graph.getBasedOn());
        this.ipw.println(" =");
        this.ipw.indent();
        this.printElements(graph);
        this.printEnd(graph);
    }

    protected int getExpressionPrecedence(Evaluable ev) {
        if (ev instanceof Expression.Disjunction) {
            return 1;
        }
        if (ev instanceof Expression.Conjunction) {
            return 2;
        }
        if (ev instanceof Expression.Negation) {
            return 4;
        }
        if (ev instanceof Expression.Equality || ev instanceof Expression.Inequality || ev instanceof Expression.LessThanOrEqual || ev instanceof Expression.LessThan || ev instanceof Expression.GreaterThanOrEqual || ev instanceof Expression.GreaterThan) {
            return 5;
        }
        if (ev instanceof Expression.DefinedCheck) {
            return 7;
        }
        return 8;
    }

    protected void printExpression(Container scope, Evaluable expr) {
        this.printExpression(scope, expr, 1);
    }

    protected void printExpression(Container scope, Evaluable expr, int precedence) {
        int exprPrec = this.getExpressionPrecedence(expr);
        if (exprPrec < precedence) {
            this.ipw.print('(');
            this.printExpression(scope, expr, 1);
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ObjectPath) {
            this.printAttributePath(scope, (ObjectPath)expr);
            return;
        }
        if (expr instanceof Constant.Undefined) {
            this.ipw.print("UNDEFINED");
            return;
        }
        if (expr instanceof Constant.Numeric) {
            Constant.Numeric cnum = (Constant.Numeric)expr;
            this.ipw.print(cnum.getValue());
            if (cnum.getUnit() != null) {
                this.ipw.print('[');
                this.printRef(scope, cnum.getUnit());
                this.ipw.print(']');
            }
            return;
        }
        if (expr instanceof Constant.Text) {
            this.ipw.print('\"');
            this.ipw.print(((Constant.Text)expr).getValue());
            this.ipw.print('\"');
            return;
        }
        if (expr instanceof Constant.AttributePath) {
            this.ipw.print(">>");
            this.ipw.print(((Constant.AttributePath)expr).getValue().getName());
            return;
        }
        if (expr instanceof Constant.Enumeration) {
            this.ipw.print('#');
            String[] val = ((Constant.Enumeration)expr).getValue();
            if (val == null) {
                this.printError();
            } else {
                for (int i = 0; i < val.length; ++i) {
                    if (i > 0) {
                        this.ipw.print('.');
                    }
                    if (val[i] == null) {
                        this.printError();
                        continue;
                    }
                    this.ipw.print(val[i]);
                }
            }
            return;
        }
        if (expr instanceof Constant.ReferenceToMetaObject) {
            MetaObject refMO = ((Constant.ReferenceToMetaObject)expr).getReferred();
            this.ipw.print('\"');
            if (refMO != null) {
                this.ipw.print(refMO.getName());
            } else {
                this.printError();
            }
            this.ipw.print('\"');
            return;
        }
        if (expr instanceof Constant.Structured) {
            String val = ((Constant.Structured)expr).toString();
            if (val == null) {
                this.printError();
            } else {
                this.ipw.print(val);
            }
            return;
        }
        if (expr instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)expr;
            this.printRef(scope, f.getFunction());
            this.ipw.print(" (");
            Evaluable[] args = f.getArguments();
            if (args == null) {
                this.printError();
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    this.printExpression(scope, args[i]);
                }
            }
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ParameterValue) {
            this.ipw.print("PARAMETER ");
            this.printRef(scope, ((ParameterValue)expr).getParameter());
            return;
        }
        if (expr instanceof Expression.Disjunction) {
            Evaluable[] disjoined = ((Expression.Disjunction)expr).getDisjoined();
            for (int i = 0; i < disjoined.length; ++i) {
                if (i > 0) {
                    this.ipw.print(" OR ");
                }
                this.printExpression(scope, disjoined[i], 2);
            }
            return;
        }
        if (expr instanceof Expression.Conjunction) {
            Evaluable[] conjoined = ((Expression.Conjunction)expr).getConjoined();
            for (int i = 0; i < conjoined.length; ++i) {
                if (i > 0) {
                    this.ipw.print(" AND ");
                }
                this.printExpression(scope, conjoined[i], 3);
            }
            return;
        }
        if (expr instanceof Expression.Negation) {
            this.ipw.print("NOT (");
            this.printExpression(scope, ((Expression.Negation)expr).getNegated(), 5);
            this.ipw.print(")");
            return;
        }
        if (expr instanceof Expression.Equality) {
            this.printExpression(scope, ((Expression.Equality)expr).getLeft(), 6);
            this.ipw.print(" == ");
            this.printExpression(scope, ((Expression.Equality)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.Inequality) {
            this.printExpression(scope, ((Expression.Inequality)expr).getLeft(), 6);
            this.ipw.print(" <> ");
            this.printExpression(scope, ((Expression.Inequality)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.LessThanOrEqual) {
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getLeft(), 6);
            this.ipw.print(" <= ");
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.GreaterThanOrEqual) {
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getLeft(), 6);
            this.ipw.print(" >= ");
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.LessThan) {
            this.printExpression(scope, ((Expression.LessThan)expr).getLeft(), 6);
            this.ipw.print(" < ");
            this.printExpression(scope, ((Expression.LessThan)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.GreaterThan) {
            this.printExpression(scope, ((Expression.GreaterThan)expr).getLeft(), 6);
            this.ipw.print(" > ");
            this.printExpression(scope, ((Expression.GreaterThan)expr).getRight(), 6);
            return;
        }
        if (expr instanceof Expression.DefinedCheck) {
            this.ipw.print("DEFINED (");
            this.printExpression(scope, ((Expression.DefinedCheck)expr).getArgument(), 7);
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ConditionalExpression) {
            ConditionalExpression.Condition[] conds = ((ConditionalExpression)expr).getConditions();
            this.ipw.print("WITH ");
            this.printAttributePath(scope, ((ConditionalExpression)expr).getAttribute());
            this.ipw.println(" (");
            this.ipw.indent();
            if (conds == null) {
                this.printError();
            } else {
                for (int i = 0; i < conds.length; ++i) {
                    if (i != 0) {
                        this.ipw.println(",");
                    }
                    if (conds[i] == null) {
                        this.printError();
                        continue;
                    }
                    this.printExpression(scope, conds[i].getValue());
                    this.ipw.print(" WHEN IN ");
                    this.printExpression(scope, conds[i].getCondition());
                }
            }
            this.ipw.unindent();
            this.ipw.print(')');
            return;
        }
        this.printError();
    }

    protected void printExistenceConstraint(Viewable forTable, ExistenceConstraint ec) {
        this.ipw.print("EXISTENCE CONSTRAINT ");
        ObjectPath attr = ec.getRestrictedAttribute();
        this.printAttributePath(forTable, attr);
        this.ipw.print(" REQUIRED IN ");
        Iterator<ObjectPath> reqi = ec.iteratorRequiredIn();
        String next = "";
        while (reqi.hasNext()) {
            ObjectPath req = reqi.next();
            this.ipw.print(next);
            next = " OR ";
            this.printRef(forTable, req.getRoot());
            this.ipw.print(":");
            this.printAttributePath(forTable, req);
        }
        this.ipw.println(';');
    }

    protected void printSetConstraint(Viewable forTable, SetConstraint ec) {
        this.ipw.print("SET CONSTRAINT");
        if (ec.getPreCondition() != null) {
            this.ipw.print(" WHERE ");
            this.printExpression(forTable, ec.getPreCondition());
            this.ipw.println(": ");
        } else {
            this.ipw.println("");
        }
        this.ipw.indent();
        this.printExpression(forTable, ec.getCondition());
        this.ipw.println(';');
        this.ipw.unindent();
    }

    protected void printUniquenessConstraint(Viewable forTable, UniquenessConstraint uc) {
        UniqueEl uel = uc.getElements();
        Iterator pathi = uel.iteratorAttribute();
        if (uc.getLocal()) {
            this.ipw.print("UNIQUE (LOCAL) ");
            ObjectPath prefix = uc.getPrefix();
            this.printAttributePath(forTable, prefix);
            String next = ": ";
            while (pathi.hasNext()) {
                ObjectPath path = (ObjectPath)pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(forTable, path);
            }
        } else {
            this.ipw.print("UNIQUE");
            String next = " ";
            while (pathi.hasNext()) {
                ObjectPath path = (ObjectPath)pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(forTable, path);
            }
        }
        this.ipw.println(';');
    }

    public void printConstraint(Constraint elt) {
        this.printDocumentation(elt.getDocumentation());
        this.printMetaValues(elt.getMetaValues());
        Container container = elt.getContainer();
        if (elt instanceof MandatoryConstraint) {
            this.ipw.println("MANDATORY CONSTRAINT");
            this.ipw.indent();
            this.printExpression(container, ((MandatoryConstraint)elt).getCondition());
            this.ipw.println(';');
            this.ipw.unindent();
        } else if (elt instanceof PlausibilityConstraint) {
            PlausibilityConstraint pc = (PlausibilityConstraint)elt;
            this.ipw.print("CONSTRAINT ");
            if (pc.getDirection() == 0) {
                this.ipw.print(" >= ");
            } else {
                this.ipw.print(" <= ");
            }
            this.ipw.print(pc.getPercentage());
            this.ipw.println('%');
            this.ipw.indent();
            this.printExpression(container, pc.getCondition());
            this.ipw.println(';');
            this.ipw.unindent();
        } else if (elt instanceof UniquenessConstraint) {
            UniquenessConstraint uc = (UniquenessConstraint)elt;
            this.printUniquenessConstraint((Viewable)container, uc);
        } else if (elt instanceof ExistenceConstraint) {
            this.printExistenceConstraint((Viewable)container, (ExistenceConstraint)elt);
        } else if (elt instanceof SetConstraint) {
            this.printSetConstraint((Viewable)container, (SetConstraint)elt);
        }
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp) {
        this.printDocumentation(gfxp.getDocumentation());
        this.printMetaValues(gfxp.getMetaValues());
        this.ipw.print(gfxp.getName());
        this.ipw.print(" : ");
        this.printType(gfxp.getContainer(), gfxp.getDomain());
        this.ipw.println(";");
    }

    public void printMetaDataUseDef(MetaDataUseDef mu) {
        this.printDocumentation(mu.getDocumentation());
        this.printMetaValues(mu.getMetaValues());
        if (mu.isSignData()) {
            this.ipw.print("SIGN BASKET ");
        } else {
            this.ipw.print("REFSYSTEM BASKET ");
        }
        this.ipw.print(mu.getName());
        this.printModifiers(false, mu.isFinal(), false, false, false, false);
        Topic topic = mu.getTopic();
        this.ipw.print("~");
        this.ipw.print(topic.getContainer().getName());
        this.ipw.print(".");
        this.ipw.print(topic.getName());
        this.ipw.indent();
        this.ipw.indent();
        Table lastTable = null;
        String sep = "";
        for (Object moo : mu) {
            if (!(moo instanceof MetaObject)) continue;
            MetaObject mo = (MetaObject)moo;
            Table table = mo.getTable();
            if (table != lastTable) {
                this.ipw.println();
                this.ipw.unindent();
                this.ipw.print("OBJECTS OF ");
                this.ipw.print(table.getName());
                this.ipw.println(":");
                this.ipw.indent();
                lastTable = table;
            } else {
                this.ipw.println(",");
            }
            this.printDocumentation(mo.getDocumentation());
            this.printMetaValues(mo.getMetaValues());
            this.ipw.print(mo.getName());
        }
        this.ipw.println(";");
        this.ipw.unindent();
        this.ipw.unindent();
    }

    public void printUnit(Container scope, Unit u) {
        if (u == null) {
            this.printError();
            return;
        }
        Unit extending = (Unit)u.getExtending();
        this.printDocumentation(u.getDocumentation());
        this.printMetaValues(u.getMetaValues());
        this.ipw.print(u.getDocName());
        if (!u.getDocName().equals(u.getName())) {
            this.ipw.print(" [");
            this.ipw.print(u.getName());
            this.ipw.print(']');
        }
        this.printModifiers(u.isAbstract(), false, false, false, false, false);
        if (extending != null && extending != this.anyUnit && !(u instanceof DerivedUnit)) {
            this.ipw.print(" EXTENDS ");
            this.ipw.print(extending.getScopedName(scope));
        }
        if (u instanceof NumericallyDerivedUnit) {
            NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)u).getConversionFactors();
            this.ipw.print(" =");
            if (factors.length >= 1) {
                for (int i = 0; i < factors.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(' ');
                        this.ipw.print(factors[i].getConversionOperator());
                    }
                    this.ipw.print(' ');
                    this.printNumericConst(factors[i].getConversionFactor());
                }
            }
            this.ipw.print(" [");
            this.printRef(scope, ((NumericallyDerivedUnit)u).getExtending());
            this.ipw.print(']');
        } else if (u instanceof FunctionallyDerivedUnit) {
            this.ipw.print(" = FUNCTION ");
            this.printExplanation(((FunctionallyDerivedUnit)u).getExplanation());
            this.ipw.print(" [");
            this.printRef(scope, ((FunctionallyDerivedUnit)u).getExtending());
            this.ipw.print(']');
        } else if (u instanceof ComposedUnit) {
            ComposedUnit.Composed[] composed = ((ComposedUnit)u).getComposedUnits();
            this.ipw.print(" = (");
            for (int i = 0; i < composed.length; ++i) {
                if (i > 0) {
                    this.ipw.print(' ');
                    this.ipw.print(composed[i].getCompositionOperator());
                    this.ipw.print(' ');
                }
                this.printRef(scope, composed[i].getUnit());
            }
            this.ipw.print(')');
        } else if (u instanceof StructuredUnit) {
            StructuredUnit.Part[] parts = ((StructuredUnit)u).getParts();
            this.ipw.print(" = {");
            this.printRef(scope, ((StructuredUnit)u).getFirstUnit());
            for (int i = 0; i < parts.length; ++i) {
                this.ipw.print(':');
                this.printRef(scope, parts[i].getUnit());
                this.ipw.print('[');
                this.ipw.print(parts[i].getMinimum());
                this.ipw.print("..");
                this.ipw.print(parts[i].getMaximum());
                this.ipw.print(']');
            }
            this.ipw.print('}');
            if (((StructuredUnit)u).isContinuous()) {
                this.ipw.print(" CONTINUOUS");
            }
        }
        if (u instanceof StructuredUnit) {
            EhiLogger.logError("UNIT " + u.getName() + ": StructuredUnit not supported by INTERLIS 2.3");
            this.ipw.println("; !! Hint: comment out/remove");
        } else {
            this.ipw.println(';');
        }
    }

    protected void printRef(Container scope, Element elt) {
        if (elt == null) {
            this.printError();
        } else if (elt == this.modelInterlis.ANYCLASS) {
            this.ipw.print("ANYCLASS");
        } else if (elt == this.modelInterlis.ANYSTRUCTURE) {
            this.ipw.print("ANYSTRUCTURE");
        } else {
            this.ipw.print(elt.getScopedName(scope));
        }
    }

    public void printParameter(Container scope, Parameter par) {
        if (par == null) {
            this.printError();
            return;
        }
        this.printDocumentation(par.getDocumentation());
        this.printMetaValues(par.getMetaValues());
        this.ipw.print(par.getName());
        Parameter ext = par.getExtending();
        if (ext != null) {
            if (par.getName().equals(ext.getName())) {
                this.ipw.print(" (EXTENDED)");
            } else {
                this.ipw.print(" EXTENDS ");
                this.printRef(scope, ext);
            }
        }
        this.ipw.print(": ");
        Type typ = par.getType();
        if (typ instanceof ReferenceType) {
            this.ipw.print("-> ");
            this.printRef(scope, ((ReferenceType)typ).getReferred());
        } else {
            this.printType(scope, typ);
        }
        this.ipw.println(';');
    }

    private void printNumericConst(PrecisionDecimal num) {
        if (num == PrecisionDecimal.PI) {
            this.ipw.print("PI");
            return;
        }
        if (num == PrecisionDecimal.LNBASE) {
            this.ipw.print("LNBASE");
            return;
        }
        this.ipw.print(num.toString());
    }

    protected void printRoleDef(Container scope, RoleDef role) {
        this.printDocumentation(role.getDocumentation());
        this.printMetaValues(role.getMetaValues());
        this.ipw.print(role.getName());
        this.printModifiers(role.isAbstract(), role.isFinal(), role.isExtended(), role.isOrdered(), role.isExternal(), false);
        String kind = "";
        switch (role.getKind()) {
            case 1: {
                kind = " -- ";
                break;
            }
            case 2: {
                kind = " -<> ";
                break;
            }
            case 3: {
                kind = " -<#> ";
            }
        }
        this.ipw.print(kind);
        if (role.getDefinedCardinality() != null) {
            this.ipw.print(role.getDefinedCardinality() + " ");
        }
        this.printRef(scope, role.getDestination());
        Iterator<AbstractClassDef> resti = role.getReference().iteratorRestrictedTo();
        String sep = " RESTRICTION (";
        boolean hasRestriction = false;
        while (resti.hasNext()) {
            AbstractClassDef rest = resti.next();
            this.ipw.print(sep);
            sep = ";";
            this.printRef(scope, rest);
            hasRestriction = true;
        }
        if (hasRestriction) {
            this.ipw.print(")");
        }
        this.ipw.println(';');
    }

    protected void printAttribute(Container scope, AttributeDef attrib) {
        LocalAttribute la;
        LocalAttribute la2;
        if (attrib == null) {
            this.printError();
            return;
        }
        if (attrib instanceof LocalAttribute && (la2 = (LocalAttribute)attrib).isGeneratedByAllOf()) {
            return;
        }
        Type proxyType = attrib.getDomain();
        if (proxyType != null && proxyType instanceof ObjectType) {
            if (((ObjectType)proxyType).isAllOf()) {
                this.ipw.println("ALL OF " + attrib.getName() + ";");
            }
            return;
        }
        this.printDocumentation(attrib.getDocumentation());
        this.printMetaValues(attrib.getMetaValues());
        if (attrib instanceof LocalAttribute && (la = (LocalAttribute)attrib).isSubdivision()) {
            if (la.isContinuous()) {
                this.ipw.print("CONTINUOUS ");
            }
            this.ipw.print("SUBDIVISION ");
        }
        this.ipw.print(attrib.getName());
        this.printModifiers(attrib.isAbstract(), attrib.isFinal(), attrib.getExtending() != null, false, false, attrib.isTransient());
        if (attrib instanceof LocalAttribute) {
            if (attrib.getDomain() != null || !(scope instanceof View)) {
                this.ipw.print(" : ");
                this.printType(scope, attrib.getDomain());
            }
            this.printAttributeBasePath(scope, attrib);
        }
        if (attrib instanceof LocalAttribute && attrib.getDomain() instanceof StructuredUnitType) {
            EhiLogger.logError("ATTRIBUTE " + attrib.getScopedName(null) + ": StructuredUnitType not supported by INTERLIS 2.3; replace by TextType or FormattedType/XMLDate");
            this.ipw.println("; !! Hint: replace by TextType or FormattedType/XMLDate");
        } else {
            this.ipw.println(';');
        }
    }

    public void printAttributeBasePath(Container scope, AttributeDef attrib) {
        Evaluable[] paths = ((LocalAttribute)attrib).getBasePaths();
        if (paths != null && paths.length != 0) {
            this.ipw.print(" := ");
            for (int i = 0; i < paths.length; ++i) {
                if (i > 0) {
                    this.ipw.print(", ");
                }
                this.printExpression(scope, paths[i]);
            }
        }
    }

    protected void printSignAttribute(Graphic scope, SignAttribute attrib) {
        SignAttribute extending = (SignAttribute)attrib.getExtending();
        this.printDocumentation(attrib.getDocumentation());
        this.ipw.print(attrib.getName());
        this.printModifiers(false, false, extending != null, false, false, false);
        if (extending == null || attrib.getGenerating() != extending.getGenerating()) {
            this.ipw.print(" OF ");
            this.printRef(scope, attrib.getGenerating());
        }
        this.ipw.println(":");
        this.ipw.indent();
        SignInstruction[] instructions = attrib.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            if (i > 0) {
                this.ipw.println(',');
            }
            this.printSignInstruction(scope.getBasedOn(), instructions[i]);
        }
        this.ipw.unindent();
        this.ipw.println(';');
    }

    protected void printSignInstruction(Viewable basedOn, SignInstruction instr) {
        if (instr == null) {
            this.printError();
            return;
        }
        Evaluable restrictor = instr.getRestrictor();
        if (restrictor != null) {
            this.ipw.print("WHERE ");
            this.printExpression(basedOn, restrictor);
            this.ipw.println();
        }
        this.ipw.println('(');
        this.ipw.indent();
        ParameterAssignment[] assignments = instr.getAssignments();
        for (int i = 0; i < assignments.length; ++i) {
            if (i > 0) {
                this.ipw.println(';');
            }
            this.printParameterAssignment(basedOn, assignments[i]);
        }
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print(')');
    }

    protected void printParameterAssignment(Viewable basedOn, ParameterAssignment parass) {
        if (parass == null) {
            this.printError();
            return;
        }
        Parameter assigned = parass.getAssigned();
        if (assigned == null) {
            this.printError();
        } else {
            this.ipw.print(assigned.getName());
        }
        this.ipw.print(" := ");
        this.printExpression(basedOn, parass.getValue());
    }

    public void printMetaValues(Settings values) {
        if (values != null) {
            for (String name : values.getValues()) {
                String value = values.getValue(name);
                this.ipw.print("!!@ ");
                this.ipw.print(name);
                this.ipw.print("=");
                if (value.indexOf(32) != -1 || value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(44) != -1 || value.indexOf(34) != -1 || value.indexOf(92) != -1) {
                    this.ipw.println("\"" + value + "\"");
                    continue;
                }
                this.ipw.println(value);
            }
        }
    }

    public void printDocumentation(String doc) {
        String line;
        if (doc == null) {
            return;
        }
        if (doc.length() == 0) {
            return;
        }
        String beg = "/** ";
        int last = 0;
        int next = doc.indexOf("\n", last);
        while (next > -1) {
            line = doc.substring(last, next);
            this.ipw.println(beg + line);
            beg = " * ";
            last = next + 1;
            next = doc.indexOf("\n", last);
        }
        line = doc.substring(last);
        this.ipw.println(beg + line);
        this.ipw.println(" */");
    }

    protected void printModel(Model mdef) {
        this.printDocumentation(mdef.getDocumentation());
        this.printMetaValues(mdef.getMetaValues());
        if (mdef.isContracted()) {
            this.ipw.print("CONTRACTED ");
        }
        this.ipw.print(mdef.toString());
        if (mdef.getLanguage() != null) {
            this.ipw.print("(" + mdef.getLanguage() + ")");
        }
        this.ipw.println();
        this.ipw.indent();
        String issuer = mdef.getIssuer();
        if (issuer == null) {
            issuer = "mailto:" + System.getProperty("user.name") + "@localhost";
        }
        this.ipw.println("AT \"" + issuer + "\"");
        String version = mdef.getModelVersion();
        if (version == null) {
            Calendar current = Calendar.getInstance();
            DecimalFormat digit4 = new DecimalFormat("0000");
            DecimalFormat digit2 = new DecimalFormat("00");
            version = digit4.format(current.get(1)) + "-" + digit2.format(current.get(2) + 1) + "-" + digit2.format(current.get(5));
        }
        this.ipw.print("VERSION \"" + version + "\"");
        String expl = mdef.getModelVersionExpl();
        if (expl != null && expl.length() > 0) {
            this.ipw.print(' ');
            this.printExplanation(expl);
        }
        this.ipw.println(" =");
        this.ipw.println();
        Model[] imported = mdef.getImporting();
        String sep = "";
        boolean modelsImported = false;
        for (int i = 0; i < imported.length; ++i) {
            Model curImport = imported[i];
            if (curImport instanceof Model) {
                if (curImport == this.modelInterlis) continue;
                if (!modelsImported) {
                    this.ipw.println("IMPORTS");
                    this.ipw.indent();
                    modelsImported = true;
                }
                this.ipw.print(sep + curImport.getName());
                sep = ", ";
                continue;
            }
            this.printError();
        }
        if (modelsImported) {
            this.ipw.println(';');
            this.ipw.unindent();
            this.ipw.println();
        }
        this.printElements(mdef);
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        this.ipw.print(mdef.getName());
        this.ipw.println('.');
        this.ipw.println();
    }

    protected void printExplanation(String explanationText) {
        this.ipw.print("//");
        this.ipw.print(explanationText);
        this.ipw.print("//");
    }

    protected void printDomainDef(Container scope, Domain dd) {
        Domain extending = dd.getExtending();
        this.printDocumentation(dd.getDocumentation());
        this.printMetaValues(dd.getMetaValues());
        this.ipw.print(dd.getName());
        if (dd.getType() instanceof TypeAlias && ((TypeAlias)dd.getType()).getAliasing() == this.td.INTERLIS.INTERLIS_1_DATE) {
            Domain dd2 = ((TypeAlias)dd.getType()).getAliasing();
            this.printModifiers(dd2.isAbstract(), dd2.isFinal(), false, false, false, false);
            this.ipw.print(" = ");
            this.printType(scope, dd2.getType());
            this.ipw.println(';');
        } else {
            this.printModifiers(dd.isAbstract(), dd.isFinal(), false, false, false, false);
            if (extending != null) {
                this.ipw.print(" EXTENDS ");
                this.printRef(scope, extending);
            }
            this.ipw.print(" = ");
            this.printType(scope, dd.getType());
            if (dd.getType() instanceof StructuredUnitType) {
                EhiLogger.logError("DOMAIN " + dd.getName() + ": StructuredUnitType not supported by INTERLIS 2.3; replace by TextType or FormattedType/XMLDate");
                this.ipw.println("; !! Hint: replace by TextType or FormattedType/XMLDate");
            } else {
                this.ipw.println(';');
            }
        }
    }

    public void printReferenceSysRef(Container scope, RefSystemRef rsr) {
        if (rsr == null) {
            this.printError();
            return;
        }
        if (rsr instanceof RefSystemRef.CoordSystem) {
            RefSystemRef.CoordSystem cs = (RefSystemRef.CoordSystem)rsr;
            this.ipw.print('{');
            this.printRef(scope, cs.getSystem());
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordSystemAxis) {
            RefSystemRef.CoordSystemAxis csa = (RefSystemRef.CoordSystemAxis)rsr;
            this.ipw.print('{');
            this.printRef(scope, csa.getSystem());
            this.ipw.print('[');
            this.ipw.print(csa.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordDomain) {
            RefSystemRef.CoordDomain cda = (RefSystemRef.CoordDomain)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain());
            this.ipw.print('>');
        } else if (rsr instanceof RefSystemRef.CoordDomainAxis) {
            RefSystemRef.CoordDomainAxis cda = (RefSystemRef.CoordDomainAxis)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain());
            this.ipw.print('[');
            this.ipw.print(cda.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('>');
        } else {
            this.printError();
        }
    }

    public void printType(Container scope, Type dd) {
        if (dd == null) {
            this.printError();
            return;
        }
        if (dd.isMandatory() && !(dd instanceof CompositionType)) {
            this.ipw.print("MANDATORY ");
        }
        if (dd instanceof NumericalType) {
            this.printNumericalType(scope, (NumericalType)dd);
        } else if (dd instanceof TextType) {
            int len = ((TextType)dd).getMaxLength();
            if (((TextType)dd).isNormalized()) {
                this.ipw.print("TEXT");
            } else {
                this.ipw.print("MTEXT");
            }
            if (len != -1) {
                this.ipw.print('*');
                this.ipw.print(len);
            }
        } else if (dd instanceof FormattedType) {
            FormattedType ft = (FormattedType)dd;
            if (ft.getDefinedBaseStruct() != null) {
                this.ipw.print("FORMAT BASED ON ");
                this.printRef(scope, ft.getDefinedBaseStruct());
                Iterator<FormattedTypeBaseAttrRef> baseAttri = ft.iteratorDefinedBaseAttrRef();
                if (baseAttri.hasNext()) {
                    this.ipw.print(" (");
                    String sep = "";
                    if (ft.getExtending() != null) {
                        this.ipw.print("INHERITANCE");
                        sep = " ";
                    }
                    if (ft.getDefinedPrefix() != null) {
                        this.ipw.print("\"" + ft.getDefinedPrefix() + "\"");
                        sep = " ";
                    }
                    while (baseAttri.hasNext()) {
                        this.ipw.print(sep);
                        FormattedTypeBaseAttrRef baseAttr = baseAttri.next();
                        if (baseAttr.getFormatted() != null) {
                            this.ipw.print(baseAttr.getAttr().getName());
                            this.ipw.print("/");
                            this.printRef(scope, baseAttr.getFormatted());
                        } else {
                            this.ipw.print(baseAttr.getAttr().getName());
                            if (baseAttr.getIntPos() != 0) {
                                this.ipw.print("/");
                                this.ipw.print(baseAttr.getIntPos());
                            }
                        }
                        if (baseAttr.getPostfix() != null) {
                            this.ipw.print(" \"" + baseAttr.getPostfix() + "\"");
                        }
                        sep = " ";
                    }
                    this.ipw.print(")");
                }
                if (ft.getDefinedMinimum() != null) {
                    this.ipw.print(" ");
                    this.printFormatedTypeMinMax(ft);
                }
            } else if (ft.getDefinedBaseDomain() != null) {
                this.ipw.print("FORMAT ");
                this.printRef(scope, ft.getDefinedBaseDomain());
                this.ipw.print(" ");
                this.printFormatedTypeMinMax(ft);
            } else {
                this.printFormatedTypeMinMax(ft);
            }
        } else if (dd instanceof EnumerationType) {
            EnumerationType et = (EnumerationType)dd;
            this.printEnumeration(et.getEnumeration());
            if (et.isCircular()) {
                this.ipw.print(" CIRCULAR");
            } else if (et.isOrdered()) {
                this.ipw.print(" ORDERED");
            }
        } else if (dd instanceof EnumTreeValueType) {
            EnumTreeValueType et = (EnumTreeValueType)dd;
            this.ipw.print("ALL OF ");
            this.printRef(scope, et.getEnumType());
        } else if (dd instanceof EnumValType) {
            if (((EnumValType)dd).isOnlyLeafs()) {
                this.ipw.print("ENUMVAL");
            } else {
                this.ipw.print("ENUMTREEVAL");
            }
        } else if (dd instanceof TypeAlias) {
            Domain def = ((TypeAlias)dd).getAliasing();
            if (def == this.modelInterlis.BOOLEAN) {
                this.ipw.print("BOOLEAN");
            } else if (def == this.modelInterlis.VALIGNMENT) {
                this.ipw.print("VALIGNMENT");
            } else if (def == this.modelInterlis.HALIGNMENT) {
                this.ipw.print("HALIGNMENT");
            } else {
                this.printRef(scope, ((TypeAlias)dd).getAliasing());
            }
        } else if (dd instanceof CompositionType) {
            CompositionType comp = (CompositionType)dd;
            Cardinality card = comp.getCardinality();
            if (card.getMaximum() == 1L) {
                if (card.getMinimum() == 1L) {
                    this.ipw.print("MANDATORY ");
                }
            } else {
                this.ipw.print(comp.isOrdered() ? "LIST " : "BAG ");
                this.ipw.print(card);
                this.ipw.print(' ');
                this.ipw.print("OF ");
            }
            this.printRef(scope, comp.getComponentType());
        } else if (dd instanceof ReferenceType) {
            ReferenceType ref = (ReferenceType)dd;
            this.ipw.print("REFERENCE TO ");
            if (ref.isExternal()) {
                this.ipw.print("(EXTERNAL) ");
            }
            this.printRef(scope, ref.getReferred());
            Iterator<AbstractClassDef> resti = ref.iteratorRestrictedTo();
            String sep = " RESTRICTION (";
            boolean hasRestriction = false;
            while (resti.hasNext()) {
                AbstractClassDef rest = resti.next();
                this.ipw.print(sep);
                sep = ";";
                this.printRef(scope, rest);
                hasRestriction = true;
            }
            if (hasRestriction) {
                this.ipw.print(")");
            }
        } else if (dd instanceof CoordType) {
            NumericalType[] nts = ((CoordType)dd).getDimensions();
            int nullAxis = ((CoordType)dd).getNullAxis();
            int piHalfAxis = ((CoordType)dd).getPiHalfAxis();
            this.ipw.print("COORD ");
            this.ipw.indent();
            for (int i = 0; i < nts.length; ++i) {
                if (i > 0) {
                    this.ipw.print(", ");
                }
                this.printNumericalType(scope, nts[i]);
            }
            if (nullAxis != 0) {
                this.ipw.println(',');
                this.ipw.print("ROTATION ");
                this.ipw.print(nullAxis);
                this.ipw.print(" -> ");
                if (piHalfAxis > 0) {
                    this.ipw.print(piHalfAxis);
                } else {
                    this.printError();
                }
            }
            this.ipw.unindent();
        } else if (dd instanceof LineType) {
            LineType lt = (LineType)dd;
            if (lt instanceof PolylineType) {
                this.ipw.print(((PolylineType)lt).isDirected() ? "DIRECTED POLYLINE" : "POLYLINE");
            } else if (lt instanceof SurfaceType) {
                this.ipw.print("SURFACE");
            } else if (lt instanceof AreaType) {
                this.ipw.print("AREA");
            } else {
                this.printError();
            }
            LineForm[] lineForms = lt.getLineForms();
            PrecisionDecimal maxOverlap = lt.getMaxOverlap();
            Domain controlPointDomain = lt.getControlPointDomain();
            Table lineAttributeStructure = null;
            if (lt instanceof SurfaceOrAreaType) {
                lineAttributeStructure = ((SurfaceOrAreaType)lt).getLineAttributeStructure();
            }
            this.ipw.indent();
            boolean needNewLine = false;
            if (lineForms.length > 0) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print(" WITH (");
                for (int i = 0; i < lineForms.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    this.ipw.print(lineForms[i].getName());
                }
                this.ipw.print(')');
                needNewLine = true;
            }
            if (controlPointDomain != null) {
                this.ipw.print(" VERTEX ");
                this.printRef(scope, controlPointDomain);
                needNewLine = true;
            }
            if (maxOverlap != null) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print("WITHOUT OVERLAPS > ");
                this.ipw.print(maxOverlap.toString());
            }
            if (lineAttributeStructure != null) {
                this.ipw.println();
                this.ipw.print("LINE ATTRIBUTES ");
                this.printRef(scope, lineAttributeStructure);
            }
            this.ipw.unindent();
        } else if (dd instanceof OIDType) {
            Type type = ((OIDType)dd).getOIDType();
            if (type == null) {
                this.ipw.print("OID ANY");
            } else {
                this.ipw.print("OID ");
                this.printType(scope, type);
            }
        } else if (dd instanceof BlackboxType) {
            BlackboxType bt = (BlackboxType)dd;
            this.ipw.print("BLACKBOX");
            int kind = bt.getKind();
            if (kind == 1) {
                this.ipw.print(" XML");
            } else if (kind == 2) {
                this.ipw.print(" BINARY");
            }
        } else if (dd instanceof BasketType) {
            BasketType bt = (BasketType)dd;
            this.ipw.print("BASKET");
            int kind = bt.getKind();
            if (kind == 16) {
                this.ipw.print(" (DATA)");
            } else if (kind == 32) {
                this.ipw.print(" (VIEW)");
            } else if (kind == 64) {
                this.ipw.print(" (BASE)");
            } else if (kind == 128) {
                this.ipw.print(" (GRAPHIC)");
            }
            Topic spec = bt.getTopic();
            if (spec != null) {
                this.ipw.print(" OF ");
                this.printRef(scope, spec);
            }
        } else if (dd instanceof ClassType) {
            ClassType ct = (ClassType)dd;
            if (ct.isStructure()) {
                this.ipw.print("STRUCTURE");
            } else {
                this.ipw.print("CLASS");
            }
            String next = " RESTRICTED TO ";
            Iterator<Viewable<?>> resti = ct.iteratorRestrictedTo();
            while (resti.hasNext()) {
                Table rest = (Table)resti.next();
                this.ipw.print(next);
                this.printRef(scope, rest);
                next = " ,";
            }
        } else if (dd instanceof AttributePathType) {
            AttributePathType ct = (AttributePathType)dd;
            this.ipw.print("ATTRIBUTE");
            FormalArgument argRestr = ct.getArgRestriction();
            ObjectPath attrRestr = ct.getAttrRestriction();
            if (argRestr != null) {
                this.ipw.print(" OF @ ");
                this.ipw.print(argRestr.getName());
            } else if (attrRestr != null) {
                this.ipw.print(" OF ");
                this.printAttributePath(scope, attrRestr);
            }
            Type[] typeRestr = ct.getTypeRestriction();
            if (typeRestr != null) {
                this.ipw.print(" RESTRICTION ( ");
                String sep = "";
                for (int typei = 0; typei < typeRestr.length; ++typei) {
                    this.ipw.print(sep);
                    this.printType(scope, typeRestr[typei]);
                    sep = ";";
                }
                this.ipw.print(" )");
            }
        } else if (dd instanceof ObjectType) {
            ObjectType ot = (ObjectType)dd;
            if (ot.isObjects()) {
                this.ipw.print("OBJECTS OF ");
            } else {
                this.ipw.print("OBJECT OF ");
            }
            Viewable ref = ot.getRef();
            this.printRef(scope, ref);
        } else if (dd instanceof MetaobjectType) {
            MetaobjectType ot = (MetaobjectType)dd;
            this.ipw.print("METAOBJECT");
            Table ref = ot.getReferred();
            if (ref != scope) {
                this.ipw.print(" OF ");
                this.printRef(scope, ref);
            }
        }
    }

    private void printFormatedTypeMinMax(FormattedType ft) {
        this.ipw.print("\"");
        this.ipw.print(ft.getDefinedMinimum());
        this.ipw.print("\" .. \"");
        this.ipw.print(ft.getDefinedMaximum());
        this.ipw.print("\"");
    }

    protected void printNumericalType(Container scope, NumericalType type) {
        if (type == null) {
            this.printError();
            return;
        }
        if (type instanceof NumericType) {
            NumericType ntyp = (NumericType)type;
            PrecisionDecimal min = ntyp.getMinimum();
            PrecisionDecimal max = ntyp.getMaximum();
            if (min == null) {
                this.ipw.print("NUMERIC");
            } else {
                this.ipw.print(min.toString());
                this.ipw.print(" .. ");
                this.ipw.print(max.toString());
            }
        } else if (type instanceof StructuredUnitType) {
            this.ipw.print(((StructuredUnitType)type).getMinimum().toString());
            this.ipw.print(" .. ");
            this.ipw.print(((StructuredUnitType)type).getMaximum().toString());
        }
        if (type.isCircular()) {
            this.ipw.print(" CIRCULAR");
        }
        if (type.getUnit() != null) {
            this.ipw.print(" [");
            this.ipw.print(type.getUnit().getScopedName(scope));
            this.ipw.print(']');
        }
        switch (type.getRotation()) {
            case 2: {
                this.ipw.print(" COUNTERCLOCKWISE");
                break;
            }
            case 1: {
                this.ipw.print(" CLOCKWISE");
            }
        }
        if (type.getReferenceSystem() != null) {
            this.ipw.print(' ');
            this.printReferenceSysRef(scope, type.getReferenceSystem());
        }
    }

    protected void printEnumeration(Enumeration enumer) {
        this.ipw.println('(');
        this.ipw.indent();
        if (enumer == null) {
            this.printError();
        } else {
            Iterator<Enumeration.Element> iter = enumer.getElements();
            while (iter.hasNext()) {
                this.printEnumerationElement(iter.next());
                if (!iter.hasNext()) continue;
                this.ipw.println(',');
            }
        }
        this.ipw.unindent();
        this.ipw.print(')');
    }

    protected void printEnumerationElement(Enumeration.Element ee) {
        this.printDocumentation(ee.getDocumentation());
        this.printMetaValues(ee.getMetaValues());
        this.ipw.print(ee.getName());
        Enumeration subEnum = ee.getSubEnumeration();
        if (subEnum != null) {
            this.ipw.print(' ');
            this.printEnumeration(subEnum);
        }
    }

    public void printLineFormTypeDef(Container scope, LineForm lf) {
        if (lf == null) {
            this.printError();
            return;
        }
        this.printDocumentation(lf.getDocumentation());
        this.printMetaValues(lf.getMetaValues());
        this.ipw.print(lf.getName());
        String explanation = lf.getExplanation();
        if (explanation != null) {
            this.ipw.print(' ');
            this.printExplanation(explanation);
        }
        this.ipw.println(';');
    }

    public void printFunctionDeclaration(Container scope, Function f) {
        if (f == null) {
            this.printError();
            return;
        }
        this.printDocumentation(f.getDocumentation());
        this.printMetaValues(f.getMetaValues());
        this.ipw.print("FUNCTION ");
        this.ipw.print(f.getName());
        this.ipw.print("(");
        FormalArgument[] args = f.getArguments();
        if (args == null) {
            this.printError();
        } else {
            String sep = " ";
            for (int i = 0; i < args.length; ++i) {
                this.ipw.print(sep + args[i].getName() + " : ");
                this.printType(scope, args[i].getType());
                sep = "; ";
            }
        }
        this.ipw.print(") : ");
        this.printType(scope, f.getDomain());
        String explanation = f.getExplanation();
        if (explanation != null) {
            this.printExplanation(explanation);
        }
        this.ipw.println(';');
    }

    protected void printAttributeRefs(AttributeRef[] refs) {
        if (refs == null) {
            this.printError();
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            if (i > 0) {
                this.ipw.print('.');
            }
            if (refs[i] == null) {
                this.printError();
                continue;
            }
            this.ipw.print(refs[i].getName());
        }
    }

    protected void printAttributePath(Container scope, ObjectPath path) {
        if (path == null) {
            this.printError();
            return;
        }
        PathEl[] elv = path.getPathElements();
        String sep = "";
        for (int i = 0; i < elv.length; ++i) {
            this.ipw.print(sep);
            sep = "->";
            this.ipw.print(elv[i].getName());
        }
    }

    protected void printElements(Container container) {
        Class lastClass = null;
        for (Element elt : container) {
            lastClass = this.printElement(container, lastClass, elt);
        }
    }

    protected Class printElement(Container container, Class lastClass, Element elt) {
        if (elt instanceof AttributeDef) {
            this.printAttribute(container, (AttributeDef)elt);
            lastClass = AttributeDef.class;
        } else if (elt instanceof RoleDef) {
            this.printRoleDef(container, (RoleDef)elt);
            lastClass = RoleDef.class;
        } else if (elt instanceof Function) {
            if (lastClass != null && lastClass != Function.class) {
                this.ipw.println();
            }
            this.printFunctionDeclaration(container, (Function)elt);
            lastClass = Function.class;
        } else if (elt instanceof Parameter) {
            if (lastClass != Parameter.class) {
                this.ipw.println("PARAMETER");
            }
            this.printParameter(container, (Parameter)elt);
            lastClass = Parameter.class;
        } else if (elt instanceof Domain) {
            if (lastClass != Domain.class) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.ipw.println("DOMAIN");
            }
            this.ipw.indent();
            this.printDomainDef(container, (Domain)elt);
            this.ipw.unindent();
            lastClass = Domain.class;
        } else if (elt instanceof LineForm) {
            if (lastClass != LineForm.class) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.ipw.println("LINE FORM");
            }
            this.ipw.indent();
            this.printLineFormTypeDef(container, (LineForm)elt);
            this.ipw.unindent();
            lastClass = LineForm.class;
        } else if (elt instanceof Unit) {
            if (lastClass != Unit.class) {
                if (lastClass != null) {
                    this.ipw.println();
                }
                this.ipw.println("UNIT");
            }
            this.ipw.indent();
            this.printUnit(container, (Unit)elt);
            this.ipw.unindent();
            lastClass = Unit.class;
        } else if (elt instanceof Model) {
            if (this.withPredefined || !(elt instanceof PredefinedModel)) {
                this.ipw.println();
                this.printModel((Model)elt);
                lastClass = Model.class;
            }
        } else if (elt instanceof Topic) {
            this.ipw.println();
            this.ipw.println();
            this.printTopic((Topic)elt);
            lastClass = Topic.class;
        } else if (elt instanceof MetaDataUseDef) {
            this.ipw.println();
            this.printMetaDataUseDef((MetaDataUseDef)elt);
            lastClass = MetaDataUseDef.class;
        } else if (elt instanceof Table) {
            if (!((Table)elt).isImplicit()) {
                this.ipw.println();
                this.printAbstractClassDef((Table)elt);
                lastClass = AbstractClassDef.class;
            }
        } else if (elt instanceof AssociationDef) {
            this.ipw.println();
            this.printAbstractClassDef((AssociationDef)elt);
            lastClass = AbstractClassDef.class;
        } else if (elt instanceof View) {
            if (lastClass != null) {
                this.ipw.println();
            }
            this.printView((View)elt);
            lastClass = View.class;
        } else if (elt instanceof Graphic) {
            if (lastClass != null) {
                this.ipw.println();
            }
            this.printGraphic((Graphic)elt);
            lastClass = Graphic.class;
        } else if (elt instanceof Constraint) {
            if (((Constraint)elt).isSelfStanding()) {
                this.selfStandingConstraints.add(elt);
            } else {
                this.printConstraint((Constraint)elt);
                lastClass = Constraint.class;
            }
        } else if (elt instanceof ExpressionSelection) {
            if (lastClass != null) {
                this.ipw.println();
            }
            this.ipw.println("WHERE");
            this.ipw.indent();
            this.printExpression(((ExpressionSelection)elt).getSelected(), ((ExpressionSelection)elt).getCondition());
            this.ipw.println(';');
            this.ipw.unindent();
            lastClass = ExpressionSelection.class;
        } else if (elt instanceof SignAttribute) {
            if (lastClass != SignAttribute.class && lastClass != null) {
                this.ipw.println();
            }
            this.printSignAttribute((Graphic)container, (SignAttribute)elt);
            lastClass = SignAttribute.class;
        }
        return lastClass;
    }

    protected void printTransferDescription(TransferDescription td) {
        this.ipw.println("INTERLIS 2.3;");
        this.ipw.unindent();
        this.ipw.println();
        this.printElements(td);
    }
}

