/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.ObjectWriterWrapper;
import com.ibm.xmi.framework.ProxyNotResolvableException;
import com.ibm.xmi.framework.Value;
import com.ibm.xmi.framework.Workspace;
import com.ibm.xmi.framework.XMIContainer;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMILoad;
import com.ibm.xmi.framework.XMIObject;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class XMIFiles {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Workspace workspace;
    private Vector files;
    private XMIContainer allData;
    private String filepath;
    private boolean demandLoad = true;
    private HashMap hrefsToObjects;
    private ObjectWriterWrapper wrapper = new ObjectWriterWrapper(AdapterFactoryRegister.getAdapterFactory().createObjectWriterAdapter());

    void add(XMIFile xMIFile) {
        if (this.files == null) {
            this.files = new Vector();
        }
        this.files.addElement(xMIFile);
    }

    public XMIObject get(String string) {
        int n;
        if (string == null || this.allData == null) {
            return null;
        }
        XMIObject xMIObject = this.allData.get(string);
        if (xMIObject == null && (n = string.indexOf("#")) != -1) {
            if (this.hrefsToObjects == null) {
                this.makeHrefsToObjects(this.allData.getObjects().iterator());
            }
            xMIObject = this.getObjectFromHrefsToObjects(string, n);
        }
        return xMIObject;
    }

    private XMIObject getObjectFromHrefsToObjects(String string, int n) {
        if (this.hrefsToObjects == null) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        HashMap hashMap = (HashMap)this.hrefsToObjects.get(string2);
        if (hashMap == null) {
            return null;
        }
        return (XMIObject)hashMap.get(string3);
    }

    private void makeHrefsToObjects(Iterator iterator) {
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            this.makeHrefToObject(xMIObject);
            if (xMIObject.isXMIProxy()) continue;
            Collection collection = this.getReferencedProxies(xMIObject);
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                this.makeHrefToObject((XMIObject)iterator2.next());
            }
        }
    }

    private void makeHrefToObject(XMIObject xMIObject) {
        if (!xMIObject.isXMIProxy() && xMIObject.getXMIFile() != null && xMIObject.getXMIId() != null) {
            String string = xMIObject.getXMIFile().getEntry();
            if (string == null) {
                string = xMIObject.getXMIFile().getLoadFilename();
            }
            if (string == null) {
                string = xMIObject.getXMIFile().getFilename();
            }
            this.addToHrefsToObjects(string, xMIObject.getXMIId(), xMIObject);
        } else if (xMIObject.isXMIProxy() && xMIObject.getXMIUUID() == null && xMIObject.getXMIHref() != null) {
            int n = xMIObject.getXMIHref().indexOf("#");
            String string = null;
            String string2 = null;
            if (n != -1) {
                string2 = xMIObject.getXMIHref().substring(n + 1);
                string = xMIObject.getXMIHref().substring(0, n);
            }
            this.addToHrefsToObjects(string, string2, xMIObject);
        }
    }

    private Collection getReferencedProxies(XMIObject xMIObject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Collection collection = xMIObject.getXMIValues();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (value.getXMIType() != 2 && value.getXMIType() != 3) continue;
            Object object = value.getXMIValue();
            if (object instanceof XMIObject) {
                if (!((XMIObject)object).isXMIProxy()) continue;
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof Collection)) continue;
            Iterator iterator2 = ((Collection)object).iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!(e instanceof XMIObject) || !((XMIObject)e).isXMIProxy()) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    private void addToHrefsToObjects(String string, String string2, XMIObject xMIObject) {
        HashMap hashMap;
        if (this.hrefsToObjects == null) {
            this.hrefsToObjects = new HashMap();
        }
        if (string == null || string2 == null) {
            return;
        }
        if (this.hrefsToObjects.get(string) == null) {
            hashMap = new HashMap();
            this.hrefsToObjects.put(string, hashMap);
        }
        hashMap = (HashMap)this.hrefsToObjects.get(string);
        hashMap.put(string2, xMIObject);
    }

    public XMIContainer getContainer() {
        return this.allData;
    }

    public boolean isDemandLoad() {
        return this.demandLoad;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public Collection getFiles() {
        if (this.files == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.files);
    }

    private Vector getProxies() {
        Vector<XMIObject> vector = new Vector<XMIObject>();
        if (this.allData == null) {
            return vector;
        }
        Iterator iterator = this.allData.getObjects().iterator();
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            if (!xMIObject.isXMIProxy()) continue;
            vector.add(xMIObject);
        }
        return vector;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    private boolean isContained(XMIObject xMIObject, XMIObject xMIObject2) {
        if (xMIObject.isXMIProxy()) {
            return false;
        }
        ArrayList arrayList = this.wrapper.getContained(xMIObject);
        if (arrayList.contains(xMIObject2)) {
            return true;
        }
        int n = 0;
        while (n < arrayList.size()) {
            if (this.isContained((XMIObject)arrayList.get(n), xMIObject2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isContained(XMIObject xMIObject, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            if (this.isContained((XMIObject)vector.elementAt(n), xMIObject)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public XMIFile load(String string, int n, boolean bl) throws Exception {
        return this.load(string, null, n, bl);
    }

    public XMIFile load(String string, InputStream inputStream, int n, boolean bl) throws Exception {
        XMILoad xMILoad = new XMILoad(string, inputStream, n, bl, this);
        XMIFile xMIFile = xMILoad.load();
        if (this.allData == null) {
            this.allData = new XMIContainer(xMIFile.getObjects().iterator());
        } else {
            this.makeNewContainer(xMIFile.getObjects().iterator());
            XMIContainer xMIContainer = new XMIContainer(xMIFile.getObjects().iterator());
            this.makeHrefsToObjects(xMIContainer.getObjects().iterator());
        }
        return xMIFile;
    }

    public void loadAll() {
        Vector vector = new Vector();
        HashSet<XMIObject> hashSet = new HashSet<XMIObject>();
        vector = this.getProxies();
        while (!vector.isEmpty()) {
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                XMIObject xMIObject = (XMIObject)iterator.next();
                if (hashSet.contains(xMIObject)) {
                    throw new ProxyNotResolvableException(xMIObject);
                }
                hashSet.add(xMIObject);
                xMIObject.getXMIValues();
            }
            vector = this.getProxies();
        }
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private void makeNewContainer(Iterator iterator) {
        Vector vector = new Vector();
        Iterator iterator2 = this.allData.getTopObjects().iterator();
        while (iterator2.hasNext()) {
            vector.addElement(iterator2.next());
        }
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            if (xMIObject.getXMIUUID() != null && this.allData.get(xMIObject.getXMIUUID()) != null) continue;
            vector.addElement(xMIObject);
        }
        vector = this.removeContained(vector);
        this.allData = new XMIContainer(((AbstractList)vector).iterator());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Specify a file name.");
            return;
        }
        XMIFiles xMIFiles = new XMIFiles();
        try {
            XMIFile xMIFile = xMIFiles.load(stringArray[0], 1, false);
            System.out.println("xmi version:     " + xMIFile.getXMIVersion());
            System.out.println("timestamp:       " + xMIFile.getTimestamp());
            System.out.println("exporter:        " + xMIFile.getExporter());
            System.out.println("exporterVersion: " + xMIFile.getExporterVersion());
            System.out.println("");
            XMIContainer xMIContainer = new XMIContainer(xMIFile.getObjects().iterator());
            System.out.println(xMIContainer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Vector removeContained(Vector vector) {
        Vector<XMIObject> vector2 = new Vector<XMIObject>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(n);
            if (!this.isContained(xMIObject, vector)) {
                vector2.addElement(xMIObject);
            }
            ++n;
        }
        return vector2;
    }

    public void setDemandLoad(boolean bl) {
        this.demandLoad = bl;
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }
}

