/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.record.loop.examples;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import org.freehep.record.loop.LoopException;
import org.freehep.record.loop.SequentialRecordLoopImpl;
import org.freehep.record.loop.event.ChainableRecordListenerDecorator;
import org.freehep.record.loop.event.RecordAdapter;
import org.freehep.record.loop.event.RecordSuppliedEvent;
import org.freehep.record.loop.examples.EchoStrings;

public class Strings2Words
extends RecordAdapter {
    public void recordSupplied(RecordSuppliedEvent event) {
        EchoStrings.StringsData stringsData = (EchoStrings.StringsData)event.getRecord();
        String[] strings = stringsData.getStrings();
        int tokenCount = 0;
        int finished = strings.length;
        for (int string = 0; finished != string; ++string) {
            StringTokenizer tokenizer = new StringTokenizer(strings[string]);
            tokenCount += tokenizer.countTokens();
        }
        String[] results = new String[tokenCount];
        int result = 0;
        for (int string = 0; finished != string; ++string) {
            StringTokenizer tokenizer = new StringTokenizer(strings[string]);
            while (tokenizer.hasMoreTokens()) {
                results[result] = tokenizer.nextToken();
                ++result;
            }
        }
        stringsData.setStrings(results);
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (0 == args.length) {
            System.err.println("Filename must be specified.");
            return;
        }
        EchoStrings echoStrings = new EchoStrings();
        Strings2Words echoWords = new Strings2Words();
        ChainableRecordListenerDecorator listener = new ChainableRecordListenerDecorator(echoWords);
        try {
            listener.addRecordListener(echoStrings);
        }
        catch (TooManyListenersException e) {
            // empty catch block
        }
        EchoStrings echoStrings2 = echoStrings;
        echoStrings2.getClass();
        EchoStrings.LineSupplier supplier = echoStrings2.new EchoStrings.LineSupplier(args[0]);
        SequentialRecordLoopImpl recordLoop = new SequentialRecordLoopImpl(supplier);
        try {
            recordLoop.addRecordListener(listener);
            long count = 1 < args.length ? (long)Integer.parseInt(args[1]) : -1L;
            long processed = recordLoop.loop(count);
            System.out.println("Processed " + processed + " lines.");
        }
        catch (TooManyListenersException e) {
        }
        catch (LoopException e1) {
            System.err.println("Loop failed:\n" + e1.toString());
        }
        catch (IOException e3) {
            System.err.println("An IOException was thrown.");
        }
    }
}

