/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.tasks.RecordReaper;
import javax.jmdns.impl.tasks.Responder;
import javax.jmdns.impl.tasks.resolver.ServiceInfoResolver;
import javax.jmdns.impl.tasks.resolver.ServiceResolver;
import javax.jmdns.impl.tasks.resolver.TypeResolver;
import javax.jmdns.impl.tasks.state.Announcer;
import javax.jmdns.impl.tasks.state.Canceler;
import javax.jmdns.impl.tasks.state.Prober;
import javax.jmdns.impl.tasks.state.Renewer;

public interface DNSTaskStarter {
    public void purgeTimer();

    public void purgeStateTimer();

    public void cancelTimer();

    public void cancelStateTimer();

    public void startProber();

    public void startAnnouncer();

    public void startRenewer();

    public void startCanceler();

    public void startReaper();

    public void startServiceInfoResolver(ServiceInfoImpl var1);

    public void startTypeResolver();

    public void startServiceResolver(String var1);

    public void startResponder(DNSIncoming var1, int var2);

    public static final class DNSTaskStarterImpl
    implements DNSTaskStarter {
        private final JmDNSImpl _jmDNSImpl;
        private final Timer _timer;
        private final Timer _stateTimer;

        public DNSTaskStarterImpl(JmDNSImpl jmDNSImpl) {
            this._jmDNSImpl = jmDNSImpl;
            this._timer = new StarterTimer("JmDNS(" + this._jmDNSImpl.getName() + ").Timer", true);
            this._stateTimer = new StarterTimer("JmDNS(" + this._jmDNSImpl.getName() + ").State.Timer", false);
        }

        @Override
        public void purgeTimer() {
            this._timer.purge();
        }

        @Override
        public void purgeStateTimer() {
            this._stateTimer.purge();
        }

        @Override
        public void cancelTimer() {
            this._timer.cancel();
        }

        @Override
        public void cancelStateTimer() {
            this._stateTimer.cancel();
        }

        @Override
        public void startProber() {
            new Prober(this._jmDNSImpl).start(this._stateTimer);
        }

        @Override
        public void startAnnouncer() {
            new Announcer(this._jmDNSImpl).start(this._stateTimer);
        }

        @Override
        public void startRenewer() {
            new Renewer(this._jmDNSImpl).start(this._stateTimer);
        }

        @Override
        public void startCanceler() {
            new Canceler(this._jmDNSImpl).start(this._stateTimer);
        }

        @Override
        public void startReaper() {
            new RecordReaper(this._jmDNSImpl).start(this._timer);
        }

        @Override
        public void startServiceInfoResolver(ServiceInfoImpl info) {
            new ServiceInfoResolver(this._jmDNSImpl, info).start(this._timer);
        }

        @Override
        public void startTypeResolver() {
            new TypeResolver(this._jmDNSImpl).start(this._timer);
        }

        @Override
        public void startServiceResolver(String type) {
            new ServiceResolver(this._jmDNSImpl, type).start(this._timer);
        }

        @Override
        public void startResponder(DNSIncoming in, int port) {
            new Responder(this._jmDNSImpl, in, port).start(this._timer);
        }

        public static class StarterTimer
        extends Timer {
            private volatile boolean _cancelled = false;

            public StarterTimer() {
            }

            public StarterTimer(boolean isDaemon) {
                super(isDaemon);
            }

            public StarterTimer(String name, boolean isDaemon) {
                super(name, isDaemon);
            }

            public StarterTimer(String name) {
                super(name);
            }

            @Override
            public synchronized void cancel() {
                if (this._cancelled) {
                    return;
                }
                this._cancelled = true;
                super.cancel();
            }

            @Override
            public synchronized void schedule(TimerTask task, long delay) {
                if (this._cancelled) {
                    return;
                }
                super.schedule(task, delay);
            }

            @Override
            public synchronized void schedule(TimerTask task, Date time) {
                if (this._cancelled) {
                    return;
                }
                super.schedule(task, time);
            }

            @Override
            public synchronized void schedule(TimerTask task, long delay, long period) {
                if (this._cancelled) {
                    return;
                }
                super.schedule(task, delay, period);
            }

            @Override
            public synchronized void schedule(TimerTask task, Date firstTime, long period) {
                if (this._cancelled) {
                    return;
                }
                super.schedule(task, firstTime, period);
            }

            @Override
            public synchronized void scheduleAtFixedRate(TimerTask task, long delay, long period) {
                if (this._cancelled) {
                    return;
                }
                super.scheduleAtFixedRate(task, delay, period);
            }

            @Override
            public synchronized void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
                if (this._cancelled) {
                    return;
                }
                super.scheduleAtFixedRate(task, firstTime, period);
            }
        }
    }

    public static final class Factory {
        private static volatile Factory _instance;
        private final ConcurrentMap<JmDNSImpl, DNSTaskStarter> _instances = new ConcurrentHashMap<JmDNSImpl, DNSTaskStarter>(20);
        private static final AtomicReference<ClassDelegate> _databaseClassDelegate;

        private Factory() {
        }

        public static void setClassDelegate(ClassDelegate delegate) {
            _databaseClassDelegate.set(delegate);
        }

        public static ClassDelegate classDelegate() {
            return _databaseClassDelegate.get();
        }

        protected static DNSTaskStarter newDNSTaskStarter(JmDNSImpl jmDNSImpl) {
            DNSTaskStarter instance = null;
            ClassDelegate delegate = _databaseClassDelegate.get();
            if (delegate != null) {
                instance = delegate.newDNSTaskStarter(jmDNSImpl);
            }
            return instance != null ? instance : new DNSTaskStarterImpl(jmDNSImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Factory getInstance() {
            if (_instance != null) return _instance;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (_instance != null) return _instance;
                _instance = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return _instance;
            }
        }

        public DNSTaskStarter getStarter(JmDNSImpl jmDNSImpl) {
            DNSTaskStarter starter = (DNSTaskStarter)this._instances.get(jmDNSImpl);
            if (starter == null) {
                this._instances.putIfAbsent(jmDNSImpl, Factory.newDNSTaskStarter(jmDNSImpl));
                starter = (DNSTaskStarter)this._instances.get(jmDNSImpl);
            }
            return starter;
        }

        static {
            _databaseClassDelegate = new AtomicReference();
        }

        public static interface ClassDelegate {
            public DNSTaskStarter newDNSTaskStarter(JmDNSImpl var1);
        }
    }
}

