/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.security.SignatureException;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;

public class SignatureRSA
extends AbstractSignature {
    public SignatureRSA() {
        super("SHA1withRSA");
    }

    @Override
    public byte[] sign() {
        try {
            return this.signature.sign();
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public boolean verify(byte[] sig) {
        sig = this.extractSig(sig);
        try {
            return this.signature.verify(sig);
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public static class Factory
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureRSA();
        }

        @Override
        public String getName() {
            return KeyType.RSA.toString();
        }
    }
}

