/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Heartbeater
extends Thread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TransportImpl trans;
    private int interval;

    Heartbeater(TransportImpl trans) {
        this.trans = trans;
        this.setName("heartbeater");
    }

    synchronized void setInterval(int interval) {
        this.interval = interval;
        if (interval > 0 && this.getState() == Thread.State.NEW) {
            this.start();
        }
        this.notify();
    }

    synchronized int getInterval() {
        return this.interval;
    }

    private synchronized int getPositiveInterval() throws InterruptedException {
        while (this.interval <= 0) {
            this.wait();
        }
        return this.interval;
    }

    @Override
    public void run() {
        block4: {
            this.log.debug("Starting");
            try {
                while (!this.isInterrupted()) {
                    int hi = this.getPositiveInterval();
                    if (this.trans.isRunning()) {
                        this.log.debug("Sending heartbeat since {} seconds elapsed", (Object)hi);
                        this.trans.write(new SSHPacket(Message.IGNORE));
                    }
                    Thread.sleep(hi * 1000);
                }
            }
            catch (Exception e) {
                if (this.isInterrupted()) break block4;
                this.trans.die(e);
            }
        }
        this.log.debug("Stopping");
    }
}

