# Volatility
# Copyright (c) 2008-2013 Volatility Foundation
# Copyright (c) 2011 Michael Hale Ligh <michael.hale@gmail.com>
#
# This file is part of Volatility.
#
# Volatility is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Volatility is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Volatility.  If not, see <http://www.gnu.org/licenses/>.
#

syscalls = [
    [
    'NtAcceptConnectPort', # 0x0
    'NtAccessCheck', # 0x1
    'NtAccessCheckAndAuditAlarm', # 0x2
    'NtAccessCheckByType', # 0x3
    'NtAccessCheckByTypeAndAuditAlarm', # 0x4
    'NtAccessCheckByTypeResultList', # 0x5
    'NtAccessCheckByTypeResultListAndAuditAlarm', # 0x6
    'NtAccessCheckByTypeResultListAndAuditAlarmByHandle', # 0x7
    'NtAddAtom', # 0x8
    'NtAddBootEntry', # 0x9
    'NtAddDriverEntry', # 0xa
    'NtAdjustGroupsToken', # 0xb
    'NtAdjustPrivilegesToken', # 0xc
    'NtAlertResumeThread', # 0xd
    'NtAlertThread', # 0xe
    'NtAllocateLocallyUniqueId', # 0xf
    'NtAllocateUserPhysicalPages', # 0x10
    'NtAllocateUuids', # 0x11
    'NtAllocateVirtualMemory', # 0x12
    'NtAlpcAcceptConnectPort', # 0x13
    'NtAlpcCancelMessage', # 0x14
    'NtAlpcConnectPort', # 0x15
    'NtAlpcCreatePort', # 0x16
    'NtAlpcCreatePortSection', # 0x17
    'NtAlpcCreateResourceReserve', # 0x18
    'NtAlpcCreateSectionView', # 0x19
    'NtAlpcCreateSecurityContext', # 0x1a
    'NtAlpcDeletePortSection', # 0x1b
    'NtAlpcDeleteResourceReserve', # 0x1c
    'NtAlpcDeleteSectionView', # 0x1d
    'NtAlpcDeleteSecurityContext', # 0x1e
    'NtAlpcDisconnectPort', # 0x1f
    'NtAlpcImpersonateClientOfPort', # 0x20
    'NtAlpcOpenSenderProcess', # 0x21
    'NtAlpcOpenSenderThread', # 0x22
    'NtAlpcQueryInformation', # 0x23
    'NtAlpcQueryInformationMessage', # 0x24
    'NtAlpcRevokeSecurityContext', # 0x25
    'NtAlpcSendWaitReceivePort', # 0x26
    'NtAlpcSetInformation', # 0x27
    'NtApphelpCacheControl', # 0x28
    'NtAreMappedFilesTheSame', # 0x29
    'NtAssignProcessToJobObject', # 0x2a
    'NtCallbackReturn', # 0x2b
    'NtCancelDeviceWakeupRequest', # 0x2c
    'NtCancelIoFile', # 0x2d
    'NtCancelTimer', # 0x2e
    'NtClearEvent', # 0x2f
    'NtClose', # 0x30
    'NtCloseObjectAuditAlarm', # 0x31
    'NtCompactKeys', # 0x32
    'NtCompareTokens', # 0x33
    'NtCompleteConnectPort', # 0x34
    'NtCompressKey', # 0x35
    'NtConnectPort', # 0x36
    'NtContinue', # 0x37
    'NtCreateDebugObject', # 0x38
    'NtCreateDirectoryObject', # 0x39
    'NtCreateEvent', # 0x3a
    'NtCreateEventPair', # 0x3b
    'NtCreateFile', # 0x3c
    'NtCreateIoCompletion', # 0x3d
    'NtCreateJobObject', # 0x3e
    'NtCreateJobSet', # 0x3f
    'NtCreateKey', # 0x40
    'NtCreateKeyTransacted', # 0x41
    'NtCreateMailslotFile', # 0x42
    'NtCreateMutant', # 0x43
    'NtCreateNamedPipeFile', # 0x44
    'NtCreatePrivateNamespace', # 0x45
    'NtCreatePagingFile', # 0x46
    'NtCreatePort', # 0x47
    'NtCreateProcess', # 0x48
    'NtCreateProcessEx', # 0x49
    'NtCreateProfile', # 0x4a
    'NtCreateSection', # 0x4b
    'NtCreateSemaphore', # 0x4c
    'NtCreateSymbolicLinkObject', # 0x4d
    'NtCreateThread', # 0x4e
    'NtCreateTimer', # 0x4f
    'NtCreateToken', # 0x50
    'NtCreateTransaction', # 0x51
    'NtOpenTransaction', # 0x52
    'NtQueryInformationTransaction', # 0x53
    'NtQueryInformationTransactionManager', # 0x54
    'NtPrePrepareEnlistment', # 0x55
    'NtPrepareEnlistment', # 0x56
    'NtCommitEnlistment', # 0x57
    'NtReadOnlyEnlistment', # 0x58
    'NtRollbackComplete', # 0x59
    'NtRollbackEnlistment', # 0x5a
    'NtCommitTransaction', # 0x5b
    'NtRollbackTransaction', # 0x5c
    'NtPrePrepareComplete', # 0x5d
    'NtPrepareComplete', # 0x5e
    'NtCommitComplete', # 0x5f
    'NtSinglePhaseReject', # 0x60
    'NtSetInformationTransaction', # 0x61
    'NtSetInformationTransactionManager', # 0x62
    'NtSetInformationResourceManager', # 0x63
    'NtCreateTransactionManager', # 0x64
    'NtOpenTransactionManager', # 0x65
    'NtRollforwardTransactionManager', # 0x66
    'NtRecoverEnlistment', # 0x67
    'NtRecoverResourceManager', # 0x68
    'NtRecoverTransactionManager', # 0x69
    'NtCreateResourceManager', # 0x6a
    'NtOpenResourceManager', # 0x6b
    'NtGetNotificationResourceManager', # 0x6c
    'NtQueryInformationResourceManager', # 0x6d
    'NtCreateEnlistment', # 0x6e
    'NtOpenEnlistment', # 0x6f
    'NtSetInformationEnlistment', # 0x70
    'NtQueryInformationEnlistment', # 0x71
    'NtStartTm', # 0x72
    'NtCreateWaitablePort', # 0x73
    'NtDebugActiveProcess', # 0x74
    'NtDebugContinue', # 0x75
    'NtDelayExecution', # 0x76
    'NtDeleteAtom', # 0x77
    'NtDeleteBootEntry', # 0x78
    'NtDeleteDriverEntry', # 0x79
    'NtDeleteFile', # 0x7a
    'NtDeleteKey', # 0x7b
    'NtDeletePrivateNamespace', # 0x7c
    'NtDeleteObjectAuditAlarm', # 0x7d
    'NtDeleteValueKey', # 0x7e
    'NtDeviceIoControlFile', # 0x7f
    'NtDisplayString', # 0x80
    'NtDuplicateObject', # 0x81
    'NtDuplicateToken', # 0x82
    'NtEnumerateBootEntries', # 0x83
    'NtEnumerateDriverEntries', # 0x84
    'NtEnumerateKey', # 0x85
    'NtEnumerateSystemEnvironmentValuesEx', # 0x86
    'NtEnumerateTransactionObject', # 0x87
    'NtEnumerateValueKey', # 0x88
    'NtExtendSection', # 0x89
    'NtFilterToken', # 0x8a
    'NtFindAtom', # 0x8b
    'NtFlushBuffersFile', # 0x8c
    'NtFlushInstructionCache', # 0x8d
    'NtFlushKey', # 0x8e
    'NtFlushProcessWriteBuffers', # 0x8f
    'NtFlushVirtualMemory', # 0x90
    'NtFlushWriteBuffer', # 0x91
    'NtFreeUserPhysicalPages', # 0x92
    'NtFreeVirtualMemory', # 0x93
    'NtFreezeRegistry', # 0x94
    'NtFreezeTransactions', # 0x95
    'NtFsControlFile', # 0x96
    'NtGetContextThread', # 0x97
    'NtGetDevicePowerState', # 0x98
    'NtGetNlsSectionPtr', # 0x99
    'NtGetPlugPlayEvent', # 0x9a
    'NtGetWriteWatch', # 0x9b
    'NtImpersonateAnonymousToken', # 0x9c
    'NtImpersonateClientOfPort', # 0x9d
    'NtImpersonateThread', # 0x9e
    'NtInitializeNlsFiles', # 0x9f
    'NtInitializeRegistry', # 0xa0
    'NtInitiatePowerAction', # 0xa1
    'NtIsProcessInJob', # 0xa2
    'NtIsSystemResumeAutomatic', # 0xa3
    'NtListenPort', # 0xa4
    'NtLoadDriver', # 0xa5
    'NtLoadKey', # 0xa6
    'NtLoadKey2', # 0xa7
    'NtLoadKeyEx', # 0xa8
    'NtLockFile', # 0xa9
    'NtLockProductActivationKeys', # 0xaa
    'NtLockRegistryKey', # 0xab
    'NtLockVirtualMemory', # 0xac
    'NtMakePermanentObject', # 0xad
    'NtMakeTemporaryObject', # 0xae
    'NtMapUserPhysicalPages', # 0xaf
    'NtMapUserPhysicalPagesScatter', # 0xb0
    'NtMapViewOfSection', # 0xb1
    'NtModifyBootEntry', # 0xb2
    'NtModifyDriverEntry', # 0xb3
    'NtNotifyChangeDirectoryFile', # 0xb4
    'NtNotifyChangeKey', # 0xb5
    'NtNotifyChangeMultipleKeys', # 0xb6
    'NtOpenDirectoryObject', # 0xb7
    'NtOpenEvent', # 0xb8
    'NtOpenEventPair', # 0xb9
    'NtOpenFile', # 0xba
    'NtOpenIoCompletion', # 0xbb
    'NtOpenJobObject', # 0xbc
    'NtOpenKey', # 0xbd
    'NtOpenKeyTransacted', # 0xbe
    'NtOpenMutant', # 0xbf
    'NtOpenPrivateNamespace', # 0xc0
    'NtOpenObjectAuditAlarm', # 0xc1
    'NtOpenProcess', # 0xc2
    'NtOpenProcessToken', # 0xc3
    'NtOpenProcessTokenEx', # 0xc4
    'NtOpenSection', # 0xc5
    'NtOpenSemaphore', # 0xc6
    'NtOpenSession', # 0xc7
    'NtOpenSymbolicLinkObject', # 0xc8
    'NtOpenThread', # 0xc9
    'NtOpenThreadToken', # 0xca
    'NtOpenThreadTokenEx', # 0xcb
    'NtOpenTimer', # 0xcc
    'NtPlugPlayControl', # 0xcd
    'NtPowerInformation', # 0xce
    'NtPrivilegeCheck', # 0xcf
    'NtPrivilegeObjectAuditAlarm', # 0xd0
    'NtPrivilegedServiceAuditAlarm', # 0xd1
    'NtProtectVirtualMemory', # 0xd2
    'NtPulseEvent', # 0xd3
    'NtQueryAttributesFile', # 0xd4
    'NtQueryBootEntryOrder', # 0xd5
    'NtQueryBootOptions', # 0xd6
    'NtQueryDebugFilterState', # 0xd7
    'NtQueryDefaultLocale', # 0xd8
    'NtQueryDefaultUILanguage', # 0xd9
    'NtQueryDirectoryFile', # 0xda
    'NtQueryDirectoryObject', # 0xdb
    'NtQueryDriverEntryOrder', # 0xdc
    'NtQueryEaFile', # 0xdd
    'NtQueryEvent', # 0xde
    'NtQueryFullAttributesFile', # 0xdf
    'NtQueryInformationAtom', # 0xe0
    'NtQueryInformationFile', # 0xe1
    'NtQueryInformationJobObject', # 0xe2
    'NtQueryInformationPort', # 0xe3
    'NtQueryInformationProcess', # 0xe4
    'NtQueryInformationThread', # 0xe5
    'NtQueryInformationToken', # 0xe6
    'NtQueryInstallUILanguage', # 0xe7
    'NtQueryIntervalProfile', # 0xe8
    'NtQueryIoCompletion', # 0xe9
    'NtQueryKey', # 0xea
    'NtQueryMultipleValueKey', # 0xeb
    'NtQueryMutant', # 0xec
    'NtQueryObject', # 0xed
    'NtQueryOpenSubKeys', # 0xee
    'NtQueryOpenSubKeysEx', # 0xef
    'NtQueryPerformanceCounter', # 0xf0
    'NtQueryQuotaInformationFile', # 0xf1
    'NtQuerySection', # 0xf2
    'NtQuerySecurityObject', # 0xf3
    'NtQuerySemaphore', # 0xf4
    'NtQuerySymbolicLinkObject', # 0xf5
    'NtQuerySystemEnvironmentValue', # 0xf6
    'NtQuerySystemEnvironmentValueEx', # 0xf7
    'NtQuerySystemInformation', # 0xf8
    'NtQuerySystemTime', # 0xf9
    'NtQueryTimer', # 0xfa
    'NtQueryTimerResolution', # 0xfb
    'NtQueryValueKey', # 0xfc
    'NtQueryVirtualMemory', # 0xfd
    'NtQueryVolumeInformationFile', # 0xfe
    'NtQueueApcThread', # 0xff
    'NtRaiseException', # 0x100
    'NtRaiseHardError', # 0x101
    'NtReadFile', # 0x102
    'NtReadFileScatter', # 0x103
    'NtReadRequestData', # 0x104
    'NtReadVirtualMemory', # 0x105
    'NtRegisterThreadTerminatePort', # 0x106
    'NtReleaseMutant', # 0x107
    'NtReleaseSemaphore', # 0x108
    'NtRemoveIoCompletion', # 0x109
    'NtRemoveProcessDebug', # 0x10a
    'NtRenameKey', # 0x10b
    'NtReplaceKey', # 0x10c
    'NtReplyPort', # 0x10d
    'NtReplyWaitReceivePort', # 0x10e
    'NtReplyWaitReceivePortEx', # 0x10f
    'NtReplyWaitReplyPort', # 0x110
    'NtRequestDeviceWakeup', # 0x111
    'NtRequestPort', # 0x112
    'NtRequestWaitReplyPort', # 0x113
    'NtRequestWakeupLatency', # 0x114
    'NtResetEvent', # 0x115
    'NtResetWriteWatch', # 0x116
    'NtRestoreKey', # 0x117
    'NtResumeProcess', # 0x118
    'NtResumeThread', # 0x119
    'NtSaveKey', # 0x11a
    'NtSaveKeyEx', # 0x11b
    'NtSaveMergedKeys', # 0x11c
    'NtClearSavepointTransaction', # 0x11d
    'NtClearAllSavepointsTransaction', # 0x11e
    'NtRollbackSavepointTransaction', # 0x11f
    'NtSavepointTransaction', # 0x120
    'NtSavepointComplete', # 0x121
    'NtSecureConnectPort', # 0x122
    'NtSetBootEntryOrder', # 0x123
    'NtSetBootOptions', # 0x124
    'NtSetContextThread', # 0x125
    'NtSetDebugFilterState', # 0x126
    'NtSetDefaultHardErrorPort', # 0x127
    'NtSetDefaultLocale', # 0x128
    'NtSetDefaultUILanguage', # 0x129
    'NtSetDriverEntryOrder', # 0x12a
    'NtSetEaFile', # 0x12b
    'NtSetEvent', # 0x12c
    'NtSetEventBoostPriority', # 0x12d
    'NtSetHighEventPair', # 0x12e
    'NtSetHighWaitLowEventPair', # 0x12f
    'NtSetInformationDebugObject', # 0x130
    'NtSetInformationFile', # 0x131
    'NtSetInformationJobObject', # 0x132
    'NtSetInformationKey', # 0x133
    'NtSetInformationObject', # 0x134
    'NtSetInformationProcess', # 0x135
    'NtSetInformationThread', # 0x136
    'NtSetInformationToken', # 0x137
    'NtSetIntervalProfile', # 0x138
    'NtSetIoCompletion', # 0x139
    'NtSetLdtEntries', # 0x13a
    'NtSetLowEventPair', # 0x13b
    'NtSetLowWaitHighEventPair', # 0x13c
    'NtSetQuotaInformationFile', # 0x13d
    'NtSetSecurityObject', # 0x13e
    'NtSetSystemEnvironmentValue', # 0x13f
    'NtSetSystemEnvironmentValueEx', # 0x140
    'NtSetSystemInformation', # 0x141
    'NtSetSystemPowerState', # 0x142
    'NtSetSystemTime', # 0x143
    'NtSetThreadExecutionState', # 0x144
    'NtSetTimer', # 0x145
    'NtSetTimerResolution', # 0x146
    'NtSetUuidSeed', # 0x147
    'NtSetValueKey', # 0x148
    'NtSetVolumeInformationFile', # 0x149
    'NtShutdownSystem', # 0x14a
    'NtSignalAndWaitForSingleObject', # 0x14b
    'NtStartProfile', # 0x14c
    'NtStopProfile', # 0x14d
    'NtSuspendProcess', # 0x14e
    'NtSuspendThread', # 0x14f
    'NtSystemDebugControl', # 0x150
    'NtTerminateJobObject', # 0x151
    'NtTerminateProcess', # 0x152
    'NtTerminateThread', # 0x153
    'NtTestAlert', # 0x154
    'NtThawRegistry', # 0x155
    'NtThawTransactions', # 0x156
    'NtTraceEvent', # 0x157
    'NtTraceControl', # 0x158
    'NtTranslateFilePath', # 0x159
    'NtUnloadDriver', # 0x15a
    'NtUnloadKey', # 0x15b
    'NtUnloadKey2', # 0x15c
    'NtUnloadKeyEx', # 0x15d
    'NtUnlockFile', # 0x15e
    'NtUnlockVirtualMemory', # 0x15f
    'NtUnmapViewOfSection', # 0x160
    'NtVdmControl', # 0x161
    'NtWaitForDebugEvent', # 0x162
    'NtWaitForMultipleObjects', # 0x163
    'NtWaitForSingleObject', # 0x164
    'NtWaitHighEventPair', # 0x165
    'NtWaitLowEventPair', # 0x166
    'NtWriteFile', # 0x167
    'NtWriteFileGather', # 0x168
    'NtWriteRequestData', # 0x169
    'NtWriteVirtualMemory', # 0x16a
    'NtYieldExecution', # 0x16b
    'NtCreateKeyedEvent', # 0x16c
    'NtOpenKeyedEvent', # 0x16d
    'NtReleaseKeyedEvent', # 0x16e
    'NtWaitForKeyedEvent', # 0x16f
    'NtQueryPortInformationProcess', # 0x170
    'NtGetCurrentProcessorNumber', # 0x171
    'NtWaitForMultipleObjects32', # 0x172
    'NtGetNextProcess', # 0x173
    'NtGetNextThread', # 0x174
    'NtCancelIoFileEx', # 0x175
    'NtCancelSynchronousIoFile', # 0x176
    'NtRemoveIoCompletionEx', # 0x177
    'NtRegisterProtocolAddressInformation', # 0x178
    'NtPullTransaction', # 0x179
    'NtMarshallTransaction', # 0x17a
    'NtPropagationComplete', # 0x17b
    'NtPropagationFailed', # 0x17c
    'NtCreateWorkerFactory', # 0x17d
    'NtReleaseWorkerFactoryWorker', # 0x17e
    'NtWaitForWorkViaWorkerFactory', # 0x17f
    'NtSetInformationWorkerFactory', # 0x180
    'NtQueryInformationWorkerFactory', # 0x181
    'NtWorkerFactoryWorkerReady', # 0x182
    'NtShutdownWorkerFactory', # 0x183
    'NtCreateThreadEx', # 0x184
    'NtCreateUserProcess', # 0x185
    'NtQueryLicenseValue', # 0x186
    'NtMapCMFModule', # 0x187
    'NtListTransactions', # 0x188
    'NtIsUILanguageComitted', # 0x189
    'NtFlushInstallUILanguage', # 0x18a
    'NtGetMUIRegistryInfo', # 0x18b
    'NtAcquireCMFViewOwnership', # 0x18c
    'NtReleaseCMFViewOwnership', # 0x18d
    ],
    [
    'NtGdiAbortDoc', # 0x0
    'NtGdiAbortPath', # 0x1
    'NtGdiAddFontResourceW', # 0x2
    'NtGdiAddRemoteFontToDC', # 0x3
    'NtGdiAddFontMemResourceEx', # 0x4
    'NtGdiRemoveMergeFont', # 0x5
    'NtGdiAddRemoteMMInstanceToDC', # 0x6
    'NtGdiAlphaBlend', # 0x7
    'NtGdiAngleArc', # 0x8
    'NtGdiAnyLinkedFonts', # 0x9
    'NtGdiFontIsLinked', # 0xa
    'NtGdiArcInternal', # 0xb
    'NtGdiBeginPath', # 0xc
    'NtGdiBitBlt', # 0xd
    'NtGdiCancelDC', # 0xe
    'NtGdiCheckBitmapBits', # 0xf
    'NtGdiCloseFigure', # 0x10
    'NtGdiClearBitmapAttributes', # 0x11
    'NtGdiClearBrushAttributes', # 0x12
    'NtGdiColorCorrectPalette', # 0x13
    'NtGdiCombineRgn', # 0x14
    'NtGdiCombineTransform', # 0x15
    'NtGdiComputeXformCoefficients', # 0x16
    'NtGdiConfigureOPMProtectedOutput', # 0x17
    'NtGdiConsoleTextOut', # 0x18
    'NtGdiConvertMetafileRect', # 0x19
    'NtGdiCreateBitmap', # 0x1a
    'NtGdiCreateClientObj', # 0x1b
    'NtGdiCreateColorSpace', # 0x1c
    'NtGdiCreateColorTransform', # 0x1d
    'NtGdiCreateCompatibleBitmap', # 0x1e
    'NtGdiCreateCompatibleDC', # 0x1f
    'NtGdiCreateDIBBrush', # 0x20
    'NtGdiCreateDIBitmapInternal', # 0x21
    'NtGdiCreateDIBSection', # 0x22
    'NtGdiCreateEllipticRgn', # 0x23
    'NtGdiCreateHalftonePalette', # 0x24
    'NtGdiCreateHatchBrushInternal', # 0x25
    'NtGdiCreateMetafileDC', # 0x26
    'NtGdiCreateOPMProtectedOutputs', # 0x27
    'NtGdiCreatePaletteInternal', # 0x28
    'NtGdiCreatePatternBrushInternal', # 0x29
    'NtGdiCreatePen', # 0x2a
    'NtGdiCreateRectRgn', # 0x2b
    'NtGdiCreateRoundRectRgn', # 0x2c
    'NtGdiCreateServerMetaFile', # 0x2d
    'NtGdiCreateSolidBrush', # 0x2e
    'NtGdiD3dContextCreate', # 0x2f
    'NtGdiD3dContextDestroy', # 0x30
    'NtGdiD3dContextDestroyAll', # 0x31
    'NtGdiD3dValidateTextureStageState', # 0x32
    'NtGdiD3dDrawPrimitives2', # 0x33
    'NtGdiDdGetDriverState', # 0x34
    'NtGdiDdAddAttachedSurface', # 0x35
    'NtGdiDdAlphaBlt', # 0x36
    'NtGdiDdAttachSurface', # 0x37
    'NtGdiDdBeginMoCompFrame', # 0x38
    'NtGdiDdBlt', # 0x39
    'NtGdiDdCanCreateSurface', # 0x3a
    'NtGdiDdCanCreateD3DBuffer', # 0x3b
    'NtGdiDdColorControl', # 0x3c
    'NtGdiDdCreateDirectDrawObject', # 0x3d
    'NtGdiDdCreateSurface', # 0x3e
    'NtGdiDdCreateD3DBuffer', # 0x3f
    'NtGdiDdCreateMoComp', # 0x40
    'NtGdiDdCreateSurfaceObject', # 0x41
    'NtGdiDdDeleteDirectDrawObject', # 0x42
    'NtGdiDdDeleteSurfaceObject', # 0x43
    'NtGdiDdDestroyMoComp', # 0x44
    'NtGdiDdDestroySurface', # 0x45
    'NtGdiDdDestroyD3DBuffer', # 0x46
    'NtGdiDdEndMoCompFrame', # 0x47
    'NtGdiDdFlip', # 0x48
    'NtGdiDdFlipToGDISurface', # 0x49
    'NtGdiDdGetAvailDriverMemory', # 0x4a
    'NtGdiDdGetBltStatus', # 0x4b
    'NtGdiDdGetDC', # 0x4c
    'NtGdiDdGetDriverInfo', # 0x4d
    'NtGdiDdGetDxHandle', # 0x4e
    'NtGdiDdGetFlipStatus', # 0x4f
    'NtGdiDdGetInternalMoCompInfo', # 0x50
    'NtGdiDdGetMoCompBuffInfo', # 0x51
    'NtGdiDdGetMoCompGuids', # 0x52
    'NtGdiDdGetMoCompFormats', # 0x53
    'NtGdiDdGetScanLine', # 0x54
    'NtGdiDdLock', # 0x55
    'NtGdiDdLockD3D', # 0x56
    'NtGdiDdQueryDirectDrawObject', # 0x57
    'NtGdiDdQueryMoCompStatus', # 0x58
    'NtGdiDdReenableDirectDrawObject', # 0x59
    'NtGdiDdReleaseDC', # 0x5a
    'NtGdiDdRenderMoComp', # 0x5b
    'NtGdiDdResetVisrgn', # 0x5c
    'NtGdiDdSetColorKey', # 0x5d
    'NtGdiDdSetExclusiveMode', # 0x5e
    'NtGdiDdSetGammaRamp', # 0x5f
    'NtGdiDdCreateSurfaceEx', # 0x60
    'NtGdiDdSetOverlayPosition', # 0x61
    'NtGdiDdUnattachSurface', # 0x62
    'NtGdiDdUnlock', # 0x63
    'NtGdiDdUnlockD3D', # 0x64
    'NtGdiDdUpdateOverlay', # 0x65
    'NtGdiDdWaitForVerticalBlank', # 0x66
    'NtGdiDvpCanCreateVideoPort', # 0x67
    'NtGdiDvpColorControl', # 0x68
    'NtGdiDvpCreateVideoPort', # 0x69
    'NtGdiDvpDestroyVideoPort', # 0x6a
    'NtGdiDvpFlipVideoPort', # 0x6b
    'NtGdiDvpGetVideoPortBandwidth', # 0x6c
    'NtGdiDvpGetVideoPortField', # 0x6d
    'NtGdiDvpGetVideoPortFlipStatus', # 0x6e
    'NtGdiDvpGetVideoPortInputFormats', # 0x6f
    'NtGdiDvpGetVideoPortLine', # 0x70
    'NtGdiDvpGetVideoPortOutputFormats', # 0x71
    'NtGdiDvpGetVideoPortConnectInfo', # 0x72
    'NtGdiDvpGetVideoSignalStatus', # 0x73
    'NtGdiDvpUpdateVideoPort', # 0x74
    'NtGdiDvpWaitForVideoPortSync', # 0x75
    'NtGdiDvpAcquireNotification', # 0x76
    'NtGdiDvpReleaseNotification', # 0x77
    'NtGdiDxgGenericThunk', # 0x78
    'NtGdiDeleteClientObj', # 0x79
    'NtGdiDeleteColorSpace', # 0x7a
    'NtGdiDeleteColorTransform', # 0x7b
    'NtGdiDeleteObjectApp', # 0x7c
    'NtGdiDescribePixelFormat', # 0x7d
    'NtGdiDestroyOPMProtectedOutput', # 0x7e
    'NtGdiGetPerBandInfo', # 0x7f
    'NtGdiDoBanding', # 0x80
    'NtGdiDoPalette', # 0x81
    'NtGdiDrawEscape', # 0x82
    'NtGdiEllipse', # 0x83
    'NtGdiEnableEudc', # 0x84
    'NtGdiEndDoc', # 0x85
    'NtGdiEndPage', # 0x86
    'NtGdiEndPath', # 0x87
    'NtGdiEnumFontChunk', # 0x88
    'NtGdiEnumFontClose', # 0x89
    'NtGdiEnumFontOpen', # 0x8a
    'NtGdiEnumObjects', # 0x8b
    'NtGdiEqualRgn', # 0x8c
    'NtGdiEudcLoadUnloadLink', # 0x8d
    'NtGdiExcludeClipRect', # 0x8e
    'NtGdiExtCreatePen', # 0x8f
    'NtGdiExtCreateRegion', # 0x90
    'NtGdiExtEscape', # 0x91
    'NtGdiExtFloodFill', # 0x92
    'NtGdiExtGetObjectW', # 0x93
    'NtGdiExtSelectClipRgn', # 0x94
    'NtGdiExtTextOutW', # 0x95
    'NtGdiFillPath', # 0x96
    'NtGdiFillRgn', # 0x97
    'NtGdiFlattenPath', # 0x98
    'NtGdiFlush', # 0x99
    'NtGdiForceUFIMapping', # 0x9a
    'NtGdiFrameRgn', # 0x9b
    'NtGdiFullscreenControl', # 0x9c
    'NtGdiGetAndSetDCDword', # 0x9d
    'NtGdiGetAppClipBox', # 0x9e
    'NtGdiGetBitmapBits', # 0x9f
    'NtGdiGetBitmapDimension', # 0xa0
    'NtGdiGetBoundsRect', # 0xa1
    'NtGdiGetCertificate', # 0xa2
    'NtGdiGetCertificateSize', # 0xa3
    'NtGdiGetCharABCWidthsW', # 0xa4
    'NtGdiGetCharacterPlacementW', # 0xa5
    'NtGdiGetCharSet', # 0xa6
    'NtGdiGetCharWidthW', # 0xa7
    'NtGdiGetCharWidthInfo', # 0xa8
    'NtGdiGetColorAdjustment', # 0xa9
    'NtGdiGetColorSpaceforBitmap', # 0xaa
    'NtGdiGetCOPPCompatibleOPMInformation', # 0xab
    'NtGdiGetDCDword', # 0xac
    'NtGdiGetDCforBitmap', # 0xad
    'NtGdiGetDCObject', # 0xae
    'NtGdiGetDCPoint', # 0xaf
    'NtGdiGetDeviceCaps', # 0xb0
    'NtGdiGetDeviceGammaRamp', # 0xb1
    'NtGdiGetDeviceCapsAll', # 0xb2
    'NtGdiGetDIBitsInternal', # 0xb3
    'NtGdiGetETM', # 0xb4
    'NtGdiGetEudcTimeStampEx', # 0xb5
    'NtGdiGetFontData', # 0xb6
    'NtGdiGetFontResourceInfoInternalW', # 0xb7
    'NtGdiGetGlyphIndicesW', # 0xb8
    'NtGdiGetGlyphIndicesWInternal', # 0xb9
    'NtGdiGetGlyphOutline', # 0xba
    'NtGdiGetOPMInformation', # 0xbb
    'NtGdiGetKerningPairs', # 0xbc
    'NtGdiGetLinkedUFIs', # 0xbd
    'NtGdiGetMiterLimit', # 0xbe
    'NtGdiGetMonitorID', # 0xbf
    'NtGdiGetNearestColor', # 0xc0
    'NtGdiGetNearestPaletteIndex', # 0xc1
    'NtGdiGetObjectBitmapHandle', # 0xc2
    'NtGdiGetOPMRandomNumber', # 0xc3
    'NtGdiGetOutlineTextMetricsInternalW', # 0xc4
    'NtGdiGetPath', # 0xc5
    'NtGdiGetPixel', # 0xc6
    'NtGdiGetRandomRgn', # 0xc7
    'NtGdiGetRasterizerCaps', # 0xc8
    'NtGdiGetRealizationInfo', # 0xc9
    'NtGdiGetRegionData', # 0xca
    'NtGdiGetRgnBox', # 0xcb
    'NtGdiGetServerMetaFileBits', # 0xcc
    'NtGdiGetSpoolMessage', # 0xcd
    'NtGdiGetStats', # 0xce
    'NtGdiGetStockObject', # 0xcf
    'NtGdiGetStringBitmapW', # 0xd0
    'NtGdiGetSuggestedOPMProtectedOutputArraySize', # 0xd1
    'NtGdiGetSystemPaletteUse', # 0xd2
    'NtGdiGetTextCharsetInfo', # 0xd3
    'NtGdiGetTextExtent', # 0xd4
    'NtGdiGetTextExtentExW', # 0xd5
    'NtGdiGetTextFaceW', # 0xd6
    'NtGdiGetTextMetricsW', # 0xd7
    'NtGdiGetTransform', # 0xd8
    'NtGdiGetUFI', # 0xd9
    'NtGdiGetEmbUFI', # 0xda
    'NtGdiGetUFIPathname', # 0xdb
    'NtGdiGetEmbedFonts', # 0xdc
    'NtGdiChangeGhostFont', # 0xdd
    'NtGdiAddEmbFontToDC', # 0xde
    'NtGdiGetFontUnicodeRanges', # 0xdf
    'NtGdiGetWidthTable', # 0xe0
    'NtGdiGradientFill', # 0xe1
    'NtGdiHfontCreate', # 0xe2
    'NtGdiIcmBrushInfo', # 0xe3
    'NtGdiInit', # 0xe4
    'NtGdiInitSpool', # 0xe5
    'NtGdiIntersectClipRect', # 0xe6
    'NtGdiInvertRgn', # 0xe7
    'NtGdiLineTo', # 0xe8
    'NtGdiMakeFontDir', # 0xe9
    'NtGdiMakeInfoDC', # 0xea
    'NtGdiMaskBlt', # 0xeb
    'NtGdiModifyWorldTransform', # 0xec
    'NtGdiMonoBitmap', # 0xed
    'NtGdiMoveTo', # 0xee
    'NtGdiOffsetClipRgn', # 0xef
    'NtGdiOffsetRgn', # 0xf0
    'NtGdiOpenDCW', # 0xf1
    'NtGdiPatBlt', # 0xf2
    'NtGdiPolyPatBlt', # 0xf3
    'NtGdiPathToRegion', # 0xf4
    'NtGdiPlgBlt', # 0xf5
    'NtGdiPolyDraw', # 0xf6
    'NtGdiPolyPolyDraw', # 0xf7
    'NtGdiPolyTextOutW', # 0xf8
    'NtGdiPtInRegion', # 0xf9
    'NtGdiPtVisible', # 0xfa
    'NtGdiQueryFonts', # 0xfb
    'NtGdiQueryFontAssocInfo', # 0xfc
    'NtGdiRectangle', # 0xfd
    'NtGdiRectInRegion', # 0xfe
    'NtGdiRectVisible', # 0xff
    'NtGdiRemoveFontResourceW', # 0x100
    'NtGdiRemoveFontMemResourceEx', # 0x101
    'NtGdiResetDC', # 0x102
    'NtGdiResizePalette', # 0x103
    'NtGdiRestoreDC', # 0x104
    'NtGdiRoundRect', # 0x105
    'NtGdiSaveDC', # 0x106
    'NtGdiScaleViewportExtEx', # 0x107
    'NtGdiScaleWindowExtEx', # 0x108
    'NtGdiSelectBitmap', # 0x109
    'NtGdiSelectBrush', # 0x10a
    'NtGdiSelectClipPath', # 0x10b
    'NtGdiSelectFont', # 0x10c
    'NtGdiSelectPen', # 0x10d
    'NtGdiSetBitmapAttributes', # 0x10e
    'NtGdiSetBitmapBits', # 0x10f
    'NtGdiSetBitmapDimension', # 0x110
    'NtGdiSetBoundsRect', # 0x111
    'NtGdiSetBrushAttributes', # 0x112
    'NtGdiSetBrushOrg', # 0x113
    'NtGdiSetColorAdjustment', # 0x114
    'NtGdiSetColorSpace', # 0x115
    'NtGdiSetDeviceGammaRamp', # 0x116
    'NtGdiSetDIBitsToDeviceInternal', # 0x117
    'NtGdiSetFontEnumeration', # 0x118
    'NtGdiSetFontXform', # 0x119
    'NtGdiSetIcmMode', # 0x11a
    'NtGdiSetLinkedUFIs', # 0x11b
    'NtGdiSetMagicColors', # 0x11c
    'NtGdiSetMetaRgn', # 0x11d
    'NtGdiSetMiterLimit', # 0x11e
    'NtGdiGetDeviceWidth', # 0x11f
    'NtGdiMirrorWindowOrg', # 0x120
    'NtGdiSetLayout', # 0x121
    'NtGdiSetOPMSigningKeyAndSequenceNumbers', # 0x122
    'NtGdiSetPixel', # 0x123
    'NtGdiSetPixelFormat', # 0x124
    'NtGdiSetRectRgn', # 0x125
    'NtGdiSetSystemPaletteUse', # 0x126
    'NtGdiSetTextJustification', # 0x127
    'NtGdiSetupPublicCFONT', # 0x128
    'NtGdiSetVirtualResolution', # 0x129
    'NtGdiSetSizeDevice', # 0x12a
    'NtGdiStartDoc', # 0x12b
    'NtGdiStartPage', # 0x12c
    'NtGdiStretchBlt', # 0x12d
    'NtGdiStretchDIBitsInternal', # 0x12e
    'NtGdiStrokeAndFillPath', # 0x12f
    'NtGdiStrokePath', # 0x130
    'NtGdiSwapBuffers', # 0x131
    'NtGdiTransformPoints', # 0x132
    'NtGdiTransparentBlt', # 0x133
    'NtGdiUnloadPrinterDriver', # 0x134
    'NtGdiUnmapMemFont', # 0x135
    'NtGdiUnrealizeObject', # 0x136
    'NtGdiUpdateColors', # 0x137
    'NtGdiWidenPath', # 0x138
    'NtUserActivateKeyboardLayout', # 0x139
    'NtUserAddClipboardFormatListener', # 0x13a
    'NtUserAlterWindowStyle', # 0x13b
    'NtUserAssociateInputContext', # 0x13c
    'NtUserAttachThreadInput', # 0x13d
    'NtUserBeginPaint', # 0x13e
    'NtUserBitBltSysBmp', # 0x13f
    'NtUserBlockInput', # 0x140
    'NtUserBuildHimcList', # 0x141
    'NtUserBuildHwndList', # 0x142
    'NtUserBuildNameList', # 0x143
    'NtUserBuildPropList', # 0x144
    'NtUserCallHwnd', # 0x145
    'NtUserCallHwndLock', # 0x146
    'NtUserCallHwndOpt', # 0x147
    'NtUserCallHwndParam', # 0x148
    'NtUserCallHwndParamLock', # 0x149
    'NtUserCallMsgFilter', # 0x14a
    'NtUserCallNextHookEx', # 0x14b
    'NtUserCallNoParam', # 0x14c
    'NtUserCallOneParam', # 0x14d
    'NtUserCallTwoParam', # 0x14e
    'NtUserChangeClipboardChain', # 0x14f
    'NtUserChangeDisplaySettings', # 0x150
    'NtUserCheckAccessForIntegrityLevel', # 0x151
    'NtUserCheckDesktopByThreadId', # 0x152
    'NtUserCheckWindowThreadDesktop', # 0x153
    'NtUserCheckImeHotKey', # 0x154
    'NtUserCheckMenuItem', # 0x155
    'NtUserChildWindowFromPointEx', # 0x156
    'NtUserClipCursor', # 0x157
    'NtUserCloseClipboard', # 0x158
    'NtUserCloseDesktop', # 0x159
    'NtUserCloseWindowStation', # 0x15a
    'NtUserConsoleControl', # 0x15b
    'NtUserConvertMemHandle', # 0x15c
    'NtUserCopyAcceleratorTable', # 0x15d
    'NtUserCountClipboardFormats', # 0x15e
    'NtUserCreateAcceleratorTable', # 0x15f
    'NtUserCreateCaret', # 0x160
    'NtUserCreateDesktopEx', # 0x161
    'NtUserCreateInputContext', # 0x162
    'NtUserCreateLocalMemHandle', # 0x163
    'NtUserCreateWindowEx', # 0x164
    'NtUserCreateWindowStation', # 0x165
    'NtUserDdeInitialize', # 0x166
    'NtUserDeferWindowPos', # 0x167
    'NtUserDefSetText', # 0x168
    'NtUserDeleteMenu', # 0x169
    'NtUserDestroyAcceleratorTable', # 0x16a
    'NtUserDestroyCursor', # 0x16b
    'NtUserDestroyInputContext', # 0x16c
    'NtUserDestroyMenu', # 0x16d
    'NtUserDestroyWindow', # 0x16e
    'NtUserDisableThreadIme', # 0x16f
    'NtUserDispatchMessage', # 0x170
    'NtUserDoSoundConnect', # 0x171
    'NtUserDoSoundDisconnect', # 0x172
    'NtUserDragDetect', # 0x173
    'NtUserDragObject', # 0x174
    'NtUserDrawAnimatedRects', # 0x175
    'NtUserDrawCaption', # 0x176
    'NtUserDrawCaptionTemp', # 0x177
    'NtUserDrawIconEx', # 0x178
    'NtUserDrawMenuBarTemp', # 0x179
    'NtUserEmptyClipboard', # 0x17a
    'NtUserEnableMenuItem', # 0x17b
    'NtUserEnableScrollBar', # 0x17c
    'NtUserEndDeferWindowPosEx', # 0x17d
    'NtUserEndMenu', # 0x17e
    'NtUserEndPaint', # 0x17f
    'NtUserEnumDisplayDevices', # 0x180
    'NtUserEnumDisplayMonitors', # 0x181
    'NtUserEnumDisplaySettings', # 0x182
    'NtUserEvent', # 0x183
    'NtUserExcludeUpdateRgn', # 0x184
    'NtUserFillWindow', # 0x185
    'NtUserFindExistingCursorIcon', # 0x186
    'NtUserFindWindowEx', # 0x187
    'NtUserFlashWindowEx', # 0x188
    'NtUserFrostCrashedWindow', # 0x189
    'NtUserGetAltTabInfo', # 0x18a
    'NtUserGetAncestor', # 0x18b
    'NtUserGetAppImeLevel', # 0x18c
    'NtUserGetAsyncKeyState', # 0x18d
    'NtUserGetAtomName', # 0x18e
    'NtUserGetCaretBlinkTime', # 0x18f
    'NtUserGetCaretPos', # 0x190
    'NtUserGetClassInfoEx', # 0x191
    'NtUserGetClassName', # 0x192
    'NtUserGetClipboardData', # 0x193
    'NtUserGetClipboardFormatName', # 0x194
    'NtUserGetClipboardOwner', # 0x195
    'NtUserGetClipboardSequenceNumber', # 0x196
    'NtUserGetClipboardViewer', # 0x197
    'NtUserGetClipCursor', # 0x198
    'NtUserGetComboBoxInfo', # 0x199
    'NtUserGetControlBrush', # 0x19a
    'NtUserGetControlColor', # 0x19b
    'NtUserGetCPD', # 0x19c
    'NtUserGetCursorFrameInfo', # 0x19d
    'NtUserGetCursorInfo', # 0x19e
    'NtUserGetDC', # 0x19f
    'NtUserGetDCEx', # 0x1a0
    'NtUserGetDoubleClickTime', # 0x1a1
    'NtUserGetForegroundWindow', # 0x1a2
    'NtUserGetGuiResources', # 0x1a3
    'NtUserGetGUIThreadInfo', # 0x1a4
    'NtUserGetIconInfo', # 0x1a5
    'NtUserGetIconSize', # 0x1a6
    'NtUserGetImeHotKey', # 0x1a7
    'NtUserGetImeInfoEx', # 0x1a8
    'NtUserGetInternalWindowPos', # 0x1a9
    'NtUserGetKeyboardLayoutList', # 0x1aa
    'NtUserGetKeyboardLayoutName', # 0x1ab
    'NtUserGetKeyboardState', # 0x1ac
    'NtUserGetKeyNameText', # 0x1ad
    'NtUserGetKeyState', # 0x1ae
    'NtUserGetListBoxInfo', # 0x1af
    'NtUserGetMenuBarInfo', # 0x1b0
    'NtUserGetMenuIndex', # 0x1b1
    'NtUserGetMenuItemRect', # 0x1b2
    'NtUserGetMessage', # 0x1b3
    'NtUserGetMouseMovePointsEx', # 0x1b4
    'NtUserGetObjectInformation', # 0x1b5
    'NtUserGetOpenClipboardWindow', # 0x1b6
    'NtUserGetPriorityClipboardFormat', # 0x1b7
    'NtUserGetProcessWindowStation', # 0x1b8
    'NtUserGetRawInputBuffer', # 0x1b9
    'NtUserGetRawInputData', # 0x1ba
    'NtUserGetRawInputDeviceInfo', # 0x1bb
    'NtUserGetRawInputDeviceList', # 0x1bc
    'NtUserGetRegisteredRawInputDevices', # 0x1bd
    'NtUserGetScrollBarInfo', # 0x1be
    'NtUserGetSystemMenu', # 0x1bf
    'NtUserGetThreadDesktop', # 0x1c0
    'NtUserGetThreadState', # 0x1c1
    'NtUserGetTitleBarInfo', # 0x1c2
    'NtUserGetUpdatedClipboardFormats', # 0x1c3
    'NtUserGetUpdateRect', # 0x1c4
    'NtUserGetUpdateRgn', # 0x1c5
    'NtUserGetWindowDC', # 0x1c6
    'NtUserGetWindowPlacement', # 0x1c7
    'NtUserGetWOWClass', # 0x1c8
    'NtUserGhostWindowFromHungWindow', # 0x1c9
    'NtUserHardErrorControl', # 0x1ca
    'NtUserHideCaret', # 0x1cb
    'NtUserHiliteMenuItem', # 0x1cc
    'NtUserHungWindowFromGhostWindow', # 0x1cd
    'NtUserImpersonateDdeClientWindow', # 0x1ce
    'NtUserInitialize', # 0x1cf
    'NtUserInitializeClientPfnArrays', # 0x1d0
    'NtUserInitTask', # 0x1d1
    'NtUserInternalGetWindowText', # 0x1d2
    'NtUserInternalGetWindowIcon', # 0x1d3
    'NtUserInvalidateRect', # 0x1d4
    'NtUserInvalidateRgn', # 0x1d5
    'NtUserIsClipboardFormatAvailable', # 0x1d6
    'NtUserKillTimer', # 0x1d7
    'NtUserLoadKeyboardLayoutEx', # 0x1d8
    'NtUserLockWindowStation', # 0x1d9
    'NtUserLockWindowUpdate', # 0x1da
    'NtUserLockWorkStation', # 0x1db
    'NtUserLogicalToPhysicalPoint', # 0x1dc
    'NtUserMapVirtualKeyEx', # 0x1dd
    'NtUserMenuItemFromPoint', # 0x1de
    'NtUserMessageCall', # 0x1df
    'NtUserMinMaximize', # 0x1e0
    'NtUserMNDragLeave', # 0x1e1
    'NtUserMNDragOver', # 0x1e2
    'NtUserModifyUserStartupInfoFlags', # 0x1e3
    'NtUserMoveWindow', # 0x1e4
    'NtUserNotifyIMEStatus', # 0x1e5
    'NtUserNotifyProcessCreate', # 0x1e6
    'NtUserNotifyWinEvent', # 0x1e7
    'NtUserOpenClipboard', # 0x1e8
    'NtUserOpenDesktop', # 0x1e9
    'NtUserOpenInputDesktop', # 0x1ea
    'NtUserOpenThreadDesktop', # 0x1eb
    'NtUserOpenWindowStation', # 0x1ec
    'NtUserPaintDesktop', # 0x1ed
    'NtUserPaintMonitor', # 0x1ee
    'NtUserPeekMessage', # 0x1ef
    'NtUserPhysicalToLogicalPoint', # 0x1f0
    'NtUserPostMessage', # 0x1f1
    'NtUserPostThreadMessage', # 0x1f2
    'NtUserPrintWindow', # 0x1f3
    'NtUserProcessConnect', # 0x1f4
    'NtUserQueryInformationThread', # 0x1f5
    'NtUserQueryInputContext', # 0x1f6
    'NtUserQuerySendMessage', # 0x1f7
    'NtUserQueryWindow', # 0x1f8
    'NtUserRealChildWindowFromPoint', # 0x1f9
    'NtUserRealInternalGetMessage', # 0x1fa
    'NtUserRealWaitMessageEx', # 0x1fb
    'NtUserRedrawWindow', # 0x1fc
    'NtUserRegisterClassExWOW', # 0x1fd
    'NtUserRegisterErrorReportingDialog', # 0x1fe
    'NtUserRegisterUserApiHook', # 0x1ff
    'NtUserRegisterHotKey', # 0x200
    'NtUserRegisterRawInputDevices', # 0x201
    'NtUserRegisterTasklist', # 0x202
    'NtUserRegisterWindowMessage', # 0x203
    'NtUserRemoveClipboardFormatListener', # 0x204
    'NtUserRemoveMenu', # 0x205
    'NtUserRemoveProp', # 0x206
    'NtUserResolveDesktop', # 0x207
    'NtUserResolveDesktopForWOW', # 0x208
    'NtUserSBGetParms', # 0x209
    'NtUserScrollDC', # 0x20a
    'NtUserScrollWindowEx', # 0x20b
    'NtUserSelectPalette', # 0x20c
    'NtUserSendInput', # 0x20d
    'NtUserSetActiveWindow', # 0x20e
    'NtUserSetAppImeLevel', # 0x20f
    'NtUserSetCapture', # 0x210
    'NtUserSetClassLong', # 0x211
    'NtUserSetClassWord', # 0x212
    'NtUserSetClipboardData', # 0x213
    'NtUserSetClipboardViewer', # 0x214
    'NtUserSetConsoleReserveKeys', # 0x215
    'NtUserSetCursor', # 0x216
    'NtUserSetCursorContents', # 0x217
    'NtUserSetCursorIconData', # 0x218
    'NtUserSetFocus', # 0x219
    'NtUserSetImeHotKey', # 0x21a
    'NtUserSetImeInfoEx', # 0x21b
    'NtUserSetImeOwnerWindow', # 0x21c
    'NtUserSetInformationProcess', # 0x21d
    'NtUserSetInformationThread', # 0x21e
    'NtUserSetInternalWindowPos', # 0x21f
    'NtUserSetKeyboardState', # 0x220
    'NtUserSetMenu', # 0x221
    'NtUserSetMenuContextHelpId', # 0x222
    'NtUserSetMenuDefaultItem', # 0x223
    'NtUserSetMenuFlagRtoL', # 0x224
    'NtUserSetObjectInformation', # 0x225
    'NtUserSetParent', # 0x226
    'NtUserSetProcessWindowStation', # 0x227
    'NtUserGetProp', # 0x228
    'NtUserSetProp', # 0x229
    'NtUserSetScrollInfo', # 0x22a
    'NtUserSetShellWindowEx', # 0x22b
    'NtUserSetSysColors', # 0x22c
    'NtUserSetSystemCursor', # 0x22d
    'NtUserSetSystemMenu', # 0x22e
    'NtUserSetSystemTimer', # 0x22f
    'NtUserSetThreadDesktop', # 0x230
    'NtUserSetThreadLayoutHandles', # 0x231
    'NtUserSetThreadState', # 0x232
    'NtUserSetTimer', # 0x233
    'NtUserSetProcessDPIAware', # 0x234
    'NtUserSetWindowFNID', # 0x235
    'NtUserSetWindowLong', # 0x236
    'NtUserSetWindowPlacement', # 0x237
    'NtUserSetWindowPos', # 0x238
    'NtUserSetWindowRgn', # 0x239
    'NtUserGetWindowRgnEx', # 0x23a
    'NtUserSetWindowRgnEx', # 0x23b
    'NtUserSetWindowsHookAW', # 0x23c
    'NtUserSetWindowsHookEx', # 0x23d
    'NtUserSetWindowStationUser', # 0x23e
    'NtUserSetWindowWord', # 0x23f
    'NtUserSetWinEventHook', # 0x240
    'NtUserShowCaret', # 0x241
    'NtUserShowScrollBar', # 0x242
    'NtUserShowWindow', # 0x243
    'NtUserShowWindowAsync', # 0x244
    'NtUserSoundSentry', # 0x245
    'NtUserSwitchDesktop', # 0x246
    'NtUserSystemParametersInfo', # 0x247
    'NtUserTestForInteractiveUser', # 0x248
    'NtUserThunkedMenuInfo', # 0x249
    'NtUserThunkedMenuItemInfo', # 0x24a
    'NtUserToUnicodeEx', # 0x24b
    'NtUserTrackMouseEvent', # 0x24c
    'NtUserTrackPopupMenuEx', # 0x24d
    'NtUserCalcMenuBar', # 0x24e
    'NtUserPaintMenuBar', # 0x24f
    'NtUserTranslateAccelerator', # 0x250
    'NtUserTranslateMessage', # 0x251
    'NtUserUnhookWindowsHookEx', # 0x252
    'NtUserUnhookWinEvent', # 0x253
    'NtUserUnloadKeyboardLayout', # 0x254
    'NtUserUnlockWindowStation', # 0x255
    'NtUserUnregisterClass', # 0x256
    'NtUserUnregisterUserApiHook', # 0x257
    'NtUserUnregisterHotKey', # 0x258
    'NtUserUpdateInputContext', # 0x259
    'NtUserUpdateInstance', # 0x25a
    'NtUserUpdateLayeredWindow', # 0x25b
    'NtUserGetLayeredWindowAttributes', # 0x25c
    'NtUserSetLayeredWindowAttributes', # 0x25d
    'NtUserUpdatePerUserSystemParameters', # 0x25e
    'NtUserUserHandleGrantAccess', # 0x25f
    'NtUserValidateHandleSecure', # 0x260
    'NtUserValidateRect', # 0x261
    'NtUserValidateTimerCallback', # 0x262
    'NtUserVkKeyScanEx', # 0x263
    'NtUserWaitForInputIdle', # 0x264
    'NtUserWaitForMsgAndEvent', # 0x265
    'NtUserWaitMessage', # 0x266
    'NtUserWin32PoolAllocationStats', # 0x267
    'NtUserWindowFromPhysicalPoint', # 0x268
    'NtUserWindowFromPoint', # 0x269
    'NtUserYieldTask', # 0x26a
    'NtUserRemoteConnect', # 0x26b
    'NtUserRemoteRedrawRectangle', # 0x26c
    'NtUserRemoteRedrawScreen', # 0x26d
    'NtUserRemoteStopScreenUpdates', # 0x26e
    'NtUserCtxDisplayIOCtl', # 0x26f
    'NtUserRegisterSessionPort', # 0x270
    'NtUserUnregisterSessionPort', # 0x271
    'NtUserUpdateWindowTransform', # 0x272
    'NtUserDwmStartRedirection', # 0x273
    'NtUserDwmStopRedirection', # 0x274
    'NtUserDwmHintDxUpdate', # 0x275
    'NtUserDwmGetDxRgn', # 0x276
    'NtUserGetWindowMinimizeRect', # 0x277
    'NtGdiEngAssociateSurface', # 0x278
    'NtGdiEngCreateBitmap', # 0x279
    'NtGdiEngCreateDeviceSurface', # 0x27a
    'NtGdiEngCreateDeviceBitmap', # 0x27b
    'NtGdiEngCreatePalette', # 0x27c
    'NtGdiEngComputeGlyphSet', # 0x27d
    'NtGdiEngCopyBits', # 0x27e
    'NtGdiEngDeletePalette', # 0x27f
    'NtGdiEngDeleteSurface', # 0x280
    'NtGdiEngEraseSurface', # 0x281
    'NtGdiEngUnlockSurface', # 0x282
    'NtGdiEngLockSurface', # 0x283
    'NtGdiEngBitBlt', # 0x284
    'NtGdiEngStretchBlt', # 0x285
    'NtGdiEngPlgBlt', # 0x286
    'NtGdiEngMarkBandingSurface', # 0x287
    'NtGdiEngStrokePath', # 0x288
    'NtGdiEngFillPath', # 0x289
    'NtGdiEngStrokeAndFillPath', # 0x28a
    'NtGdiEngPaint', # 0x28b
    'NtGdiEngLineTo', # 0x28c
    'NtGdiEngAlphaBlend', # 0x28d
    'NtGdiEngGradientFill', # 0x28e
    'NtGdiEngTransparentBlt', # 0x28f
    'NtGdiEngTextOut', # 0x290
    'NtGdiEngStretchBltROP', # 0x291
    'NtGdiXLATEOBJ_cGetPalette', # 0x292
    'NtGdiXLATEOBJ_iXlate', # 0x293
    'NtGdiXLATEOBJ_hGetColorTransform', # 0x294
    'NtGdiCLIPOBJ_bEnum', # 0x295
    'NtGdiCLIPOBJ_cEnumStart', # 0x296
    'NtGdiCLIPOBJ_ppoGetPath', # 0x297
    'NtGdiEngDeletePath', # 0x298
    'NtGdiEngCreateClip', # 0x299
    'NtGdiEngDeleteClip', # 0x29a
    'NtGdiBRUSHOBJ_ulGetBrushColor', # 0x29b
    'NtGdiBRUSHOBJ_pvAllocRbrush', # 0x29c
    'NtGdiBRUSHOBJ_pvGetRbrush', # 0x29d
    'NtGdiBRUSHOBJ_hGetColorTransform', # 0x29e
    'NtGdiXFORMOBJ_bApplyXform', # 0x29f
    'NtGdiXFORMOBJ_iGetXform', # 0x2a0
    'NtGdiFONTOBJ_vGetInfo', # 0x2a1
    'NtGdiFONTOBJ_pxoGetXform', # 0x2a2
    'NtGdiFONTOBJ_cGetGlyphs', # 0x2a3
    'NtGdiFONTOBJ_pifi', # 0x2a4
    'NtGdiFONTOBJ_pfdg', # 0x2a5
    'NtGdiFONTOBJ_pQueryGlyphAttrs', # 0x2a6
    'NtGdiFONTOBJ_pvTrueTypeFontFile', # 0x2a7
    'NtGdiFONTOBJ_cGetAllGlyphHandles', # 0x2a8
    'NtGdiSTROBJ_bEnum', # 0x2a9
    'NtGdiSTROBJ_bEnumPositionsOnly', # 0x2aa
    'NtGdiSTROBJ_bGetAdvanceWidths', # 0x2ab
    'NtGdiSTROBJ_vEnumStart', # 0x2ac
    'NtGdiSTROBJ_dwGetCodePage', # 0x2ad
    'NtGdiPATHOBJ_vGetBounds', # 0x2ae
    'NtGdiPATHOBJ_bEnum', # 0x2af
    'NtGdiPATHOBJ_vEnumStart', # 0x2b0
    'NtGdiPATHOBJ_vEnumStartClipLines', # 0x2b1
    'NtGdiPATHOBJ_bEnumClipLines', # 0x2b2
    'NtGdiGetDhpdev', # 0x2b3
    'NtGdiEngCheckAbort', # 0x2b4
    'NtGdiHT_Get8BPPFormatPalette', # 0x2b5
    'NtGdiHT_Get8BPPMaskPalette', # 0x2b6
    'NtGdiUpdateTransform', # 0x2b7
    'NtGdiSetPUMPDOBJ', # 0x2b8
    'NtGdiBRUSHOBJ_DeleteRbrush', # 0x2b9
    'NtGdiUMPDEngFreeUserMem', # 0x2ba
    'NtGdiDrawStream', # 0x2bb
    'NtGdiDwmGetDirtyRgn', # 0x2bc
    'NtGdiDwmGetSurfaceData', # 0x2bd
    'NtGdiDdDDICreateAllocation', # 0x2be
    'NtGdiDdDDIQueryResourceInfo', # 0x2bf
    'NtGdiDdDDIOpenResource', # 0x2c0
    'NtGdiDdDDIDestroyAllocation', # 0x2c1
    'NtGdiDdDDISetAllocationPriority', # 0x2c2
    'NtGdiDdDDIQueryAllocationResidency', # 0x2c3
    'NtGdiDdDDICreateDevice', # 0x2c4
    'NtGdiDdDDIDestroyDevice', # 0x2c5
    'NtGdiDdDDICreateContext', # 0x2c6
    'NtGdiDdDDIDestroyContext', # 0x2c7
    'NtGdiDdDDICreateSynchronizationObject', # 0x2c8
    'NtGdiDdDDIDestroySynchronizationObject', # 0x2c9
    'NtGdiDdDDIWaitForSynchronizationObject', # 0x2ca
    'NtGdiDdDDISignalSynchronizationObject', # 0x2cb
    'NtGdiDdDDIGetRuntimeData', # 0x2cc
    'NtGdiDdDDIQueryAdapterInfo', # 0x2cd
    'NtGdiDdDDILock', # 0x2ce
    'NtGdiDdDDIUnlock', # 0x2cf
    'NtGdiDdDDIGetDisplayModeList', # 0x2d0
    'NtGdiDdDDISetDisplayMode', # 0x2d1
    'NtGdiDdDDIGetMultisampleMethodList', # 0x2d2
    'NtGdiDdDDIPresent', # 0x2d3
    'NtGdiDdDDIRender', # 0x2d4
    'NtGdiDdDDIOpenAdapterFromDeviceName', # 0x2d5
    'NtGdiDdDDIOpenAdapterFromHdc', # 0x2d6
    'NtGdiDdDDICloseAdapter', # 0x2d7
    'NtGdiDdDDIGetSharedPrimaryHandle', # 0x2d8
    'NtGdiDdDDIEscape', # 0x2d9
    'NtGdiDdDDIQueryStatistics', # 0x2da
    'NtGdiDdDDISetVidPnSourceOwner', # 0x2db
    'NtGdiDdDDIGetPresentHistory', # 0x2dc
    'NtGdiDdDDICreateOverlay', # 0x2dd
    'NtGdiDdDDIUpdateOverlay', # 0x2de
    'NtGdiDdDDIFlipOverlay', # 0x2df
    'NtGdiDdDDIDestroyOverlay', # 0x2e0
    'NtGdiDdDDIWaitForVerticalBlankEvent', # 0x2e1
    'NtGdiDdDDISetGammaRamp', # 0x2e2
    'NtGdiDdDDIGetDeviceState', # 0x2e3
    'NtGdiDdDDICreateDCFromMemory', # 0x2e4
    'NtGdiDdDDIDestroyDCFromMemory', # 0x2e5
    'NtGdiDdDDISetContextSchedulingPriority', # 0x2e6
    'NtGdiDdDDIGetContextSchedulingPriority', # 0x2e7
    'NtGdiDdDDISetProcessSchedulingPriorityClass', # 0x2e8
    'NtGdiDdDDIGetProcessSchedulingPriorityClass', # 0x2e9
    'NtGdiDdDDIReleaseProcessVidPnSourceOwners', # 0x2ea
    'NtGdiDdDDIGetScanLine', # 0x2eb
    'NtGdiDdDDISetQueuedLimit', # 0x2ec
    'NtGdiDdDDIPollDisplayChildren', # 0x2ed
    'NtGdiDdDDIInvalidateActiveVidPn', # 0x2ee
    'NtGdiDdDDICheckOcclusion', # 0x2ef
    'NtGdiDdDDIWaitForIdle', # 0x2f0
    'NtGdiDdDDICheckMonitorPowerState', # 0x2f1
    'NtGdiDdDDICheckExclusiveOwnership', # 0x2f2
    'NtGdiDdDDISetDisplayPrivateDriverFormat', # 0x2f3
    'NtGdiDdDDISharedPrimaryLockNotification', # 0x2f4
    'NtGdiDdDDISharedPrimaryUnLockNotification', # 0x2f5
    'DxgStubEnableDirectDrawRedirection', # 0x2f6
    'DxgStubDeleteDirectDrawObject', # 0x2f7
    'NtGdiGetNumberOfPhysicalMonitors', # 0x2f8
    'NtGdiGetPhysicalMonitors', # 0x2f9
    'NtGdiGetPhysicalMonitorDescription', # 0x2fa
    'NtGdiDestroyPhysicalMonitor', # 0x2fb
    'NtGdiDDCCIGetVCPFeature', # 0x2fc
    'NtGdiDDCCISetVCPFeature', # 0x2fd
    'NtGdiDDCCISaveCurrentSettings', # 0x2fe
    'NtGdiDDCCIGetCapabilitiesStringLength', # 0x2ff
    'NtGdiDDCCIGetCapabilitiesString', # 0x300
    'NtGdiDDCCIGetTimingReport', # 0x301
    'NtUserSetMirrorRendering', # 0x302
    'NtUserShowSystemCursor', # 0x303
    ],
]
