/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.lang;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.lang.LangImporter;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.ViewLocale;

public class OptionsLangPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelLang = null;
    private JLabel languageLabel = null;
    private JLabel importLabel = null;
    private JLabel restartLabel = null;
    private JButton selectionButton = null;
    private JButton importButton = null;
    private JComboBox<ViewLocale> localeSelect = null;
    private ZapTextField fileTextField = null;
    private Document fileTextFieldDoc = null;

    public OptionsLangPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("options.lang.title"));
        this.add((Component)this.getPanelLang(), this.getPanelLang().getName());
    }

    private JPanel getPanelLang() {
        if (this.panelLang == null) {
            this.panelLang = new JPanel();
            this.panelLang.setName(Constant.messages.getString("options.lang.title"));
            this.panelLang.setLayout(new GridBagLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelLang.setSize(409, 268);
            }
            this.languageLabel = new JLabel(Constant.messages.getString("options.lang.selector.label"));
            this.importLabel = new JLabel(Constant.messages.getString("options.lang.importer.label"));
            this.restartLabel = new JLabel(Constant.messages.getString("options.lang.label.restart"));
            this.panelLang.add((Component)this.languageLabel, this.getGridBagConstraints(0, 0, 0.5, 0.0, 0, 0, 0));
            this.panelLang.add(this.getLocaleSelect(), this.getGridBagConstraints(1, 0, 0.5, 0.0, 0, 0, 0));
            this.panelLang.add((Component)this.importLabel, this.getGridBagConstraints(0, 1, 1.0, 0.0, 2, 0, 0));
            this.panelLang.add((Component)this.getFileTextField(), this.getGridBagConstraints(0, 2, 1.0, 0.0, 2, 0, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.getImportButton());
            jPanel.add(this.getSelectionButton());
            this.panelLang.add((Component)jPanel, this.getGridBagConstraints(0, 3, 0.5, 0.0, 2, 0, 12));
            this.panelLang.add((Component)this.restartLabel, this.getGridBagConstraints(0, 4, 1.0, 0.0, 2, 0, 0));
            this.panelLang.add((Component)new JLabel(""), this.getGridBagConstraints(0, 5, 1.0, 1.0, 2, 1, 0));
        }
        return this.panelLang;
    }

    private GridBagConstraints getGridBagConstraints(int n, int n2, double d, double d2, int n3, int n4, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = n3 > 0 ? n3 : 1;
        gridBagConstraints.fill = n4 > 0 ? n4 : 2;
        gridBagConstraints.anchor = n5 > 0 ? n5 : 18;
        return gridBagConstraints;
    }

    private ZapTextField getFileTextField() {
        if (this.fileTextField == null) {
            this.fileTextField = new ZapTextField();
            this.fileTextFieldDoc = this.fileTextField.getDocument();
            this.fileTextFieldDoc.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updated(documentEvent);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updated(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updated(documentEvent);
                }

                private void updated(DocumentEvent documentEvent) {
                    try {
                        String string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                        OptionsLangPanel.this.importButton.setEnabled(string.endsWith(".zaplang"));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.fileTextField;
    }

    private JButton getSelectionButton() {
        if (this.selectionButton == null) {
            this.selectionButton = new JButton();
            this.selectionButton.setText(Constant.messages.getString("options.lang.importer.browse"));
            this.selectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsLangPanel.this.browseButtonActionPerformed(actionEvent);
                }
            });
        }
        return this.selectionButton;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton();
            this.importButton.setEnabled(false);
            this.importButton.setText(Constant.messages.getString("options.lang.importer.button"));
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!OptionsLangPanel.this.fileTextField.getText().equals("")) {
                        LangImporter.importLanguagePack(OptionsLangPanel.this.fileTextField.getText());
                        OptionsLangPanel.this.fileTextField.setText("");
                        OptionsLangPanel.this.fileTextField.discardAllEdits();
                        OptionsLangPanel.this.loadLocales();
                    }
                }
            });
        }
        return this.importButton;
    }

    private JComboBox<ViewLocale> getLocaleSelect() {
        if (this.localeSelect == null) {
            this.localeSelect = new JComboBox();
            this.loadLocales();
        }
        return this.localeSelect;
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Constant.messages.getString("options.lang.file.chooser.description");
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".zaplang");
            }
        });
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            this.fileTextField.setText(jFileChooser.getSelectedFile().toString());
            this.fileTextField.discardAllEdits();
        }
    }

    private void loadLocales() {
        this.localeSelect.removeAllItems();
        for (ViewLocale viewLocale : LocaleUtils.getAvailableViewLocales()) {
            this.localeSelect.addItem(viewLocale);
        }
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        ViewLocale viewLocale = LocaleUtils.getViewLocale(optionsParam.getViewParam().getLocale());
        this.localeSelect.setSelectedItem(viewLocale);
    }

    @Override
    public void validateParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        ViewLocale viewLocale = (ViewLocale)this.localeSelect.getSelectedItem();
        if (viewLocale != null) {
            optionsParam.getViewParam().setLocale(viewLocale.getLocale());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.language";
    }
}

