/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.StickyScrollbarAdjustmentListener;

public class ZapTable
extends JXTable {
    private static final long serialVersionUID = 8303870012122236918L;
    private boolean autoScroll;
    private AutoScrollAction autoScrollAction;
    private StickyScrollbarAdjustmentListener autoScrollScrollbarAdjustmentListener;

    public ZapTable() {
        this.init();
    }

    public ZapTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    private void init() {
        this.setDoubleBuffered(true);
        this.setColumnControlVisible(true);
        JComponent jComponent = this.getColumnControl();
        if (jComponent instanceof ZapColumnControlButton) {
            ZapColumnControlButton zapColumnControlButton = (ZapColumnControlButton)((Object)jComponent);
            zapColumnControlButton.addAction((Action)((Object)this.getAutoScrollAction()));
            zapColumnControlButton.populatePopup();
        }
        this.setAutoScrollOnNewValues(true);
    }

    protected AutoScrollAction getAutoScrollAction() {
        if (this.autoScrollAction == null) {
            this.autoScrollAction = new AutoScrollAction(this);
        }
        return this.autoScrollAction;
    }

    public void setAutoScrollOnNewValues(boolean bl) {
        if (this.autoScroll == bl) {
            return;
        }
        if (this.autoScroll) {
            this.removeAutoScrollScrollbarAdjustmentListener();
        }
        this.autoScroll = bl;
        if (this.autoScrollAction != null) {
            this.autoScrollAction.putValue("SwingSelectedKey", bl);
        }
        if (this.autoScroll) {
            this.addAutoScrollScrollbarAdjustmentListener();
        }
    }

    public boolean isAutoScrollOnNewValues() {
        return this.autoScroll;
    }

    private void addAutoScrollScrollbarAdjustmentListener() {
        JScrollPane jScrollPane = this.getEnclosingScrollPane();
        if (jScrollPane != null && this.autoScrollScrollbarAdjustmentListener == null) {
            this.autoScrollScrollbarAdjustmentListener = new StickyScrollbarAdjustmentListener();
            jScrollPane.getVerticalScrollBar().addAdjustmentListener(this.autoScrollScrollbarAdjustmentListener);
        }
    }

    private void removeAutoScrollScrollbarAdjustmentListener() {
        JScrollPane jScrollPane = this.getEnclosingScrollPane();
        if (jScrollPane != null && this.autoScrollScrollbarAdjustmentListener != null) {
            jScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.autoScrollScrollbarAdjustmentListener);
            this.autoScrollScrollbarAdjustmentListener = null;
        }
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.isAutoScrollOnNewValues()) {
            this.addAutoScrollScrollbarAdjustmentListener();
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        super.unconfigureEnclosingScrollPane();
        if (this.isAutoScrollOnNewValues()) {
            this.removeAutoScrollScrollbarAdjustmentListener();
        }
    }

    protected JScrollPane getEnclosingScrollPane() {
        Container container;
        Container container2 = SwingUtilities.getUnwrappedParent((Component)((Object)this));
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || SwingUtilities.getUnwrappedView(jViewport) != this) {
                return null;
            }
            return jScrollPane;
        }
        return null;
    }

    public Point getPopupLocation(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                this.getSelectionModel().clearSelection();
            } else if (!this.getSelectionModel().isSelectedIndex(n)) {
                this.getSelectionModel().setSelectionInterval(n, n);
            }
        }
        return super.getPopupLocation(mouseEvent);
    }

    protected JComponent createDefaultColumnControl() {
        return new ZapColumnControlButton(this);
    }

    protected static class AutoScrollAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 5518182106427836717L;
        private final ZapTable table;

        public AutoScrollAction(ZapTable zapTable) {
            super(Constant.messages.getString("view.table.autoscroll.label"));
            this.putValue("ShortDescription", Constant.messages.getString("view.table.autoscroll.tooltip"));
            this.table = zapTable;
        }

        public AutoScrollAction(String string, Icon icon, ZapTable zapTable) {
            super(string, icon);
            this.table = zapTable;
        }

        public boolean isStateAction() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.table.setAutoScrollOnNewValues(!this.table.isAutoScrollOnNewValues());
        }
    }

    protected static class ZapColumnControlButton
    extends ColumnControlButton {
        private static final long serialVersionUID = -2888568545235496369L;
        private List<Action> customActions;

        public ZapColumnControlButton(JXTable jXTable) {
            super(jXTable);
        }

        public ZapColumnControlButton(JXTable jXTable, Icon icon) {
            super(jXTable, icon);
        }

        protected void populatePopup() {
            super.populatePopup();
            if (this.customActions != null && this.popup instanceof ColumnControlButton.DefaultColumnControlPopup) {
                ((ColumnControlButton.DefaultColumnControlPopup)this.popup).addAdditionalActionItems(this.customActions);
            }
        }

        public void addAction(Action action) {
            if (this.customActions == null) {
                this.customActions = new ArrayList<Action>(1);
            }
            this.customActions.add(action);
        }
    }
}

