/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.renderer.UserListCellRenderer;

public class UsersMultiSelectList
extends JList<User> {
    private static final long serialVersionUID = 7473652413044348214L;
    private static ExtensionUserManagement usersExtension;

    private static void loadUsersManagementExtension() {
        if (usersExtension == null && (usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class)) == null) {
            throw new IllegalStateException("Trying to create MultiUserSelectBox without the ExtensionUsersManagement being enabled.");
        }
    }

    public UsersMultiSelectList(int n, int n2) {
        UsersMultiSelectList.loadUsersManagementExtension();
        this.reloadUsers(n);
        this.setSelectionMode(n2);
        this.setCellRenderer(new UserListCellRenderer());
    }

    public void reloadUsers(int n) {
        List<User> list = usersExtension.getContextUserAuthManager(n).getUsers();
        User[] userArray = list.toArray(new User[list.size()]);
        DefaultComboBoxModel<User> defaultComboBoxModel = new DefaultComboBoxModel<User>(userArray);
        this.setModel(defaultComboBoxModel);
    }
}

