/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.control.Matrix;
import com.baselet.element.elementnew.plot.parser.ParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataSet {
    private String id;
    private Integer nr;
    private int lineNr;
    private boolean isInverted;
    private List<String> titleRow = null;
    private List<String> titleCol = null;
    private Matrix<Double> valueMatrix;
    private Matrix<String> analyseMatrix;
    public static final Double VALUE_DEFAULT = 0.0;

    protected DataSet(String id, int nr, int lineNr) {
        this.id = id;
        this.nr = nr;
        this.lineNr = lineNr;
        this.analyseMatrix = new Matrix();
    }

    public String getId() {
        return this.id;
    }

    public Integer getNr() {
        return this.nr;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public int rows() {
        return this.valueMatrix.rows();
    }

    public int cols() {
        return this.valueMatrix.cols();
    }

    public boolean isEmpty() {
        return this.valueMatrix.isEmpty();
    }

    public Double[] row(int index) {
        List<Double> list = this.valueMatrix.row(index);
        return list.toArray(new Double[list.size()]);
    }

    public Double[][] data() {
        if (this.valueMatrix.isEmpty()) {
            throw new ParserException("The dataset (line: " + this.getLineNr() + ") has no values");
        }
        Double[][] returnArray = new Double[this.rows()][];
        int i = 0;
        while (i < this.rows()) {
            returnArray[i] = this.row(i);
            ++i;
        }
        return returnArray;
    }

    public void setInvert(boolean shouldBeInverted) {
        if (this.isInverted == !shouldBeInverted) {
            this.analyseMatrix.invert();
            this.separateTitleRowColFromContent();
            this.isInverted = shouldBeInverted;
        }
    }

    public String[] titleRow() {
        return this.titleRow.toArray(new String[this.titleRow.size()]);
    }

    public String[] titleCol() {
        return this.titleCol.toArray(new String[this.titleCol.size()]);
    }

    public String toString() {
        return "Dataset (" + this.id + ")\n" + this.analyseMatrix;
    }

    protected void addLine(String[] line) {
        this.analyseMatrix.addLine(new ArrayList<String>(Arrays.asList(line)));
    }

    protected void analyseMatrix() {
        this.separateTitleRowColFromContent();
    }

    private void separateTitleRowColFromContent() {
        if (this.analyseMatrix.isEmpty()) {
            throw new ParserException("The dataset (line: " + this.getLineNr() + ") has no content");
        }
        List<String> firstRow = this.analyseMatrix.row(0);
        List<String> firstCol = this.analyseMatrix.col(0);
        boolean hasTitleRow = this.isTitleLine(firstRow);
        boolean hasTitleCol = this.isTitleLine(firstCol);
        if (hasTitleRow && hasTitleCol) {
            if (!firstRow.get(0).isEmpty() || !firstCol.get(0).isEmpty()) {
                throw new ParserException("If a dataset has a title row and column, the upper left space must be empty");
            }
            this.titleRow = firstRow.subList(1, firstRow.size());
            this.titleCol = firstCol.subList(1, firstCol.size());
        } else if (hasTitleRow && !hasTitleCol) {
            this.titleRow = firstRow;
            this.titleCol = this.createEmptyList(firstCol.size() - 1);
        } else if (!hasTitleRow && hasTitleCol) {
            this.titleRow = this.createEmptyList(firstRow.size() - 1);
            this.titleCol = firstCol;
        } else {
            this.titleRow = this.createEmptyList(firstRow.size());
            this.titleCol = this.createEmptyList(firstCol.size());
        }
        this.valueMatrix = new Matrix();
        int r = hasTitleRow ? 1 : 0;
        while (r < this.analyseMatrix.rows()) {
            List<String> row = this.analyseMatrix.row(r);
            ArrayList<Double> rowDouble = new ArrayList<Double>();
            int c = hasTitleCol ? 1 : 0;
            while (c < row.size()) {
                String val = row.get(c);
                try {
                    if (val == null) {
                        throw new NumberFormatException();
                    }
                    rowDouble.add(Double.parseDouble(val));
                }
                catch (NumberFormatException ex) {
                    throw new ParserException("The Dataset (line: " + this.getLineNr() + ") contains invalid values");
                }
                ++c;
            }
            this.valueMatrix.addLine(rowDouble);
            ++r;
        }
    }

    private boolean isTitleLine(List<String> row) {
        int numbersInRow = 0;
        for (String cell : row) {
            if (cell == null) continue;
            try {
                Double.parseDouble(cell);
                ++numbersInRow;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return row.size() - numbersInRow > numbersInRow;
    }

    private List<String> createEmptyList(int size) {
        ArrayList<String> returnList = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            returnList.add("");
            ++i;
        }
        return returnList;
    }
}

