/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.codecs.guitarPro.GPMeasure;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPTrack;
import dguitar.gui.Bar;
import dguitar.gui.BarMTP;
import dguitar.gui.DisplayOptions;
import dguitar.gui.MusicCursor;
import dguitar.gui.MusicCursorPosition;
import dguitar.gui.OptionsDisplay;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;

public class BarPanel
extends JPanel
implements OptionsDisplay {
    protected static Font repeatFont;
    protected static Font notesFont;
    protected static Font timeSignatureFont;
    protected static Font measureNumberFont;
    protected static Font graceNoteFont;
    public int LINES;
    public int H;
    private DisplayOptions displayOptions;
    private Vector barVector;

    public BarPanel() {
    }

    public BarPanel(DisplayOptions currentDisplayOptions) {
        if (currentDisplayOptions == null) {
            throw new NullPointerException("currentDisplayOptions display options passed to the BarPanel are null");
        }
        this.displayOptions = currentDisplayOptions;
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.initComponents();
        this.setRepeatFont(new Font("Arial", 3, 12));
        this.setNotesFont(new Font("Arial", 1, 11));
        this.setTimeSignatureFont(new Font("ITCCenturyBook", 1, 18));
        this.setMeasureNumberFont(new Font("Arial", 0, 9));
        this.setGraceNoteFont(new Font("Arial", 0, 9));
        this.barVector = new Vector(0, 1);
    }

    public void setDisplayOptions(DisplayOptions displayOptions) {
        this.displayOptions = displayOptions;
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    public MusicCursorPosition getMusicCursorPosition(int numMeasure, int numBeat) {
        MusicCursorPosition MCP = null;
        if (numMeasure >= 1 && numMeasure <= this.barVector.size()) {
            Bar bar = (Bar)this.barVector.get(numMeasure - 1);
            MCP = bar.getMusicCursorPosition(numBeat);
            Point p = MCP.getPoint();
            p.x += bar.getX();
            MCP.setPoint(p);
        }
        return MCP;
    }

    public MusicCursorPosition getMusicCursorPosition(int numMeasure, MusicCursor musicCursor) {
        MusicCursorPosition MCP = null;
        if (numMeasure >= 1 && numMeasure <= this.barVector.size()) {
            Bar bar = (Bar)this.barVector.get(numMeasure - 1);
            MCP = bar.getMusicCursorPosition(musicCursor);
            Point p = MCP.getPoint();
            p.x += bar.getX();
            MCP.setPoint(p);
        }
        return MCP;
    }

    public MusicCursorPosition snap(Point p, MusicCursor musicCursor) {
        Component comp = this.getComponentAt(p);
        Bar bar = (Bar)comp;
        int barX = bar.getX();
        MusicCursorPosition MCP = bar.snapX(p.x - barX, musicCursor);
        Point aux = MCP.getPoint();
        Point newP = new Point(barX + aux.x, aux.y);
        MCP.setPoint(newP);
        return MCP;
    }

    private void setLines(int value) {
        this.LINES = value;
        this.H = (this.LINES - 1) * this.displayOptions.LS;
    }

    public void setTrack(GPTrack t) {
        if (t != null) {
            this.setLines(t.getNumberOfStrings());
        }
    }

    public int getNoteSpacing() {
        return this.displayOptions.NS;
    }

    public void setNoteSpacing(int ns) {
        if (ns > 0) {
            this.displayOptions.NS = ns;
        }
    }

    public void setRepeatFont(Font f) {
        repeatFont = f;
    }

    public void setNotesFont(Font f) {
        notesFont = f;
    }

    public void setTimeSignatureFont(Font f) {
        timeSignatureFont = f;
    }

    public void setMeasureNumberFont(Font f) {
        measureNumberFont = f;
    }

    public void setGraceNoteFont(Font f) {
        graceNoteFont = f;
    }

    public void setMeasures(List Measures) {
        if (Measures != null) {
            Bar barPrev = null;
            if (Measures.size() == this.barVector.size()) {
                Iterator itMeasure = Measures.iterator();
                Iterator itBar = this.barVector.iterator();
                while (itMeasure.hasNext()) {
                    Bar bar = (Bar)itBar.next();
                    GPMeasure m = (GPMeasure)itMeasure.next();
                    bar.setMeasure(m);
                    bar.displayTimeSignature = !bar.equalTimeSignature(barPrev);
                    barPrev = bar;
                }
            } else {
                System.err.println("The number of measures and number of bars does not match");
            }
        }
    }

    public void setMeasureTrackPair(int measure, GPMeasureTrackPair mtp) {
        if (mtp != null && measure < this.barVector.size()) {
            try {
                BarMTP BMTP = (BarMTP)this.barVector.get(measure);
                BMTP.setMeasureTrackPair(mtp);
            }
            catch (ClassCastException CCE) {
                System.err.println("setMeasureTrackPair must be called on a BarPanel that contains BarMTP objects");
            }
        }
    }

    public Bar getBar(int measure) {
        Bar bar = null;
        try {
            bar = (Bar)this.barVector.get(measure);
        }
        catch (ClassCastException CCE) {
            System.err.println("Barpanel.barVector cotains en element that could not be casted to Bar !!");
        }
        return bar;
    }

    public void addBar(Bar bar) {
        if (bar != null) {
            this.barVector.add(bar);
            this.add(bar);
        }
    }

    public int getTopOffset() {
        return this.displayOptions.TopOffset;
    }

    public void setTopOffset(int topOffset) {
        if (topOffset > 0) {
            this.displayOptions.TopOffset = topOffset;
            Iterator it = this.barVector.iterator();
            while (it.hasNext()) {
                Bar bar = (Bar)it.next();
                bar.setTopOffset(topOffset);
            }
        }
    }

    public int getBottomOffset() {
        return this.displayOptions.BottomOffset;
    }

    public void setBottomOffset(int bottomOffset) {
        if (bottomOffset > 0) {
            Iterator it = this.barVector.iterator();
            this.displayOptions.BottomOffset = bottomOffset;
            while (it.hasNext()) {
                Bar bar = (Bar)it.next();
                bar.setTopOffset(bottomOffset);
            }
        }
    }

    public boolean getExtendBottom() {
        return this.displayOptions.extendBottom;
    }

    public void setExtendBottom(boolean value) {
        Iterator it = this.barVector.iterator();
        this.displayOptions.extendBottom = value;
        while (it.hasNext()) {
            Bar bar = (Bar)it.next();
            bar.setExtendBottom(value);
        }
    }

    public boolean getExtendTop() {
        return this.displayOptions.extendTop;
    }

    public void setExtendTop(boolean value) {
        Iterator it = this.barVector.iterator();
        this.displayOptions.extendTop = value;
        while (it.hasNext()) {
            Bar bar = (Bar)it.next();
            bar.setExtendTop(value);
        }
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(0, 0, 0));
    }
}

