/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.AbstractSimilarityProvider;

public class BM25SimilarityProvider
extends AbstractSimilarityProvider {
    private final BM25Similarity similarity;

    @Inject
    public BM25SimilarityProvider(@Assisted String name, @Assisted Settings settings) {
        super(name);
        float k1 = settings.getAsFloat("k1", Float.valueOf(1.2f)).floatValue();
        float b = settings.getAsFloat("b", Float.valueOf(0.75f)).floatValue();
        boolean discountOverlaps = settings.getAsBoolean("discount_overlaps", (Boolean)true);
        this.similarity = new BM25Similarity(k1, b);
        this.similarity.setDiscountOverlaps(discountOverlaps);
    }

    @Override
    public Similarity get() {
        return this.similarity;
    }
}

